<?php

class Purchase extends PurchaseContainer {

	private $_id;

	private $_availableAddonsCount = null;

	private $_purchases;

	private $_addons;

	private $_domains;

	private $_parentPurchase;

	public function __construct($planId, $cycleId, $priceId, $name, $type, $subscriptionId = null) {
		parent::__construct($planId, $cycleId, $priceId, $name, $type, $subscriptionId);
		$this->_id = ResourceLocator::getInstance()->cart->generatePurchaseId();
		$this->_purchases = array();
		$this->_addons = array();
		$this->_domains = array();
	}

	public function getId() {
		return $this->_id;
	}

	public function getPurchases($recursively = false) {
		if ($recursively) {
			$result = array();
			foreach ($this->_purchases as $purchase) {
				$result[$purchase->getId()] = $purchase;
				foreach ($purchase->getPurchases(true) as $subPurchase) {
					$result[$subPurchase->getId()] = $subPurchase;
				}
			}
			return $result;
		} else {
			return $this->_purchases;
		}
	}

	public function hasPurchase($id) {
		return isset($this->_purchases[$id]) ? true : false;
	}

	public function getPurchase($id) {
		return isset($this->_purchases[$id]) ? $this->_purchases[$id] : null;
	}

	public function addPurchase(Purchase $purchase) {
		$this->_purchases[$purchase->getId()] = $purchase;
		$purchase->setParentPurchase($this);
	}

	public function removePurchase($purchaseId) {
		if (isset($this->_purchases[$purchaseId])) {
			unset($this->_purchases[$purchaseId]);
		} else {
			foreach ($this->_purchases as $purchase) {
				$purchase->removePurchase($purchaseId);
			}
		}
	}

	public function setParentPurchase(Purchase $purchase)
	{
		$this->_parentPurchase = $purchase;
	}

	public function getParentPurchase()
	{
		return $this->_parentPurchase;
	}

	public function hasParentPurchase()
	{
		return ! is_null($this->_parentPurchase);
	}

	public function hasAddons() {
		return $this->_addons ? true : false;
	}

	public function getAddons($recursively = false) {
		$result = array();
		foreach ($this->_addons as $addons) {
			$result = array_merge($result, $addons);
		}
		if ($recursively) {
			foreach ($this->_purchases as $purchase) {
				foreach ($purchase->getAddons(true) as $addons) {
					$result = array_merge($result, array($addons));
				}
			}
		}
		return $result;
	}

	public function getCertificateAddons() {
		$store = sfContext::getInstance()->getUser()->getAttribute('store');
		$plan = $store->getPlan($this->getPlanId());
		$billingAddons = $plan->getAddons($store->getId(), $this->getCycleId());
		$result = array();
		foreach ($this->getAddons() as $addon) {
			$addonId = $addon->getAddonId();
			if (!isset($billingAddons[$addonId])) {
				continue;
			}
			if ($billingAddons[$addonId]->productType == BillingPlan::TYPE_SSL_CERTIFICATE) {
				$result[$addon->getId()] = $addon;
			}
		}
		return $result;
	}

	public function hasAddonByAddonId($addonId) {
		$result = false;
		foreach ($this->_addons as $addons) {
			foreach ($addons as $addon) {
				if ($result = ($addon->getAddonId() == $addonId)) {
					break;
				}
			}
			if ($result) {
				break;
			}
		}
		return $result;
	}

	public function addAddon($addonGroupId, Addon $addon) {
		if (!isset($this->_addons[$addonGroupId])) {
			$this->_addons[$addonGroupId] = array();
		}
		$this->_addons[$addonGroupId][$addon->getId()] = $addon;
	}

	public function removeAddon($id) {
		$result = false;
		foreach ($this->_addons as $addonGroupId => $addons) {
			if ($result = (isset($addons[$id]))) {
				unset($this->_addons[$addonGroupId][$id]);
				if (!$this->_addons[$addonGroupId]) {
					unset($this->_addons[$addonGroupId]);
				}
				break;
			}
		}
		if (!$result) {
			foreach ($this->_purchases as $purchase) {
				if ($result = $purchase->removeAddon($id)) {
					break;
				}
			}
		}
		return $result;
	}

	public function removeAddonByAddonGroupId($addonGroupId, $addonId = false) {
		if ($addonId) {
			if (isset($this->_addons[$addonGroupId])) {
				unset($this->_addons[$addonGroupId][$addonId]);
				if (!$this->_addons[$addonGroupId]) {
					unset($this->_addons[$addonGroupId]);
				}
			}
		} else {
			unset($this->_addons[$addonGroupId]);
		}
	}

	public function getAvailableAddonsCount() {
		if ($this->_availableAddonsCount == null) {
			$this->_availableAddonsCount = ResourceLocator::getInstance()->billingAddonGroupService->getCountByPlan(
				$this->getPlanId(),
				sfContext::getInstance()->getUser()->getAttribute('store')->getId(),
				$this->getCycleId()
			);
		}
		return $this->_availableAddonsCount;
	}

	public function hasOwnDomains() {
		return !empty($this->_domains) ? true : false;
	}

	public function getOwnDomains() {
		$result = array();
		if (isset($this->_domains)) {
			foreach ($this->_domains as $domainName => $domain) {
				$result[$domainName] = $domain;
			}
		}

		return $result;
	}

	public function addOwnDomain(array $domainData) {
		$this->_domains[$domainData["name"]] = $domainData;
	}

	public function removeOwnDomain($domainName) {
		$result = false;
		if (isset($this->_domains[$domainName])) {
			unset($this->_domains[$domainName]);
			$result = true;
		}
		return $result;
	}

	public function hasPurchasesByPlanId($planId)
	{
		foreach ($this->getPurchases() as $subPurchase) {
			if ($subPurchase->getPlanId() == $planId) {
				return true;
			}
		}
		return false;
	}
}