#!/usr/bin/perl

use vars qw($dumpDir $ptrArgs $workDir);
use strict;

use AgentConfig;

use Status;

use XmlNode;

#
# loadMainConfix() populates the following variables:
#
# $user_homeDir, $installDir, $stdShell, $mailSpool, $maildrop, $mailBoxName,
# $pop_homeDir, $scponly_shell, $majordomo_ldir, $backup_off
#
# $dbType, $dbServer, $dbUser, $dbPw, $dbDB, $dbPort
#
# $mysqlUserServer, $mysqlUserPort, $mysqlUserUser, $mysqlUserPw
#
# $mysql_sock 
#
# $confixx_IP $hostname
#



#
# confixx global parameters
#
use vars qw( $user_homeDir $installDir $stdShell $scponly_shell
						 $dbType $dbServer $dbUser $dbDB $dbPw $dbPort
						 $mysqlUserServer $mysqlUserUser $mysqlUserPw $mysqlUserPort
						 $mysql_sock $majordomo_ldir
						 $maildrop $pop_homeDir $mailBoxName $mailSpool $backup_off
                         $storage $confixx_IP $hostname);

#
# end confixx global parameters
#

#
# parse command line
#
my %arg_opts = ('--help|-h'=>'',
				'--config|-c'=>'s',
				'--get-status|-s'=>'',
				'--dump-accounts|-dc'=>'s',
				'--dump-domains|-dd'=>'s',
				'--dump-all|-da'=>'',
				'--get-content-list|-lc'=>'',
				'--no-content|-nc'=>'',
				'--no-compress|-nz'=>'',
				'--output|-o'=>'s',
				'--status-file|-sf'=>'s',
	       );

my %mapResLimits = ( 'max_subdom' => 'maxsubdomains',
										 'max_dom' => 'maxdomains',
										 'disk_space' => 'maxkb',
										 'max_traffic' => 'maxtransfer',
										 'max_db' => 'maxmysql',
										 'max_box' => 'maxpop',
										 'max_resp' => 'maxautoresponder',
										 'max_maillists' => 'maxmaillist',
										 'max_wu' => 'maxftp'
									 );

my %mapResPermis = ('create_domains' => 'maxdomains',
										'manage_phosting' => 'maxkunden',
										'manage_subdomains' => 'maxsubdomains',
										'change_limits' => 'maxkunden',
										'manage_dns' => 'dns',
										'manage_log' => 'maxkunde',
										'allow_local_backups' => 'backup',
										'manage_maillists' => 'maxmaillist',
										'manage_crontab' => 'maxcronjobs',
										'manage_spamfilter' => 'spamfilter'
									 );

my %mapResPinfo = ( 'company' => 'firma',
										'phone' => 'telefon',
										'fax' => 'fax',
										'address' => 'anschrift',
										'city' => 'plzort',
										'state' => '',
										'zip' => 'plz',
										'country' => 'land',
										'locale' => 'language',
										'email' => 'emailadresse' );

my %mapUserPinfo = ( 'company' => 'firma',
										 'phone' => 'telefon',
										 'fax' => 'fax',
										 'address' => 'anschrift',
										 'city' => 'plzort',
										 'state' => '',
										 'zip' => 'plz',
										 'country' => 'land',
										 'locale' => 'language',
										 'email' => 'emailadresse' );


my %mapCustLimits = ( 'max_subdom' => 'maxsubdomains',
											'disk_space' => 'maxkb',
											'max_traffic' => 'maxtransfer',
											'max_db' => 'maxmysql',
											'max_box' => 'maxpop',
											'max_resp' => 'maxautoresponder',
											'max_maillists' => 'maxmaillist',
											'max_wu' => 'maxftp'
										);


my %comulatLimits = ( 'max_db' => 1 );

my %mapCustPermis = ('manage_subdomains' => 'maxsubdomains',
										 'manage_log' => 1,
										 'manage_maillists' => 'maxmaillist',
										 'manage_crontab' => 'maxcronjobs',
										 'manage_webstat' => 'statistik',
										 'allow_local_backups' => 'backup',
										 'manage_spamfilter' => 'spamfilter'
										);

my %mapCustScripting = ('ssi'=>'ssi',
												'php'=>'php',
												'cgi'=>'perl',
												'perl'=>'perl');

my %mapLocales = ('de' => 'de-DE',
									'en' => 'en-US',
									'es' => 'es-ES',
									'fr' => 'fr-FR',
									'gr' => 'el-GR',
									'it' => 'it-IT',
									'ru' => 'ru-RU');

my %mapCountries = ('deutschland' => 'DE',
									'afghanistan' => 'AF',
									'albania' => 'AL',
									'algeria' => 'DZ',
									'american samoa' => 'AS',
									'andorra' => 'AD',
									'angola' => 'AO',
									'anguilla' => 'AI',
									'antigua and barbuda' => 'AG',
									'argentina' => 'AR',
									'armenia' => 'AM',
									'aruba' => 'AW',
									'australia' => 'AU',
									'austria' => 'AT',
									'azerbaijan' => 'AZ',
									'bahamas' => 'BS',			
									'bahrain' => 'BH',
									'bangladesh' => 'BD',
									'barbados' => 'BB',
									'belarus' => 'BY',
									'belgium' => 'BE',
									'belize' => 'BZ',
									'benin' => 'BJ',
									'bermuda' => 'BM',
									'bhutan' => 'BT',
									'bolivia' => 'BO',
									'bosnia and herzegovina' => 'BA',
									'botswana' => 'BW',
									'brazil' => 'BR',
									'brunei' => 'BN',
									'bulgaria' => 'BG',
									'burkina faso' => 'BF',
									'burundi' => 'BI',
									'cambodia' => 'KH',
									'cameroon' => 'CM',
									'canada' => 'CA',
									'cape verde' => 'CV',
									'central african republic' => 'CF',
									'chad' => 'TD',
									'chile' => 'CL',
									'china' => 'CN',
									'colombia' => 'CO',
									'congo' => 'CG',
									'costa rica' => 'CR',
									'croatia' => 'HR',
									'cuba' => 'CU',
									'cyprus' => 'CY',
									'czech republic' => 'CZ',
									'denmark' => 'DK',
									'djibouti' => 'DJ',
									'dominica' => 'DM',
									'dominican republic' => 'DO',
									'ecuador' => 'EC',
									'egypt' => 'EG',
									'el salvador' => 'SV',
									'equatorial guinea' => 'GQ',
									'eritrea' => 'ER',
									'estonia' => 'EE',
									'ethiopia' => 'ET',
									'faroe islands' => 'FO',
									'fiji' => 'FJ',
									'finland' => 'FI',
									'france' => 'FR',
									'gabon' => 'GA',
									'gambia' => 'GM',
									'georgia' => 'GE',
									'germany' => 'DE',
									'ghana' => 'GH',
									'gibraltar' => 'GI',
									'greece' => 'GR',
									'greenland' => 'GL',
									'grenada' => 'GD',
									'guadeloupe' => 'GP',
									'guam' => 'GU',
									'guatemala' => 'GT',
									'guinea' => 'GN',
									'guinea-bissau' => 'GW',
									'guyana' => 'GY',
									'haiti' => 'HT',
									'honduras' => 'HN',
									'hong kong' => 'HK',
									'hungary' => 'HU',
									'iceland' => 'IS',
									'india' => 'IN',
									'indonesia' => 'ID',
									'iran' => 'IR',
									'iraq' => 'IQ',
									'ireland' => 'IE',
									'israel' => 'IL',
									'italy' => 'IT',
									'jamaica' => 'JM',
									'japan' => 'JP',
									'jordan' => 'JO',
									'kazakhstan' => 'KZ',
									'kenya' => 'KE',
									'korea republic' => 'KR',
									'kuwait' => 'KW',
									'kyrgyzstan' => 'KG',
									'latvia' => 'LV',
									'lebanon' => 'LB',
									'lesotho' => 'LS',
									'liberia' => 'LR',
									'liechtenstein' => 'LI',
									'lithuania' => 'LT',
									'luxembourg' => 'LU',
									'macao' => 'MO',
									'macedonia' => 'MK',
									'madagascar' => 'MG',
									'malawi' => 'MW',
									'malaysia' => 'MY',
									'maldives' => 'MV',
									'mali' => 'ML',
									'malta' => 'MT',
									'martinique' => 'MQ',
									'mauritania' => 'MR',
									'mauritius' => 'MU',
									'mayotte' => 'YT',
									'mexico' => 'MX',
									'moldova' => 'MD',
									'monaco' => 'MC',
									'mongolia' => 'MN',
									'montenegro' => 'ME',
									'montserrat' => 'MS',
									'morocco' => 'MA',
									'mozambique' => 'MZ',
									'myanmar' => 'MM',
									'namibia' => 'NA',
									'nauru' => 'NR',
									'nepal' => 'NP',
									'netherlands' => 'NL',
									'netherlands antilles' => 'AN',
									'new caledonia' => 'NC',
									'new zealand' => 'NZ',
									'nicaragua' => 'NI',
									'niger' => 'NE',
									'nigeria' => 'NG',
									'norway' => 'NO',
									'oman' => 'OM',
									'pakistan' => 'PK',
									'palau' => 'PW',
									'panama' => 'PA',
									'papua new guinea' => 'PG',
									'paraguay' => 'PY',
									'peru' => 'PE',
									'philippines' => 'PH',
									'pitcairn' => 'PN',
									'poland' => 'PL',
									'portugal' => 'PT',
									'puerto rico' => 'PR',
									'qatar' => 'QA',
									'reunion' => 'RE',
									'romania' => 'RO',
									'russia' => 'RU',
									'rwanda' => 'RW',
									'samoa' => 'WS',
									'san marino' => 'SM',
									'saudi arabia' => 'SA',
									'senegal' => 'SN',
									'serbia' => 'RS',
									'seychelles' => 'SC',
									'sierra leone' => 'SL',
									'singapore' => 'SG',
									'slovakia' => 'SK',
									'slovenia' => 'SI',
									'somalia' => 'SO',
									'south africa' => 'ZA',
									'spain' => 'ES',
									'sri lanka' => 'LK',
									'sudan' => 'SD',
									'suriname' => 'SR',
									'swaziland' => 'SZ',
									'sweden' => 'SE',
									'switzerland' => 'CH',
									'syrian' => 'SY',
									'taiwan' => 'TW',
									'tajikistan' => 'TJ',
									'tanzania' => 'TZ',
									'thailand' => 'TH',
									'togo' => 'TG',
									'tokelau' => 'TK',
									'tonga' => 'TO',
									'trinidad and tobago' => 'TT',
									'tunisia' => 'TN',
									'turkey' => 'TR',
									'turkmenistan' => 'TM',
									'tuvalu' => 'TV',
									'uganda' => 'UG',
									'ukraine' => 'UA',
									'united arab emirates' => 'AE',
									'united kingdom' => 'GB',
									'united states' => 'US',
									'uruguay' => 'UY',
									'uzbekistan' => 'UZ',
									'vanuatu' => 'VU',
									'venezuela' => 'VE',
									'vietnam' => 'VN',
									'western sahara' => 'EH',
									'yemen' => 'YE',
									'zambia' => 'ZM',
									'zimbabwe' => 'ZW'
);

my %mapTemplate = ( 'php' => [ 'php', 'L' ],   ##  xmlNameAttribute => [ fieldName, typeOfItem ]
										'perl' => [ 'perl', 'L' ],
										'python' => [ 'modpython', 'L' ],
										'ssi' => [ 'ssi', 'L' ],
										'errdocs' => [  'fehlerseiten', 'L' ],
										'webmail' => [  'webmail', 'L' ],
										'asp' => [ 'asp', 'L' ],
										'fp' => [ 'frontpage', 'L' ],
										'coldfusion' => [ 'coldfusion', 'L' ],
										'manage_webstat' => [ 'statistik', 'L' ],			
										'maillists' => [ 'maxmaillist', 'L' ],
										'max_box' => [ 'maxpop', 'N' ],
										'max_db' => [ 'maxmysql', 'N' ] ,
										'max_wu' => [ 'maxftp', 'N' ],
										'max_subdom' => [ 'maxsubdomains', 'N' ],
										'max_maillists' => [ 'maxmaillist', 'N' ],
										'disk_space' => [ 'maxkb', 'B' ],
										'max_traffic' => [ 'maxtransfer', 'B' ],
										'max_resp' => ['maxautoresponder', 'N'],
										'total_mboxes_quota' => ['popmaxkb', 'B'],
										'manage_crontab' => [ 'maxcronjobs', 'L' ],
										'manage_maillists' => [ 'maxmaillist', 'L' ],
										'maillist' => [ 'maxmaillist', 'L' ],
										'manage_subdomains' => [ 'maxsubdomains', 'L' ],
										'allow_local_backups' => [ 'backup', 'L' ],
										'manage_spamfilter' => ['spamfilter', 'L']
									);

my $filedate;
my $mailboxType; # mbox or mdir
my $dbId = 1; # user mysql db counter
my $mailuserId = 1; # mail user counter
my $mailQuotaValue; # mailbox quota 

#
# global variables
#
my (%preparedCustomers, %exclIp, %idn2Utf8cache);

# hashes with xmls for reselles, customers, domains
my (%r_nodes, %c_nodes, %d_nodes);
#
# end global variables
#

require "agent.include.pl";

$ptrArgs = &getArguments (\@ARGV,\%arg_opts);

my ($outPath,$dumpDir,$dumpFile,$statusFile,$workDir);

$workDir = AgentConfig::cwd();

$dumpFile = $workDir.'/dump.xml';
$statusFile = $workDir.'/dumping-status.xml';
$dumpDir = $workDir.'/pma';

my $objDumpStatus = &makeDumpStatus($ptrArgs->{'status-file'}||$statusFile);
my $nocontent = (exists $ptrArgs->{'no-content'})?1:0;
my $contentIncluded = $nocontent == 0 ? 'true' : 'false';

#
# find & load main config
#

my $rootName = 'migration-dump';

unless ( loadMainConfig( $ptrArgs->{'config'} ) ) {

  if ( exists $ptrArgs->{'get-status'} ) {
    printAgentStatus();
    exit 0;
  }else{
    if ( exists( $ptrArgs->{'dump-all'} ) ||
         exists( $ptrArgs->{'dump-accounts'} ) ||
         exists( $ptrArgs->{'dump-domains'} ) ) {

	  die "Error: confixx config file 'confixx_main.conf' is not found\n";
	}
  }
}

my ($majorVersion, $minorVersion, $patchLevel) = getConfixxVersion();

#
# get db connect
#

my $wrapDbh = getDbConnect($dbType, $dbUser, $dbPw, $dbDB, $dbServer);
unless ($wrapDbh) {
  die "Error: can not connect to confixx database\n";
}


my $wrapUserMysql;
if ($mysqlUserUser) {
  my $socket = $mysqlUserPort if -S $mysqlUserPort;
  my $port = $mysqlUserPort if $mysqlUserPort =~ /^\d+$/;

  $wrapUserMysql = getDbConnect('mysql', $mysqlUserUser, $mysqlUserPw,
								'mysql', $mysqlUserServer, undef, $socket, undef, undef, $port);
}

#
# get MIME Base64 encoder
#
my $wrapBase64 = makeMIMEBase64();

my $ID=0;

if(exists $ptrArgs->{'get-status'}){
  printAgentStatus();
  exit 0;
}elsif(exists ($ptrArgs->{'dump-all'}) ||
       exists ($ptrArgs->{'dump-accounts'}) ||
       exists ($ptrArgs->{'dump-domains'})){

  my ($root,@accounts,@domains,$ptrAccounts,$ptrDomains, $value);

  initStorage();

  getDumpDir($dumpDir);

  if (exists $ptrArgs->{'no-compress'}) {
	setCompress(0);
  }

  &printToLog("Work dir: $workDir");
  &printToLog("Dump file: $dumpFile");
  &printToLog("Status file: ".$objDumpStatus->{'FILE'}->());


  if ($value = $ptrArgs->{'dump-accounts'}){
  	if ($value eq "-") {
		$value = <STDIN>;
		chomp $value;
	}
    @accounts = split(/\s*,\s*/,$value);
    $ptrAccounts = \@accounts;
  }

  if ($value = $ptrArgs->{'dump-domains'}){
  	if ($value eq "-") {
		$value = <STDIN>;
		chomp $value;
	}
    @domains = split(/\s*,\s*/,$value);
    $ptrDomains = \@domains;

	# translate domains into ASCII representation
	foreach my $domain (@domains) {
		next if ($domain =~ /^[\x00-\x7f]*$/);
		my $idn = &utf8ToIdn($domain);
		$idn2Utf8cache{$idn} = $domain;
		$domain = $idn;
	}
  }

  my $sql = "SELECT popmaxkbhard FROM admin";
  if($wrapDbh->{'EXECUTE'}->($sql)){
          if( my $ptrRow = $wrapDbh->{'FETCHROW'}->()){
                 $mailQuotaValue = $ptrRow->[0];
          }
  }
  $wrapDbh->{'FINISH'}->();
  
#
# generate a xml dump
#

  $filedate = &getFileDate();
  $root = &getConfixx2PleskDump($dumpDir, $ptrAccounts, $ptrDomains);

#
# print dump to output
#

  my $currentOutput = $ptrArgs->{'output'};
  
  my $adminResourceId = getResourceId('admin');
  $root = &fixContentPath($root, undef, undef, undef);
  $storage->finish($root);
  $storage->writeDiscovered('','dump.xml', 1000, $adminResourceId, 'server', $adminResourceId, 'admin');


# new make resources tree

  while ((my $reseller,$root)=each(%r_nodes)){
    initStorage('', '/resellers/'.$reseller.'/');
    my $resdump =  XmlNode->new('migration-dump', 'attributes'=>{'content-included' => $contentIncluded, 'agent-name'=>'ConfixxX', 'dump-version'=>'9.0.0'});
    $root = fixContentPath($root, $reseller, undef, undef);
    $resdump->addChild($root);
    $storage->finish($resdump, '', 'backup_'.$reseller.'_info_'.$filedate);
    my $resellerResourceId = getResourceId($reseller);
    $storage->writeDiscovered('','backup_'.$reseller.'_info_'.$filedate, 1000, $adminResourceId, 'server', $resellerResourceId, $reseller);
    my $c_hash = $c_nodes{$reseller};
    while ((my $client,$root)=each(%{$c_hash})){
	initStorage('', '/resellers/'.$reseller.'/'.$client.'/');	
	$resdump =  XmlNode->new('migration-dump', 'attributes'=>{'content-included' => $contentIncluded, 'agent-name'=>'ConfixxX', 'dump-version'=>'9.0.0'});
	# add path processing
	$root = &fixContentPath($root, $reseller, $client, undef);
	$resdump->addChild($root);
	$storage->finish($resdump, '', 'backup_'.$client.'_info_'.$filedate);
	my $clientResourceId = getResourceId($client);
	$storage->writeDiscovered('','backup_'.$client.'_info_'.$filedate, 1000, $adminResourceId, 'server', $clientResourceId, $client);
	my $d_hash = $d_nodes{$client};
	while ((my $domain,$root)=each(%{$d_hash})){
		initStorage('', '/resellers/'.$reseller.'/'.$client.'/'.$domain.'/');		
		$resdump =  XmlNode->new('migration-dump', 'attributes'=>{'content-included' => $contentIncluded, 'agent-name'=>'ConfixxX', 'dump-version'=>'9.0.0'});
		$root = &fixContentPath($root, $reseller, $client, $domain);
		$resdump->addChild($root);
		$storage->finish($resdump, '', 'backup_'.$domain.'_info_'.$filedate);
		my $domainResourceId = getResourceId($domain);
		$storage->writeDiscovered('','backup_'.$domain.'_info_'.$filedate, 1000, $adminResourceId, 'server', $domainResourceId, $domain);
	}
    }
  }  
}elsif(exists $ptrArgs->{'get-content-list'}){
  makeContentList();
}else{
  &printHelp();
}

exit 0;

#
# end main
#
#==============================================================

#==============================================================
#
# confixx subroutines
#

my (%admin); ## hash with admin settings


sub getConfixx2PleskDump{
  my($dumpDir,$ptrAccounts,$ptrDomains) = @_;
  my ($item,$dump,$reseller,%resellers,%customers,$sql,$ptrRow,
     $ptrResellers,$full,$itemResellersNode,$adminNode );

  $dump =  XmlNode->new('migration-dump', 'attributes'=>{'content-included' => $contentIncluded, 'agent-name'=>'ConfixxX', 'dump-version'=>'9.0.0'});
  $adminNode = XmlNode->new('admin', 'attributes'=> {'guid' => &getResourceId('admin')});
  $dump->addChild($adminNode);

  unless(ref($wrapDbh)=~/HASH/ && ref($wrapDbh->{'EXECUTE'})=~/CODE/){
    $dump->{'CONTENT'}->("Error: there is no connect to database");
    &printToError("Error: unable to connect to SQL database");
    return $dump; 
  }

#
# get admin settings
#
	$sql = "SELECT * FROM admin";
	if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
		my ( $ptrHash );
		if ( $ptrHash = $wrapDbh->{'FETCHHASH'}->() ) {
			%admin = %{$ptrHash};
		}
	}
	$wrapDbh->{'FINISH'}->();
#
# end get admin settings
#

  printToLog('Reading IP information ...',1);
  readIpInfo();
  printToLog(' OK');

#
# prepare reseller
#
  if(
	(ref($ptrAccounts)=~/ARRAY/ && (@{$ptrAccounts}>0)) ||
	(ref($ptrDomains)=~/ARRAY/ && (@{$ptrDomains}>0))
  ){
	my (@res,@cust,$acc,$list);
	if (ref($ptrAccounts)=~/ARRAY/){
		foreach $acc (@{$ptrAccounts}){
			if ($acc=~/^res\d+$/){
				$resellers{$acc}=1;
			}else{
				$customers{$acc}=1;
			}
		}
	}
	$list = join(',',map {"'$_'"} keys %customers);
	if($list){
		$sql = "select distinct anbieter from kunden where (kunde in ($list))";
		if($wrapDbh->{'EXECUTE'}->($sql)){
			while( $ptrRow = $wrapDbh->{'FETCHROW'}->()){
				$acc = $ptrRow->[0];
				unless(exists $resellers{$acc}){
					$resellers{$acc} = 0;
				}
			}
		}
		$wrapDbh->{'FINISH'}->();
	}

	if (ref($ptrDomains)=~/ARRAY/){
		$list = join(',',map {"'$_'"} @{$ptrDomains});
		if($list){
			$sql = "select distinct anbieter,kunde from domains where (domain in ($list))";
			if($wrapDbh->{'EXECUTE'}->($sql)){
				while( $ptrRow = $wrapDbh->{'FETCHROW'}->()){
					$acc = $ptrRow->[0];
					unless(exists $resellers{$acc}){
						$resellers{$acc} = 0;
					}
					$acc = $ptrRow->[1];
					unless(exists $customers{$acc}){
						$customers{$acc} = 0;
					}
				}
			}
			$wrapDbh->{'FINISH'}->();
		}
	}
  }else{
	if($wrapDbh->{'EXECUTE'}->("select anbieter from anbieter")){
		while($ptrRow = $wrapDbh->{'FETCHROW'}->()){
			$resellers{$ptrRow->[0]}=1;
		}
	}
	$wrapDbh->{'FINISH'}->();
  }
  $ptrResellers = \%resellers;

  my $domainsCount = 0;
  if ($ptrDomains) {
	$domainsCount = scalar(@{$ptrDomains});
  }

  $objDumpStatus->{'COUNTS'}->(scalar (keys %resellers), $domainsCount);

  my %leftResellers = %resellers;
  my ($list);

  $itemResellersNode = XmlNode->new('resellers');
  $adminNode->addChild($itemResellersNode);

  while (($reseller,$full)=each(%resellers)){
    &printToLog("Client '$reseller' is started");
	#
	# work with status of dump
	#
    $objDumpStatus->{'ACCOUNT'}->($reseller);
    $objDumpStatus->{'PRINT'}->();
    $list = join(',',map {"'$_'"} keys %leftResellers);
    if($list){
      $sql = "SELECT count(domain) FROM domains WHERE (richtigedomain in (0,1)) ".
				" AND (anbieter in ($list))";
      if($wrapDbh->{'EXECUTE'}->($sql)){
				if($ptrRow = $wrapDbh->{'FETCHROW'}->()){
					$domainsCount = $ptrRow->[0];
				}
      }
      $wrapDbh->{'FINISH'}->();
    }else{
      $domainsCount=0;
    }

    $objDumpStatus->{'PRINT'}->();

	#
	# end work with status of dump
	#

    $item = &makeResellerNode($reseller,$full,\%customers,$ptrDomains);
    if(ref($item)=~/XmlNode/ && ref($item->{'PRINT'})=~/CODE/){
      $itemResellersNode->addChild($item);
      $r_nodes{$reseller} = $item; # save reselles node
      &printToLog("Client '$reseller' is successfully dumped");
    }else{
      &printToLog("Client '$reseller' is not dumped");
    }

    delete $leftResellers{$reseller};
  }

  $objDumpStatus->{'COUNTS'}->(0,0);
  $objDumpStatus->{'PRINT'}->();

#
# end prepare reseller
#

# admin preferences
  my %adminPersonalInfo; 
  my $adminPrefNode = XmlNode->new('preferences');

  $sql = "SELECT firma,telefon,fax,anschrift,plzort,plz,land,emailadresse FROM personalinfo";
  if($wrapDbh->{'EXECUTE'}->($sql)){
  	if ( my $personalinfoHash = $wrapDbh->{'FETCHHASH'}->() ) {
		%adminPersonalInfo = %{$personalinfoHash};
         }
  }
  $wrapDbh->{'FINISH'}->();
  $adminPersonalInfo{'language'} = $admin{'language'};
  &addPinfo($adminPrefNode,\%adminPersonalInfo,\%mapResPinfo, 1);
  $adminNode->addChild($adminPrefNode);

  my $serverNode = &makeServerNode();
  $dump->addChild($serverNode);
  return $dump;
}


#
# sub makeResellerNode
#            - create a 'client'-node
# Arguments:
#            $nameRes   - name of reseller
#            $full      - 1 dump all domains of the reseller
#            $$ptrCustomersHash
#                       - reference to hash of customer-info to dump
#            $ptrDomainsArr
#                       - reference to array of domains to dump

sub makeResellerNode {
  my $nameRes = shift;
  my $full = shift;
  $full = 1 unless defined($full);
  my $ptrCustomersHash = shift || {};
  my $ptrDomainsArr = shift || [];

  my ($node,$subNode,$modeNode,$root,$sql,$ptrHash,$kunde,$ptrRow);

  $sql = "select * from anbieter where anbieter ='$nameRes'";

  unless( $wrapDbh->{'EXECUTE'}->( $sql ) ){
    $wrapDbh->{'FINISH'}->();
    return undef;
  }
  unless( $ptrHash = $wrapDbh->{'FETCHHASH'}->() ){
    $wrapDbh->{'FINISH'}->();
    return undef;
  }
  $wrapDbh->{'FINISH'}->();
  
  $root = XmlNode->new('reseller', 'attributes' => {'name' => $nameRes, 'guid' => &getResourceId($nameRes)});
			
  my $preferencesNode = XmlNode->new('preferences');			
  &addPinfo($preferencesNode,$ptrHash,\%mapResPinfo, 1);
  
  #
  ## templates
  ##
  {
	my (%templates, $name, $ident, $ptrRow );
	$sql = "SELECT ident,name FROM angebote WHERE anbieter='$nameRes'";
	$wrapDbh->{'EXECUTE'}->($sql);
	while ( $ptrRow = $wrapDbh->{'FETCHROW'}->() ) {
		($ident,$name) = @{$ptrRow};
		while ( exists( $templates{$name} ) ) { ## get an unique name of template
			$name .= '_'.$ident;
		}
		$templates{$name} = $ident;
	}
	$wrapDbh->{'FINISH'}->();
	&addTemplates( $preferencesNode, \%templates, $ptrHash );
  }
  #
  #                                                                                                                                                          # end templates
  ##
  
  $root->addChild($preferencesNode);
  
  $root->setAttribute('contact',$nameRes);

  $node = XmlNode->new('properties');
  $subNode = &makePasswordNode( $ptrHash->{'longpw'} );
  $node->addChild($subNode);
  
  $subNode = XmlNode->new('status');

  if($ptrHash->{'gesperrt'}) {
    $modeNode = XmlNode->new('disabled-by', 'attributes' => {'name' => 'admin'});
  } else {
    $modeNode = XmlNode->new('enabled');
  }

  $subNode->addChild($modeNode);
  $node->addChild($subNode);
  $root->addChild($node);

  $node = XmlNode->new('limits-and-permissions');
  &addLimits($node,$ptrHash,\%mapResLimits);
  &addPermissions($node,$ptrHash,\%mapResPermis);
  $root->addChild($node);

  # IP-pool
  my @ips = getIpPool($nameRes);
  if (@ips) {
	my $ip_pool = XmlNode->new('ip_pool');

	foreach my $ip (@ips) {
		$ip_pool->addChild(makeIpNode($ip));
	}
	$root->addChild($ip_pool);
  }

  my ( %c_hash, @clients, %clientsOfCurrentRes );
  if ($full ) {
	$sql = "SELECT kunde FROM kunden WHERE anbieter='$nameRes'";
	$wrapDbh->{'EXECUTE'}->($sql);
	while ( $ptrRow = $wrapDbh->{'FETCHROW'}->() ) {
  		push @clients, @{$ptrRow}[0];
		$clientsOfCurrentRes{$ptrRow->[0]} = 1; # set full = 1
	}
	$wrapDbh->{'FINISH'}->();
  } else {
	my $list = join(',',map {"'$_'"} keys %{$ptrCustomersHash});
	if ($list) {
		$sql = "SELECT kunde FROM kunden WHERE anbieter='$nameRes' AND kunde in ($list)";
		if ($wrapDbh->{'EXECUTE'}->($sql)){
			while( $ptrRow = $wrapDbh->{'FETCHROW'}->()){
				$clientsOfCurrentRes{$ptrRow->[0]} = ${$ptrCustomersHash}{$ptrRow->[0]};
			}
		}			
	}
  }
  if (scalar(keys %clientsOfCurrentRes) > 0) {
	my $clientsNode = XmlNode->new('clients');
	foreach $kunde (keys %clientsOfCurrentRes) {
		$subNode = &makeCustomerNode($nameRes,$kunde,$clientsOfCurrentRes{$kunde},$ptrDomainsArr, $ptrHash);
		$c_hash{$kunde} = $subNode; # save client node
		$clientsNode->addChild($subNode);
        }
	$c_nodes{$nameRes} = \%c_hash;
	$root->addChild($clientsNode);
  }
  return $root;
}

sub makeCustomerNode {
  my $nameRes = shift;
  my $nameCust = shift;
  my $full = shift;
  $full = 1 unless defined($full);
  my $ptrDomainsArr = shift || [];
  my $refResRow = shift; # hash with resseler info

  my ($node,$subNode,$modeNode,$root,$sql,$ptrHash,$ptrRow);
  my (%custHash,$customer);

  $sql = "select * from kunden where kunde ='$nameCust'";

  unless( $wrapDbh->{'EXECUTE'}->( $sql ) ){
    $wrapDbh->{'FINISH'}->();
    return undef;
  }
  unless( $ptrHash = $wrapDbh->{'FETCHHASH'}->() ){
    $wrapDbh->{'FINISH'}->();
    return undef;
  }
  %custHash = %{$ptrHash};

  $root = XmlNode->new('client', 'attributes' => {'name' => $nameCust, 'guid' => &getResourceId($nameCust), 'owner-guid' => &getResourceId($nameRes)});

  $root->setAttribute('contact',$nameCust);

  &addPinfo( $root, \%custHash, \%mapUserPinfo);
  $node = XmlNode->new('properties');

  $subNode = &makePasswordNode( $ptrHash->{'longpw'} );
  $node->addChild($subNode);
	
  $subNode = XmlNode->new('status');

  if($ptrHash->{'gesperrt'}) {
	$modeNode = XmlNode->new('disabled-by', 'attributes' => {'name' => 'admin'});
  } else {
	$modeNode = XmlNode->new('enabled');
  }

  $subNode->addChild($modeNode);
  $node->addChild($subNode);

  $root->addChild($node);

  $node = XmlNode->new('limits-and-permissions');

  &addLimits($node, \%custHash, \%mapCustLimits);

  $mapCustPermis{'make_dumps'} = $custHash{'backup'}==0? 0: 1;

  # default value, as confixx has no the corresponding option
  $mapCustPermis{'multiple-sessions'} = 1;
                
  &addPermissions($node, \%custHash,\%mapCustPermis);
		
  $root->addChild($node);

  $wrapDbh->{'FINISH'}->();


  # IP-pool
  my $customerIP = getClientIP($nameCust, $nameRes);
  
  if ($customerIP) {
	my $ip_pool = XmlNode->new('ip_pool');
	$root->addChild($ip_pool);
	$ip_pool->addChild(makeIpNode($customerIP));
  }

  my (@domains,$domain,@subdomains,$subdomain,@addSubDomain,%allSubDomains,
	$ptrDomains,$ptrSubdomains,%do2ku);
		 
  if( $full ){
	$sql = "SELECT domain FROM domains WHERE (richtigedomain=1) AND (kunde='$nameCust')";
	$wrapDbh->{'EXECUTE'}->($sql);
	while ($ptrRow = $wrapDbh->{'FETCHROW'}->()){
		push @domains, $ptrRow->[0]; 
		$do2ku{$ptrRow->[0]} = $nameCust;
	}
	$wrapDbh->{'FINISH'}->();
  }else{
	my $list = join(',',map {"'$_'"} @{$ptrDomainsArr});
	if($list){
		$sql = "SELECT domain FROM domains WHERE richtigedomain IN (0,1) ".
			"AND (kunde='$nameCust') AND (domain IN ($list))";
		$wrapDbh->{'EXECUTE'}->($sql);
		while ($ptrRow = $wrapDbh->{'FETCHROW'}->()){
			push @domains,$ptrRow->[0];
			$do2ku{$ptrRow->[0]} = $nameCust;
		}
		$wrapDbh->{'FINISH'}->();
	}
  }
  my %d_hash;       # hash for domain xml data
  if (scalar(@domains) > 0) {
	$node = XmlNode->new('domains');

	my ($initFactor,%limitFactor,$cnt,$newFactor,$countExtraDomains,$kunde);
	%limitFactor = map {$_ => 1} @domains;
	my $domainCounter = 0;
	while( @domains ){
		$domain = shift @domains;
		$domainCounter++;
		&printToLog("Domain '$domain' is started");

		$objDumpStatus->{'DOMAIN'}->($domain);
		$objDumpStatus->{'PRINT'}->();

		%allSubDomains = ($domain => 1);
		my $newDomainNode;
		($ptrDomains,$ptrSubdomains,$newDomainNode) = &addDomainNode($nameCust,$domain,$customerIP,$refResRow,$nameRes,$domainCounter);		
		$d_hash{$domain} = $newDomainNode; # save domain node
		$node->addChild($newDomainNode);
					    
		map { $allSubDomains{$_} = 1 } @{$ptrSubdomains}; ## add prepared subdomains

		if ( $cnt = @subdomains = @{$ptrDomains} ) {

#
# calculate adjustment factor
#
			$limitFactor{$domain} ||= 1;
			$newFactor = $limitFactor{$domain}*($cnt+1); ## subdomains + $domain
			$limitFactor{$domain} = $newFactor;
			map { $limitFactor{$_} = $newFactor } @subdomains;

#
# translate subdomain to domains
#
			while ( @subdomains ) {
				$subdomain = shift(@subdomains);
				&printToLog ( "transfer subdomain '$subdomain' to domain is started" );

				$objDumpStatus->{'DOMAIN'}->($subdomain);
				$objDumpStatus->{'PRINT'}->();

				$allSubDomains{$subdomain} = 1; ## add transfered to domain subdomain
				$do2ku{$subdomain} = $nameCust;
				$domainCounter++;
				($ptrDomains,$ptrSubdomains,$newDomainNode) = &addDomainNode($nameCust,$subdomain,$customerIP,$refResRow,$nameRes, $domainCounter);
				$d_hash{$subdomain} = $newDomainNode; # save domain node
				$node->addChild($newDomainNode);
                                $countExtraDomains++;

				map { $allSubDomains{$_} = 1 } @{$ptrSubdomains}; ## add prepared subdomains
				push @subdomains,@{$ptrDomains};

#
# calculate adjustment factor
#
				if ( $cnt = @{$ptrDomains} ) {
					$limitFactor{$subdomain} ||= 1;
					$newFactor = $limitFactor{$subdomain}*($cnt+1); ## subdomains + $domain
					$limitFactor{$subdomain} = $newFactor;
					map { $limitFactor{$_} = $newFactor } @{$ptrDomains};
				}
				&printToLog ( "subdomain '$subdomain' is transfered" );
                        }
                }

#
# add to domain subdomains with yet not processed
#
                my $list = join(',',map {"'$_'"} keys %allSubDomains);
                if ( $list ) {
                        my (%subdom,$cnt,@pnts);
                        $sql = "SELECT domain FROM domains WHERE richtigedomain = 0 AND ".
                                " ( domain like '\%.$domain' ) AND NOT ( domain IN ($list) )";
			$wrapDbh->{'EXECUTE'}->($sql);
			while ($ptrRow = $wrapDbh->{'FETCHROW'}->()){
				$cnt = @pnts = ($ptrRow->[0] =~ /\./g);  ## get level of subdomain (count of dot)
				if ( $ptrRow->[0] =~ /\*/ ) { ## skip wildcard-subdomains
					$allSubDomains{$ptrRow->[0]} = 1;
				} else {
					push @{$subdom{$cnt}},$ptrRow->[0];
				}
			}
			$wrapDbh->{'FINISH'}->();
			if ( %subdom ) {
#
# claculate minimum of subdomain's levels
#
				my $minCnt = (sort { $a <=> $b } keys %subdom)[0];

#
# transfer subdomain to domain
#
				map {
					push( @domains, $_ );
					$do2ku{$_} = $nameCust;
					$countExtraDomains++;
				} @{$subdom{$minCnt}};

#
# recalc limit factor
#
				my ($newFactor,$delta,$reDomain,$oldFactor);

				$limitFactor{$domain} ||= 1;
				$oldFactor = $limitFactor{$domain};
				$newFactor = @{$subdom{$minCnt}}+$oldFactor;

## correct old factor for currect domain
				$delta = $newFactor/$oldFactor;
				$reDomain = qr/\Q$domain\E$/;
				map { $limitFactor{$_} *= $delta if /$reDomain/ } keys %limitFactor;

## add new factor
				map { $limitFactor{$_} = $newFactor } @{$subdom{$minCnt}};

			}
		}
		&printToLog("Domain '$domain' is dumped");
	}
	$root->addChild($node);

        my $ptrKundeLimits =  &getKundeLimits ( $root, \%do2ku );
        &correctLimits( $root, \%limitFactor );
        &correctClientsLimits ( $root, $countExtraDomains, $ptrKundeLimits, \%do2ku );

#
# end loop by domains
#
  }
  $d_nodes{$nameCust} = \%d_hash;
  return $root;
}
#
# add teplate items into the client node
#
sub addTemplates {
	my ($root, $ptrNames, $ptrResellerHahs ) = @_;     

	unless( ref($root) =~ /XmlNode/ && ref($ptrNames) =~ /HASH/ ){
		&printToError("Error: sub addTemplates: wrong parameters");
		return;
	}

	my %TemplateIDs = reverse %{$ptrNames};
	my( $sql, $templName, $ptrTemplate, $templID, $itemTempl, $item );
	my $cntTemplates = 0;

	foreach $templID ( sort{ $a <=> $b } keys %TemplateIDs){
		$templName = $TemplateIDs{$templID};
		$sql = "SELECT * FROM angebote WHERE ident=$templID";
		unless( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
			&printToError( "Error: sub addTemplates: can't find template with # ".$templID );
			next;
		}
		$ptrTemplate = $wrapDbh->{'FETCHHASH'}->();

		$itemTempl = XmlNode->new( 'client-template', 'attributes' => {'name' => $templName} );

		my($xmlItemName, $ptrArr, $fieldName, $type, $value );

		while( ( $xmlItemName, $ptrArr ) = each %mapTemplate ){
			if( ref( $ptrArr ) =~ /ARRAY/ ) {
				( $fieldName, $type ) = @{$ptrArr};
			} else {
				$fieldName = $ptrArr;
				$type = '';
			}
			unless( exists( $ptrTemplate->{$fieldName} ) ){
				next;
			}

			$value = $ptrTemplate->{$fieldName};
			if( $type =~ /L/i ){ ## logical
				$value = $value? 'true': 'false';

			} elsif ( $type =~ /B/i ){ ## bytes
				if ($value != -1) {
					$value *= 1024;
				}
			}
			$item = XmlNode->new( 'template-item', 'content' => $value, 'attributes' => {'name' => $xmlItemName} );
			$itemTempl->addChild( $item );

		}
		$wrapDbh->{'FINISH'}->();

#
# other items
#

		my ($manage_sh_access, $manage_not_chroot_shell);
		if ($ptrTemplate->{'shell'}) {
			$manage_sh_access = 'false';
			$manage_not_chroot_shell = 'true';
		} else {
			$manage_not_chroot_shell = 'false';
			if ($ptrTemplate->{'scponly'}) {
				$manage_sh_access = 'true';
			} else {
				$manage_sh_access = 'false';
			}
		}
		$itemTempl->addChild(XmlNode->new('template-item', 'content' => $manage_sh_access, 'attributes' => {'name' => 'manage_sh_access'}));
		$itemTempl->addChild(XmlNode->new('template-item', 'content' => $manage_not_chroot_shell, 'attributes' => {'name' => 'manage_not_chroot_shell'}));
		
		# If 'perl' was specified - add CGI also
		if ($ptrTemplate->{'perl'}) {
			$itemTempl->addChild(XmlNode->new('template-item', 'content' => 'true', 'attributes' => {'name' => 'cgi'}));
		}

# add mail quota info
		if ($mailQuotaValue) {
			$itemTempl->addChild(XmlNode->new('template-item', 'content' => $mailQuotaValue, 'attributes' => {'name' => 'mbox_quota'}));
		}			

		# All templates are with Plesk's physical hosting
		$itemTempl->addChild(XmlNode->new('template-item', 'content' => 'physical', 'attributes' => {'name' => 'vh_type'}));

		$root->addChild( $itemTempl ); ## append to root item
		$cntTemplates++;
	}
	return $cntTemplates;
}

sub correctLimits {
	my ($root, $ptrFactor, $cntExtraDomains ) = @_;
	unless( ref($root)=~/XmlNode/ && ref($ptrFactor)=~/HASH/ ){
		&printToError("Error: sub correctLimits: wrong parameters");
		return;
	}

	my($ptrKinds,$item,$domain,$domainItem,$factor,$ptrLimits,
		 $value,$ret,$limitItem,$name,%limits, $itemName, $limitMaxDomains);
	$ret = 0;

#
# clean summators
#
	foreach $name (keys %comulatLimits) {
		$limits{$name} = undef;
	}
#
# end clean summators
#

        $ptrKinds = getKindsRef($root);
	foreach $domainItem ( @{$ptrKinds} ) { ## loop by domains
		$itemName = $domainItem->{name};
		if ( $itemName eq 'domain' ) {

			$domain = $domainItem->{attributes}->{name};

			$factor = $ptrFactor->{$domain};
			next unless $factor > 1; ## There is a factor which more than 1

			&printToLog ("update limits of '$domain' with factor $factor");

			$ptrLimits = getKindsRef($domainItem);
			foreach $limitItem ( @{$ptrLimits} ) { ## loop by limits
				next unless $limitItem->{name} eq 'limit';

				$name = $limitItem->{attributes}->{name};
				$value = $limitItem->{'CONTENT'}->();
				if ( $value>0 ) { ## a positive value

					if ( exists( $limits{$name} ) ) { ## comulative limit
						if ( $limits{$name} ) {
							$limits{$name} += $value;
						} else {
							$limits{$name} = $value;
						}

					} else {
						$value /= $factor;
						$limitItem->{'CONTENT'}->( int($value) );
						$ret++;
					}
				}
			}
		} elsif ( $itemName eq 'limit' ) {
			$name = $domainItem->{attributes}->{name};
			if ( $name eq 'max_dom' ) {
				$limitMaxDomains = $domainItem; ## store reference
			}
		}
	}

#
# correct maximum of domains
#
	if ( $limitMaxDomains && $cntExtraDomains ) {
		$value = $limitMaxDomains->{'CONTENT'}->();
		if ( $value > 0 ) {
			$value += $cntExtraDomains;
			$limitMaxDomains->{'CONTENT'}->($value);
		}
	}
#
# /correct maximum of domains
#


#
# correct comulative limits
#
	foreach $limitItem ( @{$ptrKinds} ) { ## loop by limits
		next unless $limitItem->{name} eq 'limit';

		$name = $limitItem->{attributes}->{name};
		next unless exists $limits{$name}; ## check if name is suit

		$value = $limitItem->{'CONTENT'}->();
		if ( ( $value > 0 ) && ( $value < $limits{$name} ) ) {
			$limitItem->{'CONTENT'}->( $limits{$name} ); ## increase limit
		}
	}
#
# end correct comulative limits
#

	return $ret;
}
#
#
#

sub getKundeLimits {
	my ( $root, $ptrDo2Ku ) = @_;
	unless( ref($root) =~ /XmlNode/ &&
					ref($ptrDo2Ku) =~ /HASH/
				){
		&printToError("Error: sub getKundeLimits: wrong parameters");
		return undef;
	}

	my ( $ptrKinds, $domainItem, $itemName, $domain, $kunde, $name, $value,
			 $ptrLimits, $limitItem);

	my $ret = {};

        $ptrKinds = getKindsRef($root);
	foreach $domainItem ( @{$ptrKinds} ) { ## loop by domains
		$itemName = $domainItem->{name};

		if ( $itemName eq 'domain' ) {
			$domain = $domainItem->{attributes}->{name};
			$kunde = $ptrDo2Ku->{$domain};
			next unless $kunde;
			next if exists $ret->{$kunde};

			$ret->{$kunde} = {};

                        $ptrLimits = getKindsRef($domainItem);

			foreach $limitItem ( @{$ptrLimits} ) { ## loop by limits
				next unless $limitItem->{name} eq 'limit';

				$name = $limitItem->{attributes}->{name};
				$value = $limitItem->{'CONTENT'}->();
				if ( $value > 0 ) {
					$ret->{$kunde}->{$name} = $value;
				}
			}
		}
	}
	return $ret;
}

my ( %Domain2IDN );

sub correctClientsLimits {
	my ($root, $cntExtraDomains, $ptrKu2Lim,  $ptrDo2Ku ) = @_;

	unless( ref($root) =~ /XmlNode/ &&
					ref($ptrDo2Ku) =~ /HASH/ &&
					ref($ptrKu2Lim) =~ /HASH/
				){
		&printToError("Error: sub correctClientLimits: wrong parameters");
		return;
	}

	my ($ptrKinds, $domainItem, $itemName, $domain, $ptrLimits, %domLimits, $limitItem, %limit2dom,
			$name, $value, $limitMaxDomains, %cliLimits, $ptrArr, $kunde, $limName, %ku2do);


	while (($domain,$kunde) = each (%{$ptrDo2Ku})){

#
# push IDN-translated domains name
#
		push @{$ku2do{$kunde}}, ( $Domain2IDN{$domain} || $domain );
	}

	foreach $kunde (keys %ku2do){
		unless ( @{$ku2do{$kunde}} > 1 ) {
			delete $ku2do{$kunde};
		}
	}

        $ptrKinds = getKindsRef($root);
	foreach $domainItem ( @{$ptrKinds} ) { ## loop by domains
		$itemName = $domainItem->{name};

		if ( $itemName eq 'domain' ) {
			$domain = $domainItem->{attributes}->{name};

                        $ptrLimits = getKindsRef($domainItem);

			$domLimits{$domain} = [ {}, $domainItem ];

			foreach $limitItem ( @{$ptrLimits} ) { ## loop by limits
				next unless $limitItem->{name} eq 'limit';

				$name = $limitItem->{attributes}->{name};
				$value = $limitItem->{'CONTENT'}->();
				if ( $value > 0 ) { ## a positive value
					$domLimits{$domain}->[0]->{$name} = [ $value, $limitItem ];
					unless ( exists( $limit2dom{$name} ) ) {
						$limit2dom{$name}={};
					}
					$limit2dom{$name}->{$domain} = $value;
				}
			}

		} elsif ( $itemName eq 'limit' ) {
			$name = $domainItem->{attributes}->{name};
			if ( $name eq 'max_dom' ) {
				$limitMaxDomains = $domainItem; ## store reference
			}
			$value = $domainItem->{'CONTENT'}->();
			if ( $value > 0 ) { ## a positive value
				$cliLimits{$name} = [ $value, $domainItem ];
			}
		}
	}

#
# correct maximum of domains
#
	if ( $limitMaxDomains && $cntExtraDomains ) {
		$value = $limitMaxDomains->{'CONTENT'}->();
		if ( $value > 0 ) {
			$value += $cntExtraDomains;
			$limitMaxDomains->{'CONTENT'}->($value);
			$cliLimits{'max_dom'}->[0] = $value;
		}
	}
#
# /correct maximum of domains
#

	unless ( keys %ku2do ) {
		return 0;
	}

#
# check overdraft
#
	foreach $name ( keys %cliLimits )  {
		$value = 0;
		map { $value += $_ } grep { $_ > 0 } values %{$limit2dom{$name}};

		if ( $cliLimits{$name}->[0] <= 0 || $value <= $cliLimits{$name}->[0] ) {

			delete $cliLimits{$name};
			delete $limit2dom{$name};

			foreach $domain ( keys %domLimits ) {
				foreach $limName ( keys ( %{$domLimits{$domain}->[0]} ) ) {
					if ( $limName eq $name ) {
						delete $domLimits{$domain}->[0]->{$name};
					}
				}
			}

		}
	}

#
# main loop by limits
#
	my ( %limit, %fact, $limVal, $factVal, $factSum, @dom2work, $kf, $oldLimit, $newLimit,
		 $dom, $val, $newValue );

	foreach $name ( keys %cliLimits )  {

		print "correct '$name' limit ...";

#
# loop by kunde
#
		while ( ($kunde, $ptrArr) = each( %ku2do ) ) {
			%limit = ();
			%fact = ();
			@dom2work = ();
			$factSum = 0;
			$oldLimit = 0;
#
# get limits & facts
#
			foreach $dom (@{$ptrArr}) { ## get limits & facts

				unless(exists $domLimits{$dom}){
					&printToError("Error: sub correctClientsLimits: domain '$dom' is't found in the dump");
					next;
				}

				unless (exists($domLimits{$dom}->[0]->{$name})) {
					next;
				}

				$limVal = $domLimits{$dom}->[0]->{$name}->[0];
				next unless $limVal > 0;
				push @dom2work, $dom;
				$limit{$dom} = $limVal;
				$oldLimit += $limVal;

				$factVal = &getFactUsage( $name, $dom, $domLimits{$dom}->[1]);

				$fact{$dom} = defined( $factVal )? $factVal: $limVal;
				if ( $fact{$dom} > 0 && $factSum >= 0 ) {
					$factSum += $fact{$dom};
				} elsif ( $fact{$dom}< 0 ) {
					$factSum = -1;
				}
			}

#
# correct limits
#
			if ( $factSum <= 0 ) {
				if ( $oldLimit > 0 ) {
					$kf = $ptrKu2Lim->{$kunde}->{$name} / $oldLimit;
					$newLimit = 0;
					foreach $dom ( @dom2work ) {
						$val  = int( $limit{$dom} * $kf );
						$limit{$dom} = $val;
						$newLimit += $val;
					}
				}
			} else {
				if ( $factSum <= $ptrKu2Lim->{$kunde}->{$name} &&
						 $ptrKu2Lim->{$kunde}->{$name} > 0
					 ) {
					$kf = $ptrKu2Lim->{$kunde}->{$name} / $factSum;
				} else {
					$kf = 1;
				}
				$newLimit = 0;
				foreach $dom ( @dom2work ) {
					$val  = int( $fact{$dom} * $kf );
					$limit{$dom} = $val;
					$newLimit += $val;
				}
			}
#
# save new domain's limit
#
			while ( ($dom,$val) = each(%limit) ) {
				$domLimits{$dom}->[0]->{$name}->[0] = $val;
			}
#
# save new client's limit
#
			if ( $newLimit > $oldLimit ) {
				$cliLimits{$name}->[0] += ($newLimit - $oldLimit);
			}
		}

		print "\t  done\n";

	}
#
# save to xml
#
	my $ret = 0;
	foreach $name (keys (%cliLimits)) {
		$domainItem = $cliLimits{$name}->[1];
		$value = $domainItem->{'CONTENT'}->();
		if ( $value < $cliLimits{$name}->[0] ) {
			$domainItem->{'CONTENT'}->( $cliLimits{$name}->[0] );
			$ret++;
		}
	}

	foreach $dom ( keys (%domLimits) ) {
		foreach $name ( keys %{$domLimits{$dom}->[0]} ) {
			$limitItem = $domLimits{$dom}->[0]->{$name}->[1];
			$value = $limitItem->{'CONTENT'}->();
			$newValue = $domLimits{$dom}->[0]->{$name}->[0];
			unless ( $value == $newValue ) {
				$limitItem->{'CONTENT'}->( $newValue );
				$ret++;
			}
		}
	}

	return $ret;

}

sub getFactUsage {
	my ( $limit, $domain, $xmlDomainItem) = @_;
	my ( $retValue, $item, $ret );

	if ( $limit eq 'max_subdomain'){
		$retValue = 0;
                $item = getKind($xmlDomainItem, 'phosting');
		if ( $item ) {
                        $ret = getKindsRef($item, 'subdomain' );
			if ( $ret ) {
				$retValue = @{$ret};
			}
		}

	} elsif ( $limit eq 'max_dom' ) {
# nothing to do

	} elsif ( $limit eq 'disk_space' ) {
		$retValue = 0;
        $item = getKind($xmlDomainItem, 'phosting');
		if ( $item ) {
			my ($path, $cmd);
			my $tar = AgentConfig::tarBin();
			my $cat = AgentConfig::catBin();
			$ret = $item->{attributes};
			while ( my( $key, $value) = each( %{$ret} ) ){
				next unless ($key =~ /^cid(_|$)/);
				$path = "$dumpDir/$value";
				next unless ( -f "$path.aa" );
				$cmd = "cat $path.* | $tar -z -t -vv -f - ";
				if ( open( IN, "$cmd |") ) {
					while ( <IN> ) {
#
#-rw-r--r-- apach e/wws      256 2005-02-15 09:28:21 ./_vti_cnf/.htaccess
#                      --> size <---
#
						$retValue += ( split( ' ', $_, 4 ) )[2];
					}
					close( IN );
				}
			}
			$retValue /= 1024;
		}

  } elsif ( $limit eq 'max_traffic' ) {
		$retValue = -1;

	} elsif ( $limit eq 'max_wu' ) {

	} elsif ( $limit eq 'max_db' ) {
		$retValue = 0;
                $ret = getKindsRef($xmlDomainItem, 'database');
		if ( $ret ) {
			$retValue = @{$ret};
		}

	} elsif ( $limit eq 'max_box' ) {
		$retValue = 0;
                $item = getKind($xmlDomainItem, 'mailsystem');
		if ( $item ) {
                        $ret = getKindsRef($item, 'mailuser');
			if ( $ret ) {
				foreach $item (@{$ret}) {
					if ( getKind($item, 'mailbox') ) {
						$retValue++;
					}
				}
			}
		}

	} elsif ( $limit eq 'mbox_quota' ) {
		$retValue = -1;

	} elsif ( $limit eq 'max_redir' ) {
		$retValue = 0;
                $item = getKind($xmlDomainItem, 'mailsystem');
		if ( $item ) {
                        $ret = getKindsRef($item, 'mailuser');
			if ( $ret ) {
				foreach $item (@{$ret}) {
					if ( getKind($item, 'redirect') ) {
						$retValue++;
					}
				}
			}
		}

	} elsif ( $limit eq 'max_mg' ) {

	} elsif ( $limit eq 'max_resp' ) {

	} elsif ( $limit eq 'max_maillists' ) {
                $ret = getKindsRef($xmlDomainItem, 'maillist');
		$retValue = $ret? @{$ret}: 0;
		return $retValue;

	} elsif ( $limit eq 'max_webapps' ) {

	} elsif ( $limit eq 'ans_freq' ) {

	} elsif ( $limit eq 'ans_count' ) {

	}

	return $retValue;
}


sub getIpPool( $ )
{
	my ($nameRes) = @_;

	my (@ips,$nodePool,$ptrRow,$ip,$sql);

	$sql = "SELECT standardip FROM anbieter WHERE anbieter='$nameRes'";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {
		($ip) = @{$wrapDbh->{'FETCHROW'}->()};
		$ip =~ s/^\s+//;
		$ip =~ s/\s+$//;
	}
	$wrapDbh->{'FINISH'}->();

	# Check IP
	if ($ip) {
		unless ($ip eq $admin{'standardip'}) {
			$sql = "SELECT ip FROM ipadressen WHERE ip='$ip'";
			unless ($wrapDbh->{'EXECUTE'}->($sql)) {
				$ip = $admin{'standardip'};
			}
			$wrapDbh->{'FINISH'}->();
		}
	} else {
		# Get standard IP from admin
		$ip = $admin{'standardip'};
	}

	push @ips, $ip;

	$sql = "SELECT ip FROM ipadressen WHERE anbieter='$nameRes'";
	if ($wrapDbh->{'EXECUTE'}->( $sql )) {
		($ip) = @{$wrapDbh->{'FETCHROW'}->()};	
		$ip =~ s/^\s+//;
		$ip =~ s/\s+$//;
		push @ips, $ip;
	}
	$wrapDbh->{'FINISH'}->();

	return uniq(@ips);
}

sub getClientIP ()
{
  my ($nameClient, $nameRes) = @_;
  my ($nodePool,$ptrRow,$ip,$sql);

  $sql = "SELECT ip FROM ipadressen WHERE kunde='$nameClient' AND anbieter='$nameRes'";
  if ($wrapDbh->{'EXECUTE'}->( $sql )) {
  	($ip) = @{$wrapDbh->{'FETCHROW'}->()};
	$ip =~ s/^\s+//;
	$ip =~ s/\s+$//;
  }
  $wrapDbh->{'FINISH'}->();
  if (! $ip) {
    # get reseller's default IP
	$sql = "SELECT standardip FROM anbieter WHERE anbieter='$nameRes'";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {
		($ip) = @{$wrapDbh->{'FETCHROW'}->()};
		$ip =~ s/^\s+//;
		$ip =~ s/\s+$//;
	}
	$wrapDbh->{'FINISH'}->();
	# Check IP
	if ($ip) {
		unless ($ip eq $admin{'standardip'}) {
			$sql = "SELECT ip FROM ipadressen WHERE ip='$ip'";
			unless ($wrapDbh->{'EXECUTE'}->($sql)) {
				$ip = $admin{'standardip'};
			}
			$wrapDbh->{'FINISH'}->();
		}
	} else {
		#Get standard IP from admin
		$ip = $admin{'standardip'};
	}
  }
  return $ip;
}

#
# addDomainNode
#            - create and add a domain node into the xml tree
# Arguments:
#
#    $root      - the node in which will be added a domain node
#    $domain    - name of domain
#    $ips       - reference to @ip_pool of reseller
#    $refResRow - reference to hash of reseller's info
#

sub addDomainNode {
  my ($customer, $domain, $ip, $refResRow, $reseller, $domainCounter) = @_;


  my ($rootDomain,$sql,$ptrRow,$item,$idnName,
      $ptrHash,%custHash,$ptrSubdomains,$ptrDomains,$propertiesNode);

	my $utf8domain;

	if ($domain =~ /(^|\.)xn--[^.]+/) {
		$utf8domain = (exists $idn2Utf8cache{$domain}) ? $idn2Utf8cache{$domain} : &idnToUtf8($domain);
	} else {
		$utf8domain = $domain;
	}

## make anonymous array. need for return
	$ptrDomains = [];
	$ptrSubdomains = [];



  $rootDomain = XmlNode->new('domain', 'attributes' => {'guid' => &getResourceId($domain), 'owner-guid' => &getResourceId($customer)});

  
  $rootDomain->setAttribute('name',$utf8domain, "UTF8");

  $sql = "SELECT k.* FROM kunden k WHERE k.kunde = '$customer'";  
  unless ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
    $wrapDbh->{'FINISH'}->();
    &printToError( "Error: domain '$domain' is not found" );
    return 0;
  }
  unless($ptrHash = $wrapDbh->{'FETCHHASH'}->()){
    $wrapDbh->{'FINISH'}->();
    return 0;
  }
  %custHash = %{$ptrHash};
  $wrapDbh->{'FINISH'}->();

#
# IDN
#
	if( $majorVersion >= 3 ){
		my ($idnCharset,$domainId);
		$sql = "SELECT i.idn_name, i.charset, d.id FROM idn_aliases i, domains d ".
			"WHERE i.domain_id = d.id AND d.domain = '$domain'";
		if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
			($idnName,$idnCharset,$domainId) = @{$wrapDbh->{'FETCHROW'}->()};

			if( $idnCharset && ( $idnCharset !~ /UTF-?8/i ) ) {
## translate to UTF8
				$idnName = &toUtf8($idnName, $idnCharset);
			}

			## use localized-name instead IDN-name (bug #43508)
			$rootDomain->setAttribute( 'name', $idnName, 'UTF8' ); ## don't translate to UTF-8 again

			$Domain2IDN{$domain} = $idnName; ## store maping domain -> idn-domain
		}
		$wrapDbh->{'FINISH'}->();
	}
#
# /IDN
#

	$rootDomain->addChild(XmlNode->new('preferences'));
	$propertiesNode = XmlNode->new('properties');
	$propertiesNode->addChild(makeIpNode($ip));

	$item = XmlNode->new('status');
	my $node;

	if($custHash{'gesperrt'}) {
		$node = XmlNode->new('disabled-by', 'attributes' => {'name' => 'admin'});
	} else {
		$node = XmlNode->new('enabled');
	}

	$item->addChild($node);
	$propertiesNode->addChild($item);

	# DNS records (for versions starting from 2.x)
	if ($majorVersion >= 2) {
		my (@ns); ## default value for NS-records
		$sql = "SELECT pns,sns FROM anbieter WHERE anbieter='".$custHash{'anbieter'}."'";
		if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
			@ns = @{$wrapDbh->{'FETCHROW'}->()};
		}
		$wrapDbh->{'FINISH'}->();
		$ns[0] ||= $admin{'ip_pns'};
		$ns[1] ||= $admin{'ip_sns'};

		&addDNS ( $propertiesNode, $domain, @ns );
	}

	$rootDomain->addChild($propertiesNode);


#
# increase database's limit  by number of webShop's limit
#
	if ( $admin{'shops'} && $custHash{'maxshops'} ) {
		if ( $custHash{'maxshops'} > 0 ) {
			$custHash{'maxmysql'} += $custHash{'maxshops'}*2;
		} else {
			$custHash{'maxmysql'} = -1;
		}
	}

	if( $custHash{'maxmysql'} > 0 || $refResRow->{'maxmysqllimit'} == 0 ){
		$sql = "SELECT COUNT(dbname) FROM mysql_datenbanken WHERE kunde='$customer'";
		if( $wrapDbh->{'EXECUTE'}->( $sql ) ){
			my ( $count ) = @{$wrapDbh->{'FETCHROW'}->()};
			$wrapDbh->{'FINISH'}->();

			if ( $admin{'shops'} ) {  ## include webShop's databases
				$sql  = "SELECT COUNT(shop_name) FROM shops WHERE kunde='$customer'";
				if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
					$count += $wrapDbh->{'FETCHROW'}->()->[0]*2; ## 2 databases for 1 webShop
					$wrapDbh->{'FINISH'}->();
				}
			}
			## limit great or equivalence then fact
			if ( ($custHash{'maxmysql'} > -1) && ( $custHash{'maxmysql'} < $count ) ) 
			{
				$custHash{'maxmysql'} = $count;
			}
		}
		$wrapDbh->{'FINISH'}->();
	}

#
# correct limits
#
	my( $confixx, $confixxLimit, $count );
	foreach $confixx ( values %mapCustLimits ){

		next if $confixx eq 'maxmysql'; ## already prepared
		next unless $custHash{$confixx} > 0; ## skip unlimited

		$confixxLimit = $confixx.'limit';
		next unless exists $refResRow->{$confixxLimit};

		next if $refResRow->{$confixxLimit};
#
# oversell
#
		if( $confixx eq 'maxsubdomains' ){
			$sql = "SELECT COUNT(id) AS fact FROM domains WHERE domain LIKE '%.$domain'".
				" AND kunde='$customer'";

		}elsif( $confixx eq 'maxkb' ){
	        	if ($majorVersion > 3 || ($majorVersion == 3 && $minorVersion > 0)
				|| ($majorVersion == 3 && $minorVersion == 0 && $patchLevel >= 6)) 
			{
				$sql = "SELECT kbhomedir+kbpop AS fact FROM kunden WHERE kunde='$customer'";
			} else {
				$sql = "SELECT kbhomedir AS fact FROM kunden WHERE kunde='$customer'";
			}
		}elsif( $confixx eq 'maxpop' ){
			$sql = "SELECT COUNT(account) AS fact FROM pop3 WHERE kunde='$customer'";

		}elsif( $confixx eq 'maxautoresponder' ){
			$sql = "SELECT COUNT(a.ident) AS fact FROM autoresponder a,email e ".
				" WHERE a.ident = e.ident AND e.domain = '$domain'";

		}elsif( $confixx eq 'maxmaillist' ){
			$sql = "SELECT COUNT(m.id) AS fact FROM maillist m, domains d ".
				" WHERE m.domain_id = d.id AND d.domain = '$domain'";

		}else{
			next;
		}

		next unless $wrapDbh->{'EXECUTE'}->( $sql );

		( $count ) = @{$wrapDbh->{'FETCHROW'}->()};
		$wrapDbh->{'FINISH'}->();
		if ($custHash{$confixx} < $count) {
			$custHash{$confixx} = $count;
		}		

	}
#
# end correct limits
#
	$item = XmlNode->new('limits-and-permissions');
	&addLimits( $item, \%custHash, \%mapCustLimits );
	$rootDomain->addChild($item);

	$item = &makeMailSystem($reseller, $customer, $domain, $custHash{'spamfilter'});
	if ( ref($item) =~ /XmlNode/ ) {
		$rootDomain->addChild($item);
	}
	&addUsersDatabase($rootDomain,$reseller,$customer,$domain);

	my (%domainHash);

	$sql="SELECT * FROM domains WHERE domain='$domain'";
	if ($wrapDbh->{'EXECUTE'}->($sql)){
		if($ptrHash = $wrapDbh->{'FETCHHASH'}->()){
			%domainHash=%{$ptrHash};
		}
  	}
	$wrapDbh->{'FINISH'}->();
	$domainHash{'longpw'} = $custHash{'longpw'};   # default value for subdomain sysuser

	# select all docroots
	my $excludesDocroots='cgi-bin';
	if ($domainHash{'pfad'}!~/http(s)+:/) {
		$sql="SELECT pfad FROM domains WHERE kunde='$customer' AND domain!='$domain'";
		if ($wrapDbh->{'EXECUTE'}->($sql)){
			while($ptrRow = $wrapDbh->{'FETCHROW'}->()){
				my $pfad = $ptrRow->[0];
				if ($pfad!~/http(s)+:/ && $pfad=~/^$domainHash{'pfad'}\S+/ && $pfad=~/^\/(\S+)/) {					
					$excludesDocroots.=','.$1;
				}
			}
		}
		$wrapDbh->{'FINISH'}->();
	}
#
# locked
#
#
# maillists
#
	  addMaillists($rootDomain, $domain, \%domainHash);

#
# end maillists
#
	if ($domainCounter == 1) {   # to prevent traffic duplication output traffic only for the first domain
		$sql="SELECT tag,monat,jahr,ftp,web,email FROM transfer WHERE kunde='$customer' ORDER BY jahr, monat, tag"; 
		if ($wrapDbh->{'EXECUTE'}->($sql)){
			my $trafficValue = '';
			while($ptrRow = $wrapDbh->{'FETCHROW'}->()){
				my($trafficFtp) = $ptrRow->[3];
				my($trafficWeb) = $ptrRow->[4];
				my($trafficMail) = $ptrRow->[5];
				if ($trafficFtp>0 || $trafficWeb>0 || $trafficMail>0) {
					my($trafficDay) = $ptrRow->[0];
					my($trafficMonth) = $ptrRow->[1];
					my($trafficYear) = $ptrRow->[2];
					if ($trafficDay==0) {
						$trafficDay=1;
						$trafficMonth++;
						if ($trafficMonth == 13) {
							$trafficMonth = 1;
							$trafficYear++;
						}
					}
					if ($trafficDay<10) {
						$trafficDay='0'.$trafficDay;
					}
					if ($trafficMonth<10) {
						$trafficMonth='0'.$trafficMonth;
					}
					my($trafficDate) = $trafficYear.'-'.$trafficMonth.'-'.$trafficDay;
					if ($trafficFtp>0) {
						$trafficValue=$trafficValue.$trafficDate.' ftp in '.$trafficFtp."\n";
					}
					if ($trafficWeb>0) {
                                	        $trafficValue=$trafficValue.$trafficDate.' http in '.$trafficWeb."\n";
	                                }
					if ($trafficMail>0) {
                	                        $trafficValue=$trafficValue.$trafficDate.' mail pop3-imap '.$trafficMail."\n";
                        	        }
				}
			}
			if ($trafficValue) {
				$rootDomain->addChild(XmlNode->new('traffic', 'content' => $trafficValue));
			}
		}
		$wrapDbh->{'FINISH'}->();
	}		

#
# ssl
#
		if ($domainHash{'cssl'}){
			$sql="SELECT crt,privatekey FROM cssl WHERE kunde='$customer'";
			if ($wrapDbh->{'EXECUTE'}->($sql)){
				if($ptrRow = $wrapDbh->{'FETCHROW'}->()){
					my($certificateNode, $certificatesNode);
					$certificatesNode = XmlNode->new('certificates');
					$certificateNode = XmlNode->new('certificate');
					$certificateNode->addChild(XmlNode->new('certificate-data', 'content' => $ptrRow->[0]));
					$certificateNode->addChild(XmlNode->new('private-key', 'content' => $ptrRow->[1]));
					$certificatesNode->addChild($certificateNode);
					$rootDomain->addChild($certificatesNode);
				}
			}
			$wrapDbh->{'FINISH'}->();
		}
#
# end ssl
#

		$item = &makeDomainUserNode( \%custHash );
		if ( ref($item) =~ /XmlNode/ ) {
			$rootDomain->addChild($item);
		}

#
# end domain user
#

#
# hosting
#
	my($hostingNode, @hostingNodesBeforeContent);
	my $fileContentName = 'web_'.$domain.'_vhost_'.$filedate.'.tar.gz';

	if( $domainHash{'richtigedomain'} == 1 ||                                  ## domain
			( $domainHash{'richtigedomain'} == 0 && $domainHash{'pfad'} =~ /^\//)){  ## subdomain & no redirect

		my($plesk,$confixx,%attr);
		my($pathPrefix,$rePathPrefix,@excludeFiles);

		$hostingNode = XmlNode->new('phosting');
#
# sysuser
#
		$pathPrefix = $domainHash{'pfad'};
		$pathPrefix =~ s/^\///;
		$rePathPrefix = qr/^\/\Q$pathPrefix\E\// if $pathPrefix;

#
# check if there is ftp-account for this domain
#
		if ( $pathPrefix ) {
			$sql="SELECT * FROM ftp WHERE kunde='$customer' AND pfad='$pathPrefix'";
			if ($wrapDbh->{'EXECUTE'}->($sql)){
				my $ptrFtp = $wrapDbh->{'FETCHHASH'}->();
				%attr=('NAME'=>$ptrFtp->{'account'},
				       'PASSWORD'=>$ptrFtp->{'longpw'},
				     );
			}
			$wrapDbh->{'FINISH'}->();
		}
		unless(%attr){
			%attr = ( 'NAME' => $domainHash{'kunde'},
				  'PASSWORD' => $custHash{'longpw'},
				);
			if( $custHash{'maxkb'} > 0 ) {
				$attr{'QUOTA'} = $custHash{'maxkb'} * 1024; ## translate to bytes
			}
			if( $custHash{'shell'} ) {
				$attr{'SHELL'} = $stdShell || '/bin/sh';
			}
		}
		my $preferencesNode = XmlNode->new('preferences');
		$preferencesNode -> addChild(&makeSysuserNode(\%attr));
		push @hostingNodesBeforeContent, $preferencesNode;
#
# end sysuser
#


#
# FronPage user
#
		if($domainHash{'frontpage'}){
			$sql = "SELECT benutzer,passwort FROM frontpage WHERE domain='$domain'";
			if($wrapDbh->{'EXECUTE'}->($sql)){
				if($ptrRow = $wrapDbh->{'FETCHROW'}->()){
					$item = XmlNode->new('fpuser', 'attributes' => {'name' => $ptrRow->[0]});
					$preferencesNode->addChild($item);
					$item->addChild(&makePasswordNode($ptrRow->[1],'plain'));
				}
			}
			$wrapDbh->{'FINISH'}->();
		}
#
# end FronPage user
#

#
# .htpasswd
#

		if($custHash{'pwschutz'}){
			my (%pdirs,$path,$parentID,$pdirNode,$ptrArr,$title);
			$sql="SELECT ident,pfad,bereich FROM pwschutz WHERE kunde='$customer'";
			if ( $wrapDbh->{'EXECUTE'}->($sql) ) {
				while ( $ptrRow = $wrapDbh->{'FETCHROW'}->() ) {
					$path = $ptrRow->[1];
					if($pathPrefix){
						unless( $path =~ s/$rePathPrefix/\//){
							next;   ## not subdir
						}
					}
					$pdirs{$path} = [ $ptrRow->[0], $ptrRow->[2] ];
				}
			}
			$wrapDbh->{'FINISH'}->();

			while( ($path,$ptrArr) = each(%pdirs) ) {
				( $parentID, $title ) = @{$ptrArr};
				if($pathPrefix){
					unless ( $path =~ s/$rePathPrefix// ) {
						next;  ## not subdir
					}
				}
		
				$pdirNode = XmlNode->new('pdir', 'attributes' => {'name' => $path, 'title' => $title, 'nonssl' => 'true'});
				$preferencesNode->addChild($pdirNode);
				$sql="SELECT login,longpw FROM users WHERE parent=$parentID";
				if($wrapDbh->{'EXECUTE'}->($sql)){
					while( $ptrRow = $wrapDbh->{'FETCHROW'}->() ) {
						$item = XmlNode->new('pduser', 'attributes' => {'name' => $ptrRow->[0]});
						$item->addChild(&makePasswordNode($ptrRow->[1]));
						$pdirNode->addChild($item);
					}
				}
				$path =~ s/^\///;
				$path .= '/' if $path;
				push @excludeFiles,($path.'.htaccess',$path.'.htpasswd');

				$wrapDbh->{'FINISH'}->();
			}
		}
#
# end .htaccess
#
		
		$item = XmlNode->new('limits-and-permissions');
		$item -> addChild(&makeScriptingNode( \%mapCustScripting, \%custHash ));
		push @hostingNodesBeforeContent, $item;
								
		my ($ptrAccounts);
		( $ptrSubdomains, $ptrAccounts ) = &getSubdomains( $domain, \%domainHash );



#
# translate ftp-accounts to webuser of main domain
#
		my $ftpUsersForVhostContentBackup = '0';
		if($domainHash{'richtigedomain'} && ref($ptrAccounts)=~/HASH/){
			my ($account,$path);
			$sql="SELECT account,longpw,pfad FROM ftp WHERE kunde='$customer'";
			if($wrapDbh->{'EXECUTE'}->($sql)){
				my ($webuserNode,$ftpDump,$webusersNode);
				my $webusers = 0;
				while ($ptrRow = $wrapDbh->{'FETCHROW'}->()){
					$account = $ptrRow->[0];
					$path = $ptrRow->[2];
					if($pathPrefix){
						unless($path =~ s/$rePathPrefix//){
							next;   ## not subdir
						}
					}
					next if exists $ptrAccounts->{$account}; ## already there is a domain with the ftp-account
					if ($webusers != 1) {
						$webusersNode = XmlNode->new('webusers');
						push @hostingNodesBeforeContent, $webusersNode;
						$webusers = 1;
					}
					my $uniqName = makeUniqName($account);
					
					$webuserNode = XmlNode->new('webuser', 'attributes' => {'name' => $uniqName});
					$webusersNode -> addChild($webuserNode);
					unless ( $nocontent ) {
						my %typeAndOffsetValues;
        	                                $typeAndOffsetValues{'webuser_home'}="web_users/$uniqName";
						my $webUserContentNode=&makeWebContentNode($fileContentName,'',1000,'_WEB_SIZE_',\%typeAndOffsetValues);
						$webuserNode->addChild($webUserContentNode);
					}						

#
# removed
#
#	$webuserNode->{'ATTRIBUTE'}->('name',$path);
#
# end removed. Plesk does not support this attribute
#
					if ($ftpUsersForVhostContentBackup eq '0') {
						$ftpUsersForVhostContentBackup="$uniqName=$path";
					} else {
						$ftpUsersForVhostContentBackup.=",$uniqName=$path";
					}					
					$item = &makeSysuserNode($uniqName, $ptrRow->[1]);
					$webuserNode->addChild($item);

					$item = &makeScriptingNode(\%mapCustScripting,\%custHash);
					$webuserNode->addChild($item);
				}
			}
			$wrapDbh->{'FINISH'}->();
		}
#
# end translate ftp-accountys to webuser
#

#
# add subdomains
#
		my ( $reSubDomain, $name );
		$reSubDomain = qr/^(.+)\.\Q$domain\E$/; ## extract name of subdomain from domain's name

		my $subdomainsNode;
		my $subdomainsExists = 0;
		my $subdomainsValuesForContentBackup = '0';
		while (my($subdomain,$ptrAttrHash) = each(%{$ptrSubdomains})){
			if ( $subdomain =~ /$reSubDomain/ ) {
				$name = $1;
				unless ( $name =~ /\*/ ) {  ## skip wildcard-domain
					if ($subdomainsExists != 1) {
						$subdomainsNode = XmlNode->new('subdomains');
						push @hostingNodesBeforeContent, $subdomainsNode;
						$subdomainsExists = 1;
					}
					if ($subdomainsValuesForContentBackup ne '0') {
						$subdomainsValuesForContentBackup.=',html/'.$ptrAttrHash->{'PATH_LOCAL'}.'='.$subdomain;
					} else {
						$subdomainsValuesForContentBackup='html/'.$ptrAttrHash->{'PATH_LOCAL'}.'='.$subdomain;
					}						
					my %typeAndOffsetValues;
				        $typeAndOffsetValues{'cgi'}="subdomains/$subdomain/cgi-bin";
					$typeAndOffsetValues{'docroot'}="subdomains/$subdomain/httpdocs";
		 			my $to = 'resellers/'.$reseller.'/'.$customer.'/'.$domain;
					my $webNode = &makeWebContentNode($fileContentName, $to, 1000, '_WEB_SIZE_', \%typeAndOffsetValues);
					my $subdomainNode = &makeSubdomainNode( $name, $reseller, $customer, $domain, $ptrAttrHash, \%custHash, $webNode );
					$subdomainsNode->addChild($subdomainNode);
				}
			} else {
				delete ( $ptrSubdomains->{$subdomain} );
			}
		}
#
#  end add subdomains
#


#
# attributes of physical hosting
#
		my $webNode;
		my $contentSize = undef;
		if ($domainHash{'pfad'}!~/http(s)+:/) {
			my $docroot = 'html';
			my $isSubdir = '0';
			if ($domainHash{'pfad'} ne '/') {
				$docroot.=$domainHash{'pfad'};
				$isSubdir = '1';
			}			
			unless ( $nocontent ) {				
				open (F, "./shell/web.sh $isSubdir $user_homeDir/$customer $docroot $excludesDocroots $ptrArgs->{'output'}'/resellers/'$reseller'/'$customer'/'$domain $domain $filedate $subdomainsValuesForContentBackup $ftpUsersForVhostContentBackup |");
				$contentSize = <F>;
				if(defined($contentSize)){
					chomp($contentSize);
				} else {
					$contentSize = 0;
				}
				close(F);
				my %typeAndOffsetValues;
				$typeAndOffsetValues{'vhost'}='';
				$typeAndOffsetValues{'docroot'}='httpdocs';
				$typeAndOffsetValues{'logs'}='statistics/logs';
                                my $to = 'resellers/'.$reseller.'/'.$customer.'/'.$domain;
				$webNode = &makeWebContentNode($fileContentName, $to, 1000, $contentSize, \%typeAndOffsetValues);
			}	
		}			

		$hostingNode->setAttribute('fp',$domainHash{'frontpage'}?'true':'false');
		if ($custHash{'statistik'} == 1) {
			$hostingNode->setAttribute('webstat','webalizer');
		} else {
			$hostingNode->setAttribute('webstat',$custHash{'awstats'}?'awstats':'false');
		}
			
		$hostingNode->setAttribute('errdocs',$custHash{'fehlerseiten'}?'true':'false');
		$hostingNode->setAttribute('wu_script', 'true');
		$hostingNode->setAttribute('guid' => &getResourceId($domain).'_ph_1');
		$hostingNode->setAttribute('owner-guid' => &getResourceId($domain));
#
# end attributes of physical hosting
		if ($webNode) {
			$hostingNode->addChild($webNode);
		}
		foreach my $hostingNodeBeforeContent (@hostingNodesBeforeContent) {			
			if ($contentSize > 0 && ref($hostingNodeBeforeContent)=~/XmlNode/) {
				my @webusers = $hostingNodeBeforeContent->getChildren('webuser');
				my @subdomainsAndWebusers = $hostingNodeBeforeContent->getChildren('subdomain');
				push (@subdomainsAndWebusers, @webusers);
				foreach my $subdomainOrWebuser (@subdomainsAndWebusers) {
					my $content = $subdomainOrWebuser->getChild('content');
	                                if ($content) {
						my @cids = $content->getChildren('cid');
						foreach my $cid (@cids) {
							my $content_file = $cid->getChild('content-file');
							if ($content_file) {
								if ($content_file->getAttribute('size') eq '_WEB_SIZE_') {
									$content_file->setAttribute('size', $contentSize);
								}
							}
						}
	                                }
				}				
			}
			$hostingNode->addChild($hostingNodeBeforeContent);
		}

#
# translate subdomain to domain
#
		my ($list);

		$ptrSubdomains = [keys %{$ptrSubdomains}];  ## make anonymous array. need for return
		$list=join(',',map {"'$_'"} @{$ptrSubdomains}); ## list of prepared subdomains

		$sql="SELECT domain FROM domains WHERE (richtigedomain=0) AND (kunde='$customer')".
			" AND (domain like '\%.$domain')";
		if($list){
			$sql.=" AND NOT (domain in ($list))";
		}
		if($wrapDbh->{'EXECUTE'}->($sql)){
			my ($subdomain,$name);
			while($ptrRow = $wrapDbh->{'FETCHROW'}->()){
				$subdomain = $ptrRow->[0];
				if ( $subdomain =~ /$reSubDomain/ ){  ## subdomain
					$name = $1;
					unless ( $name =~ /\*/ ) { ## exclude wildcard-subdomains
						push @{$ptrDomains}, $subdomain;
					}
				}
			}
		}
		$wrapDbh->{'FINISH'}->();

#
# end translate subdomain to domain
#

  }elsif( ( $domainHash{'richtigedomain'} == 0 ) &&
		 !( $domainHash{'pfad'} =~ /^\// ) ){
#
# redirect
#
	$hostingNode = XmlNode->new('shosting', 'content' => $domainHash{'pfad'});
  }

	if(ref($hostingNode)=~/XmlNode/){
		$rootDomain->addChild($hostingNode);
	}
#
# end hosting
#

#
# return list of subdoamin where are translated to domain & list of prepared subdomains
#
  return ($ptrDomains,$ptrSubdomains, $rootDomain);

}

#
# end addDomainNode
#

  sub makeDomainUserNode {

	my ($custHash) = @_;

	my $root = XmlNode->new('domainuser');

	if ( ref($custHash) =~ /HASH/ ) {

		my $contact = "";
		$contact = $custHash->{'firstname'} if $custHash->{'firstname'};
		$contact .= ($contact ? " " : "") . $custHash->{'name'} if $custHash->{'name'};

		$root->setAttribute( 'contact', $contact) if $contact;

		$root->setAttribute('status',$custHash->{'gesperrt'}?'false':'true');
		#  $root->{'ATTRIBUTE'}->('account',$custHash->{'kunde'});
		$root->addChild(&makePasswordNode($custHash->{'longpw'}));

		&addPinfo( $root, $custHash, \%mapUserPinfo, 1);

		unless ( exists ( $mapCustPermis{'make_dumps'} ) ) {
			$mapCustPermis{'make_dumps'} = $backup_off? 0: 1;
		}

		# default value, as confixx has no the corresponding option
		$mapCustPermis{'multiple-sessions'} = 1;

		&addPermissions( $root, $custHash, \%mapCustPermis );

	}

	return $root;
 }

#
# dns records
#
sub addDNS {
	my ($root, $domain, @ns) = @_;

	my ($sql, $ptrRow, $cnt, $ptrHash, $webmail, $item, $dnsNode );

	return undef unless exists $admin{'dns'}; ## Premium 1.0.* has not dns

	return -1 unless $admin{'dns'};

	my $dnsZoneNode = XmlNode->new('dns-zone', 'attributes' => {'type' => 'master'});
	

	$item = XmlNode->new('status');
        $dnsNode = XmlNode->new('enabled');

        $item->addChild($dnsNode);
        $dnsZoneNode->addChild($item); 


	$cnt = 0;
	$sql = "SELECT webmail FROM kunden AS k, domains AS d WHERE k.kunde = d.kunde AND d.domain = '$domain'";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {
	    $ptrHash = $wrapDbh->{'FETCHHASH'}->();
	    if ($ptrHash->{'webmail'} == 1){
		$webmail = 'true';
	    }
	}
        $wrapDbh->{'FINISH'}->();

	$sql = "SELECT zonefile FROM dns WHERE domain='$domain'";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {
	  my ($line, @fields, $type, $i, $dst, $src, $opt, $soa);
	  $ptrRow = $wrapDbh->{'FETCHROW'}->();

	  foreach $line (split(/\n/, $ptrRow->[0])) {
			next unless $line;
			$cnt++;
			@fields = split(' ', $line);
			if (@fields > 2) {
				$src = $fields[0];
				$dst = undef;
				$opt = undef;
				for($i = 3; $i > 0; $i--) {
					$type = $fields[$i];
					if($type =~ /^(A|NS|CNAME|PTR)$/i) {
						$dst = $fields[$i+1];
						last;
					} elsif ($type =~ /^MX$/i) {
						$dst = $fields[$i+2];
						$opt = $fields[$i+1];
						last;
					}
				}

				if ($dst) {

					if ( $type eq 'NS' ) {
						if ( $dst eq '.' ) {
							$dst = shift( @ns);
						}
			# Some Confixxes are buggy and have IP followed by the
			# dot in the NS records
						if ( $dst =~ /^(\d+\.\d+\.\d+\.\d+)\.?$/ ) {  ## is an IP
							$dst = $1; #strip dot from the end of IP
                                                       if ($webmail) {
                                                         makeDnsRecord($dnsZoneNode, 'A', "webmail.$src", $dst);
                                                       }
							makeDnsRecord($dnsZoneNode, 'A', "ns.$src", $dst);
							$dst = "ns.$src";
						}
						if ( $dst ) {
							makeDnsRecord($dnsZoneNode, 'NS', $src, $dst );
						}

					} else { ## all other types
						makeDnsRecord($dnsZoneNode, $type, $src, $dst, $opt) unless $src=~/^#.*/;
					}

				}
			}
		}
	}

	$wrapDbh->{'FINISH'}->();
	$root->addChild($dnsZoneNode);
	return $cnt;
}

sub makeDnsRecord {
  my ($root, $type, $src, $dst, $opt) = @_;

  my $item = XmlNode->new('dnsrec', 'attributes' => { 'type' => $type, 'src' => $src, 'dst' => $dst});
  $item->setAttribute('opt', $opt) if ($opt);
  $root->addChild($item);
}

#
# end dns records
#




#
# maillist
#

sub addMaillists {
  my ($root, $domain, $ptrDomainHash) = @_;

  return if $majorVersion < 3;

  my $domainId = $ptrDomainHash->{'id'};
  unless ($domainId) {
	printToError("Error: sub addMaillist: domain id is not found");
	return;
  }

  my @ids;
  my $sql = "SELECT id FROM maillist WHERE domain_id=$domainId ORDER BY id";
  if ($wrapDbh->{'EXECUTE'}->($sql)) {
	my $ptrRow;
	while ($ptrRow = $wrapDbh->{'FETCHROW'}->()) {
	  push @ids, $ptrRow->[0];
	}
  }
  $wrapDbh->{'FINISH'}->();

  my $maillistsNode = XmlNode->new('maillists',
				  children => [Status::make($Status::ENABLED)]);

  my $maillistId;
  foreach $maillistId (@ids) {
	$sql = "SELECT * FROM maillist WHERE id=$maillistId";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {
	  my $ptrMaillist = $wrapDbh->{'FETCHHASH'}->();

	  my $status = $Status::ENABLED;
	  $status = $Status::ADMIN if $ptrMaillist->{'resperrt'};

	  my $rootMaillist = XmlNode->new('maillist',
						 attributes => {'name', $ptrMaillist->{'name'}},
						 children => [Status::make($status),
						  XmlNode->new('owner',
								  'content' =>$ptrMaillist->{'owner_mail'})]);

	  if ($ptrMaillist->{'pwd'}) {
		$rootMaillist->addChild(makePasswordNode($ptrMaillist->{'pwd'}, 'plain'));
	  }

	  if ($majordomo_ldir && (-d $majordomo_ldir)) {
		my $recipientsFile = "$majordomo_ldir/$domainId/lists/" . $ptrMaillist->{'name'};
		if (-T $recipientsFile) {
		  if ( open(LIST,"<$recipientsFile") ) {
			while (<LIST>) {
			  chomp;
			  next unless $_;
			  $rootMaillist->addChild(XmlNode->new('recipient', content => $_));
			}
			close(LIST);
		  } else {
			printToError("Error: sub addMaillist: unable to open '$recipientsFile' for read: $!\n");
		  }
		}
	  }
	  $wrapDbh->{'FINISH'}->();

	  $maillistsNode->addChild($rootMaillist);
	}
  }

  $root->addChild($maillistsNode);
}

#
# end maillist
#


sub addFreeMailBoxes {
	my ( $root, $reseller, $customer, $domain, $mailContentNode, $spamfilter ) = @_;

	unless(ref($root)=~/XmlNode/){
		&printToError("Error: sub addFreeMailBoxes: wrong parameters");
		return;
	}

	my $ret = 0;

	unless(exists ($preparedCustomers{$customer})){
		$preparedCustomers{$customer}={};
	}

	if(exists ($preparedCustomers{$customer}->{'mbox'})){
		return $ret;
	}

	my($sql,%mbox,@idents,$ptrRow,$ptrHash);

	$sql = "SELECT * FROM email WHERE kunde='$customer'";

	if ( $wrapDbh->{'EXECUTE'}->($sql) ) {

		my $oldVer; # ver. <= 3.0.8 flag
		my $reMbox = qr/^[^@]+\d+p\d+$/;

		while($ptrHash = $wrapDbh->{'FETCHHASH'}->()){

			if(!defined($oldVer)) {
				$oldVer = exists $ptrHash->{'pop3'};
			}

			if( $oldVer ){

				if( $ptrHash->{'pop3'} =~ /$reMbox/ ){
					$mbox{$ptrHash->{'pop3'}} = 1;
				}

				map{ $mbox{$_} = 1 } grep{ /$reMbox/ } split( /:/, $ptrHash->{'pop3x'} );

			}else{
				push @idents, $ptrHash->{'ident'};
			}

		}

		if( @idents ){
			$wrapDbh->{'FINISH'}->();
			$sql = "SELECT pop3 FROM email_forward ".
				"WHERE email_ident IN (".join(',',@idents).
					") AND kunde='$customer' GROUP BY pop3";

			if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {

				while($ptrRow = $wrapDbh->{'FETCHROW'}->()){
					if( $ptrRow->[0] =~ /$reMbox/ ){
						$mbox{$ptrRow->[0]} = 1;
					}
				}
			}
		}
	}
	$wrapDbh->{'FINISH'}->();
	my %pop3vals;
	$sql = "SELECT account, longpw FROM pop3 WHERE kunde='$customer' ORDER BY number";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {

		while( $ptrRow = $wrapDbh->{'FETCHROW'}->() ){
			my ($account, $longpw) = @{$ptrRow};
			next if exists $mbox{$account}; ## skip mbox with email
			$pop3vals{$ptrRow->[0]}=$ptrRow->[1];
			$ret++;
		}
	}
	$wrapDbh->{'FINISH'}->();
	foreach my $account (keys %pop3vals) {
		my $longpw = $pop3vals{$account};
			my $mailUserNode = XmlNode->new('mailuser', 'attributes' => {'name' => $account, 'mailgroup-enabled' => 'false', 'guid' => &getResourceId($domain).'_mn_'.$mailuserId, 'owner-guid' => &getResourceId($domain), 'id' => $mailuserId});
			$mailuserId++;

			
			my $propertiesNodes = XmlNode->new('properties');
			if( my $passwordNode = &makePasswordNode( $longpw ) ) {
				$propertiesNodes->addChild($passwordNode);
			}
			$mailUserNode->addChild($propertiesNodes);
			
			if ( $majorVersion > 2 ){  ## for Confixx 3 and later
				my $limitsNode = XmlNode->new('limits-and-permissions');
				addMailuserPermissionNode($limitsNode, 'multiple-sessions', 'true');
				addMailuserPermissionNode($limitsNode, 'cp-access', 'true');
				$mailUserNode->addChild($limitsNode);
			}
			my $preferencesNode = XmlNode->new('preferences');
			my $mailboxNode = XmlNode->new('mailbox', 'attributes' => {'type' => $mailboxType, 'enabled' => 'true' });
			$mailboxNode->addChild($mailContentNode);
			$preferencesNode->addChild($mailboxNode);
			if ($spamfilter == 1) {
				addSpamassassin($preferencesNode, $domain, $account);
		        }
			$mailUserNode->addChild($preferencesNode);
			$root->addChild($mailUserNode);

		
	}
	$preparedCustomers{$customer}->{'mbox'} = 1;

	return $ret;
}

#
# database
#

sub addUsersDatabase {

	my ($root,$reseller,$customer,$domain) = @_;

	unless(ref($root)=~/XmlNode/){
		&printToError("Error: sub addUsersDatabase: wrong paraneters");
		return;
	}

	my ( $itemDbUser, $nameUser, $accesshosts );
	my $ret = 0;

	unless(exists ($preparedCustomers{$customer})){
		$preparedCustomers{$customer}={};
	}

	unless(exists ($preparedCustomers{$customer}->{'db'})){
		my ($nameDb,$nodeDb,$sql);

		$sql = "SELECT dbname FROM mysql_datenbanken WHERE kunde='$customer'";

		if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {

			my ($ptrRow,$nodeDB,$dumpDb,$password,$nodeUser);
			my $nodeDbs = XmlNode->new('databases');
			while($ptrRow = $wrapDbh->{'FETCHROW'}->()){
				$nameDb = $ptrRow->[0];
				&printToLog("Dump user's mysql '$nameDb'");
				$nodeDb = XmlNode->new('database', 'attributes' => {'name' => $nameDb, 'type' => 'mysql', 'guid' => &getResourceId($domain).'_db_'.$dbId++, 'owner-guid' => &getResourceId($domain) });
				$nodeDb->setAttribute('version', Db::MysqlUtils::getVersion());
				
				unless ( $nocontent ) {
					$dumpDb = &makeDumpDb($nameDb,'mysql',undef,$mysqlUserPw);
					
					my $from = './'.$ptrArgs->{'output'}.'/'.$nameDb.'.mysql.sql.tgz';
					my $to = './'.$ptrArgs->{'output'}.'/resellers/'.$reseller.'/'.$customer.'/'.$domain.'/databases/';
					if (! -d $to) {
						system("mkdir -p $to");
					}
					system("mv $from $to");
					$to = 'databases'; 
					$nodeDb->addChild(&makeContentNode($nameDb.'.mysql.sql.tgz', $to, $storage->{unpacksize}->{$dumpDb}, $storage->_getFileSize($to.$nameDb.'.mysql.sql.tgz'), 'sqldump'));
				}			
				$nodeDbs->addChild($nodeDb);	

				$accesshosts = getAccessHosts($nameDb);

				$itemDbUser = &addDbUserConfixx( $nodeDb,$customer,'', $accesshosts);

				&checkUniqueDbUser( $customer,$itemDbUser,$nameDb );

				$ret++;
			}
			if ($ret > 0) {
				$root->addChild($nodeDbs);
			}
			
		}
		$wrapDbh->{'FINISH'}->();
		$preparedCustomers{$customer}->{'db'} = 1;
	}
#
# Premium 1.* - webShop
#
	if ( exists( $admin{'shops'}) && $admin{'shops'} ) {
		unless( exists ( $preparedCustomers{$customer}->{'shop'} ) ) {
			my ($nameDb,$nodeDb,$sql);

			$sql = "SELECT shop_name, password FROM shops WHERE kunde='$customer'";

			if ( $wrapDbh->{'EXECUTE'}->( $sql ) ) {

				my ($ptrRow,$nodeDB,$dumpDb,$password,$passwordNode,$nodeUser,$shopUser);

				while($ptrRow = $wrapDbh->{'FETCHROW'}->()){
					$shopUser = $nameDb = $ptrRow->[0];
					$password = $ptrRow->[1];
					$passwordNode = &makePasswordNode( $password,'plain' );


					&printToLog("Dump user's webShop '$nameDb'");

#
# shop_<customer_<N>
#
					$nodeDb = XmlNode->new('database', 'attributes' => {'name' => $nameDb, 'type' => 'mysql', 'version' => Db::MysqlUtils::getVersion()});

					$dumpDb = &makeDumpDb($nameDb,'mysql',
																$shopUser,$password,undef);

					$nodeDb->setAttribute('cid',$dumpDb);

					$root->addChild( $nodeDb );

					$accesshosts = getAccessHosts($nameDb);

					$itemDbUser = &addDbUserConfixx( $nodeDb,$shopUser,$passwordNode,$accesshosts );

					&checkUniqueDbUser( $shopUser,$itemDbUser,$nameDb );

					$ret++;

#
# design_<customer>_<N>
#
					$nameDb =~ s/^shop_/design_/;

					$nodeDb = XmlNode->new('database', 'attributes' => { 'name' => $nameDb, 'type' => 'mysql', 'version' => Db::MysqlUtils::getVersion()});

					$dumpDb = &makeDumpDb($nameDb,'mysql',$shopUser,$password,undef);

					$nodeDb->setAttribute('cid',$dumpDb);

					$root->addChild( $nodeDb );

					$accesshosts = getAccessHosts($nameDb);

					$itemDbUser = &addDbUserConfixx( $nodeDb,$shopUser,$passwordNode,$accesshosts );

					&checkUniqueDbUser( $shopUser,$itemDbUser,$nameDb );


					$ret++;
				}
			}

			$wrapDbh->{'FINISH'}->();

			$preparedCustomers{$customer}->{'shop'} = 1;
		}
	}
#
# end webShop
#
	return $ret;
}

my %dbUsers;

sub checkUniqueDbUser {
	my ($nameUser,$itemDbUser,$nameDb) = @_;
	my $i = 0;

	if ( exists( $dbUsers{$nameUser} ) ) {
#
# make unique name
#
		$i = $dbUsers{$nameUser}+1;
		my $newName = $nameUser.'_'.$i;
		while ( exists( $dbUsers{$newName} ) ) {
			$i++;
			$newName = $nameUser.'_'.$i;
		}
		$nameUser = $newName;

		if ( ref($itemDbUser) =~ /XmlNode/ ) {
			$itemDbUser->{'ATTRIBUTE'}->( 'name', $nameUser );
		}

	}
	$dbUsers{$nameUser} = $i;
	return $nameUser;
}


#
# end database
#



#
# make list of subdomains
#
sub getSubdomains {
	my($domain,$ptrDomainHash) = @_;

	my ($subdomain,$ptrAttrHash,$name,$reSubDomain,$sql);
	my ($pathPrefix,$rePathPrefix,$ptrSubdomains,$ptrAccounts,$customer,@tmp);
	my ($account,$path,@subsubdomains,$ptrRow);

	$pathPrefix = $ptrDomainHash->{'pfad'};
	$pathPrefix =~ s/^\///;

	$rePathPrefix = qr/^\/\Q$pathPrefix\E\// if $pathPrefix;

	$reSubDomain = qr/^(.+)\.\Q$domain\E$/;

	$ptrSubdomains = {};
	$ptrAccounts = {};
	$customer = $ptrDomainHash->{'kunde'};

	$sql = "SELECT f.account,f.longpw,d.pfad,d.domain FROM domains d ".
		" LEFT JOIN ftp f ON (f.kunde=d.kunde) AND (f.pfad = SUBSTRING(d.pfad,2)) ".
			" WHERE (d.kunde='$customer') AND (d.domain like '\%.$domain') AND (d.richtigedomain = 0)";
#
# 'domains.pfad' begins with '/', 'ftp.pfad' does not
#

	if($wrapDbh->{'EXECUTE'}->($sql)){
		while ( $ptrRow = $wrapDbh->{'FETCHROW'}->() ) {
			$path = $ptrRow->[2];
			$path =~ s/^\///;  ## remove first slash

			if ( $pathPrefix ) {
				unless ( $path =~ /$rePathPrefix/ ) {
					next;   ## not subdir
				}
			}
			$subdomain = $ptrRow->[3];

			if( $subdomain =~ /$reSubDomain/ ) {
				$ptrSubdomains->{$subdomain} = {
					'NAME' => $1,
					'PATH' => "$user_homeDir/$customer/html/$path",
					'PATH_LOCAL' => "$path",
					'PASSWORD' => $ptrDomainHash->{'longpw'}
				};
			}


			if ( $account = $ptrRow->[0] ) {
				$ptrAccounts->{$account} = 1; ## all ftp-accounts where matchs with subdomain
				$ptrSubdomains->{$subdomain}->{'ACCOUNT'} = $account;
				$ptrSubdomains->{$subdomain}->{'PASSWORD'} = $ptrRow->[1];
				$ptrSubdomains->{$subdomain}->{'PATH'} = "$user_homeDir/$customer/html/$path";
			}
		}
	}
	$wrapDbh->{'FINISH'}->();


#
# translate subdomain having mail to domain
#
	my $list = join(',',map {"'$_'"} keys %{$ptrSubdomains});
	if ( $list ) {
		$sql = "SELECT domain FROM email WHERE domain IN ($list)";
		if ( $wrapDbh->{'EXECUTE'}->($sql) ) {
			my ($emailDomain);
			while ($ptrRow=$wrapDbh->{'FETCHROW'}->()){
				$emailDomain = $ptrRow->[0];
## translate subdomain to domain if there is an email
				&removeFromSubdomains( $emailDomain, $ptrSubdomains );
			}
		}
		$wrapDbh->{'FINISH'}->();
	}

#
# translate subdomain with redirect to domain
#
	$list = join( ',', map {"'$_'"} keys %{$ptrSubdomains} );
	if( $list ) {
		$sql = "SELECT domain, pfad FROM domains WHERE (richtigedomain=0) AND ".
			"NOT (pfad LIKE '/\%') AND (domain IN ($list))";
		my ($redirectDomain);
		if( $wrapDbh->{'EXECUTE'}->( $sql ) ) {
			while ( $ptrRow = $wrapDbh->{'FETCHROW'}->()){
				$redirectDomain = $ptrRow->[0];
## translate subdomain to domain if it is a redirect
				&removeFromSubdomains( $redirectDomain, $ptrSubdomains );
			}
		}
		$wrapDbh->{'FINISH'}->();
	}

	return ( $ptrSubdomains, $ptrAccounts );

}

#
# remove domain with it subdomain
#
sub removeFromSubdomains{
	my ( $domain, $ptrHash ) = @_;
	my $reSubdomain = qr/^(.+\.)?\Q$domain\E$/;
	foreach  my $subdomain ( keys %{$ptrHash} ) {
		if( $subdomain =~ /$reSubdomain/ ) {
			delete $ptrHash->{$subdomain};
		}
	}
}

#
# end make list of subdomains
#



#
# mail system
#

sub makeMailSystem {
  my ($reseller, $customer, $domain, $spamfilter) = @_;
  my ($sql,$rootMail,$prefix,%box,%redir,@dest,$pop,$rootUser,
			$count,$ptrPrefixes,$ptrHash,$ptrRow,$item,$redirect,$account,
			@prefixes,%group,$catch_all,%alias,$mailUsersNode);

  my $mailsystem;	# mailsystem presented flag
  my @buf;		# copy of email information from database
  my $oldVer;		# ver. <= 3.0.8 flag

  # Lookup email information
  $sql="SELECT * FROM email WHERE domain='$domain' ORDER BY prefix";
  if ($wrapDbh->{'EXECUTE'}->($sql)) {

	$mailsystem = 1;
	while ($ptrHash = $wrapDbh->{'FETCHHASH'}->()) {
		push @buf,{%{$ptrHash}};
		$customer ||= $ptrHash->{'kunde'};
		if(!defined($oldVer)) {
			$oldVer = exists $ptrHash->{'pop3'};
		}
	}
  }
  $wrapDbh->{'FINISH'}->();

  # Determine mailsystem presense by domain name and pop3
  # (there may be no records in email table, but 'free' mailboxes
  # may be presented)
  if (not $mailsystem) {
	$sql = "SELECT d.kunde FROM domains d, pop3 p ".
		"WHERE d.domain='$domain' AND d.richtigedomain=1 AND d.kunde=p.kunde LIMIT 1";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {
		$ptrRow = $wrapDbh->{'FETCHROW'}->();
		$customer = $ptrRow->[0];
		$mailsystem = 1;
	}
	$wrapDbh->{'FINISH'}->();
  }

  # Mailsystem is not found on domain
  if (not $mailsystem) {
	return;
  }
  $rootMail = XmlNode->new('mailsystem');

  my @pop3s = ();
  foreach my $emailHash (@buf) {
	my $boxname = $emailHash->{'prefix'}.'@'.$emailHash->{'domain'};
	my $ident = $emailHash->{'ident'};
	$sql="SELECT pop3 FROM email_forward WHERE email_ident=$ident ORDER BY id";
	if ( $wrapDbh->{'EXECUTE'}->($sql) ) {
		while( my $ptrRow = $wrapDbh->{'FETCHROW'}->() ){
			my $boxname = $ptrRow->[0];
			if ($boxname =~ /^[^@]+\d+p\d+$/ ) { ## <user_prefix><N>p<M>  - web2p1
				push @pop3s, $boxname; ######.'@'.$domain;
		        }
		}
	}
	$wrapDbh->{'FINISH'}->();
  }
 
# process pop3 boxes without email
  if(! exists ($preparedCustomers{$customer}->{'mbox'})){
	$sql = "SELECT p.account, e.pop3 FROM pop3 p LEFT JOIN email_forward e ON (p.account = e.pop3) WHERE p.kunde='$customer' ORDER BY number";
	if ($wrapDbh->{'EXECUTE'}->($sql)) {
		while( $ptrRow = $wrapDbh->{'FETCHROW'}->() ){
			my ($account, $pop3) = @{$ptrRow};
			if (! $pop3) {
				my $accountExistsInPop3s = 0;
				foreach my $pop3 (@pop3s) {
					if ($account eq $pop3) {
						$accountExistsInPop3s = 1;
						last;
					}
				}
				if ($accountExistsInPop3s == 0) {
					push @pop3s, $account;
				}
			}				
		}			
	}
	$wrapDbh->{'FINISH'}->();
  }

  my $mailContentNode;
  if (scalar(@pop3s) > 0) {
     $mailContentNode = &makeMailAccountsBackup(\@pop3s,$reseller,$customer,$domain);
     $rootMail->addChild($mailContentNode);
  }
   

  $item = XmlNode->new('properties');
  $item->addChild(XmlNode->new('status', 'children' => [XmlNode->new('enabled')]));
  $rootMail->addChild($item);	


  foreach  $ptrHash (@buf) {
	$prefix = $ptrHash->{'prefix'};

#
# exclude catch-all from mailusers
#
	unless ( $prefix =~ /\*/ ) {
		push @prefixes,$prefix;
	} else {
		$catch_all = $prefix;
	}
	
#
# get list of destination
#
	if( $oldVer ){
		@dest = ( $ptrHash->{'pop3'} );
		push @dest, split( /:/,$ptrHash->{'pop3x'} );
	} else {
		my $ident = $ptrHash->{'ident'};
		$sql="SELECT pop3 FROM email_forward WHERE email_ident=$ident ORDER BY id";
		if ( $wrapDbh->{'EXECUTE'}->($sql) ) {
			@dest = ();
			while( my $ptrRow = $wrapDbh->{'FETCHROW'}->() ){
				push @dest, $ptrRow->[0];
			}
		}
		$wrapDbh->{'FINISH'}->();
	}
	foreach $pop ( @dest ) {
		if ($pop =~ /^[^@]+\d+p\d+$/ ) { ## <user_prefix><N>p<M>  - web2p1
			push @{$box{$pop}},$prefix; ## all emails for this mail box
			push @{$alias{$prefix}},$pop; ## all aliases for this prefix
			push @{$redir{$prefix}}, $pop.'@'.$domain;
		} elsif ( $pop =~ /\@/ ){
			push @{$redir{$prefix}}, $pop; ## prefix is unique in the domain
		}
	}
  }
  $mailUsersNode = XmlNode->new('mailusers');
  my $existMailObject = 0;  
  foreach $account (sort keys %box) {
	next if ( $account =~ /\*/ ); ## skip catch_all
	my $longpw = '';
	$existMailObject = 1;
	$sql="SELECT longpw FROM pop3 WHERE account='$account'";
	if ($wrapDbh->{'EXECUTE'}->($sql)){
		$ptrRow = $wrapDbh->{'FETCHROW'}->();
		$longpw = $ptrRow->[0];
	}
	$wrapDbh->{'FINISH'}->();
	my $mailUserNode = XmlNode->new('mailuser', 'attributes' => {'name' => $account, 'mailgroup-enabled' => 'false', 'guid' => &getResourceId($domain).'_mn_'.$mailuserId, 'owner-guid' => &getResourceId($domain), 'id' => $mailuserId});
	$mailuserId++;

	my $propertiesNodes = XmlNode->new('properties');
	if( $item = &makePasswordNode( $longpw ) ) {
		$propertiesNodes->addChild($item);
	}		
	$mailUserNode->addChild($propertiesNodes);

	if ( $majorVersion > 2 ){  ## for Confixx 3 and later
		my $limitsNode = XmlNode->new('limits-and-permissions');
		addMailuserPermissionNode($limitsNode, 'multiple-sessions', 'true');
		addMailuserPermissionNode($limitsNode, 'cp-access', 'true');
		$mailUserNode->addChild($limitsNode);
	}
			
	my $preferencesNode = XmlNode->new('preferences');
	my $mailboxNode = XmlNode->new('mailbox', 'attributes' => {'type' => $mailboxType, 'enabled' => 'true' });
	$mailboxNode->addChild($mailContentNode);
	$preferencesNode->addChild($mailboxNode);
	if ($spamfilter) {
		addSpamassassin($preferencesNode, $domain, $account);
	}		
	$mailUserNode->addChild($preferencesNode);
	$mailUsersNode->addChild($mailUserNode);
  }
  foreach $prefix (sort keys %redir ) {
	next if ( $prefix =~ /\*/ ); ## skip catch_all
	$existMailObject = 1;
	foreach $redirect ( @{$redir{$prefix}} ) {
		next if ( $redirect =~ /\*/ ); ## skip catch_all
		push @{$group{$prefix}},split( /\s*,\s*/,$redirect );
	}
	if ( 1 == @{$group{$prefix}} ) { ## only one redirect - alias
		($redirect) = @{$group{$prefix}};
	} else { ## more thet one redirect - mailgroup
		$redirect = undef;
	}
	my $mailuserNode = XmlNode->new('mailuser', 'attributes' => {'name' => $prefix, 'mailgroup-enabled' => $redirect ? 'false' : 'true', 'guid' => &getResourceId($domain).'_mn_'.$mailuserId, 'owner-guid' => &getResourceId($domain), 'id' => $mailuserId});
	$mailuserId++;
	$mailUsersNode->addChild($mailuserNode);

	my $propertiesNodes = XmlNode->new('properties');
	$mailuserNode->addChild($propertiesNodes);
	my $limitsNode = XmlNode->new('limits-and-permissions');
        $mailuserNode->addChild($limitsNode);
	
	my $preferencesNode = XmlNode->new('preferences');
	if ($redirect) {
		$preferencesNode->addChild(XmlNode->new('redirect', 'attributes' => {'enabled' => 'true'}, 'content' => $redirect));
	} else {
		foreach $pop ( @{$group{$prefix}} ) {
			$preferencesNode->addChild(XmlNode->new('mailgroup-member', 'content' => $pop));
		}
	}
	&addAutoresponders( $preferencesNode, $domain, $prefix ); # changed param list
	$mailuserNode->addChild($preferencesNode);
  }
	
  my $result =  &addFreeMailBoxes( $mailUsersNode, $reseller, $customer, $domain, $mailContentNode, $spamfilter ) if $rootMail && $customer;
  if ($existMailObject == 0 && $result>0) {
	$existMailObject = 1;  
  }
  if ($existMailObject == 1) {
	$rootMail->addChild($mailUsersNode);
  }

  if ( $catch_all ) {
	if ( ref($redir{$catch_all}) =~ /ARRAY/ ) {
		foreach my $rdr ( @{$redir{$catch_all}} ) {
			if ( $rdr ) {
				$redirect = $rdr;
				last;
			}
		}
	} else {
		$redirect = $redir{$catch_all};
	}
	unless( $redirect ) {
		if ( $redirect = $box{$catch_all} ) {
			$redirect .= '@'.$domain;
		}
	}
	if ( $redirect ) {
		my $preferencesNode = XmlNode->new('preferences');
		$preferencesNode->addChild(XmlNode->new('catch-all', 'content' => $redirect));
		$rootMail->addChild($preferencesNode);
	}
  }
  return $rootMail;
}

#
# end mail system
#



sub addDbUserConfixx {
	my ($rootNode, $customer, $passwordNode, $accesshosts) = @_;

	my $userItem = &addDbUser($rootNode, $customer, $wrapUserMysql, $passwordNode, $accesshosts);

	return $userItem;

}

#
# makeSubdomainNode  - create XML-node for subdomain
#
# argumets:
#      $name        - name of subdomain (without '.')
#      $domain      - domain
#      $ptrAttrHash - pointer to hash with attributes of subdomain
#      $ptrScriptingHash - pointer to hash with parameters of scripting
#
# return:
#      $subdomNode  - pointer to new XML-node
#

sub makeSubdomainNode {
  my( $name, $reseller, $customer, $domain, $ptrAttrHash, $ptrScriptingHash, $contentNode ) = @_;
  my ($subdomNode,$item,$path,$dumpFile);
  unless( ref($ptrAttrHash) =~ /HASH/ ) {
    $ptrAttrHash = {};
  }
  unless( ref($ptrScriptingHash) =~ /HASH/ ) {
    $ptrScriptingHash = {};
  }

  $subdomNode = XmlNode->new( 'subdomain' , 'attributes' => {'name' => $name, 'guid' => &getResourceId($domain).'_sb_1', 'owner-guid' => &getResourceId($domain).'_ph_1'});

  if (! $nocontent && $contentNode) {
  	$subdomNode->addChild($contentNode);
  }

  if ( keys %{$ptrAttrHash} ) {
	$item = &makeSysuserNode( $ptrAttrHash );
	$subdomNode->addChild( $item );
  }

  $item = &makeScriptingNode(\%mapCustScripting,$ptrScriptingHash);
  $subdomNode->addChild( $item );

  return $subdomNode;
}

#
# create system user node
# check if there was already this account
# & add a suffix to make an unique account
#
my %sysUsers;

sub makeUniqName {
  my $name = shift;

  return $name if ref($name) =~ /HASH/;
 
  $name =~ s/\./_/g;
  if ( exists( $sysUsers{$name} ) ) {
			my $clon = 1;
            while(exists($sysUsers{$name})){
				if($name =~ /(.*)c(\d+)$/){
					$name = $1;
					$clon = $2;
					$clon++;
				}
				$name .= "c$clon";
			}
		}
  $sysUsers{$name} = 1;

  return $name;

}

sub makeSysuserNode {

  my ($account,$password,$pswdType,$quota,$shell)=@_;

  my ($ptrHash,$item);

  if ( ref($account) =~ /HASH/ ) {
    $ptrHash = $account;
    $account = makeUniqName($ptrHash->{'ACCOUNT'}||$ptrHash->{'NAME'});
    $password = (exists $ptrHash->{'PASSWORD'}) ? $ptrHash->{'PASSWORD'} : '';
    $pswdType = $ptrHash->{'PSWDTYPE'};
    $shell = $ptrHash->{'SHELL'};
    $quota = $ptrHash->{'QUOTA'};
  }
	if ( $account ) {

		$item = XmlNode->new('sysuser', 'attributes' => {'name' => $account});
		if($quota){
			$item->setAttribute('quota',$quota);
		}
		if($shell){
			$item->setAttribute('shell',$shell);
		}

		$item->addChild( &makePasswordNode($password,$pswdType) );

	}

  return $item;
}

sub makeScriptingNode {
  my $ptrMapHash = shift;
  my $ptrValueHash = shift;

  my ($plesk,$confixx,$value);

  my $item = XmlNode->new('scripting');
  if(ref($ptrValueHash)=~/HASH/ && ref($ptrMapHash)=~/HASH/){
	while (($plesk,$confixx)=each(%{$ptrMapHash})){
		if ( $confixx =~ /^\d+$/ ) {
			$value = $confixx;
		}	elsif( exists ( $ptrValueHash->{$confixx} ) ) {
			$value = $ptrValueHash->{$confixx} || 0;
		} else {
			$value = undef;
		}
		if ( defined ( $value ) ) {
			$item->setAttribute($plesk,$value?'true':'false');
		}
	}
  }
  return $item;
}

sub addAutoresponders {
  my ($root,$domain,$prefix,@prefixes)=@_; 

  my($list,$sql,$ptrHash,$item,$name,$value);

  if( ref($prefix) =~ /ARRAY/ ){
	@prefixes = @{$prefix};
  } else {
	push @prefixes, $prefix;
  }
  $list = join( ',', map{"'".$_.'@'.$domain."'"} @prefixes );
  my $autorespondersNode;

  
  $sql = "SELECT * FROM autoresponder WHERE absenderemail in ($list)";
  if ($wrapDbh->{'EXECUTE'}->($sql)){
	$autorespondersNode = XmlNode->new( 'autoresponders', 'attributes' => {'enabled' => 'true'} );
	while ($ptrHash=$wrapDbh->{'FETCHHASH'}->()){
		$value = $wrapBase64->{'ENCODE'}->($ptrHash->{'emailtext'});
		$item = XmlNode->new( 'autoresponder' );
		$item->addChild(XmlNode->new( 'text', 'content' => $value ) );
		$name = (split( /\@/, $ptrHash->{'absenderemail'}))[0];
		$item->setAttribute( 'name', $name );

#
# bug #33493
#
#	$item->{'ATTRIBUTE'}->('replyto',$ptrHash->{'absenderemail'});
#
#
		$value = $ptrHash->{'emailbetreff'};
		$value = $wrapBase64->{'ENCODE'}->( $value );
		chomp $value;
		$item->setAttribute( 'subject', $value );
		$autorespondersNode->addChild( $item );
	}
	$root->addChild( $autorespondersNode );
  }
  $wrapDbh->{'FINISH'}->();
}

sub addSpamassassin {
  my ($root,$domain,$pop3)=@_;
  my ($sql,$ptrHash,$name,$value);

  my $saNode = XmlNode->new( 'spamassassin', 'attributes' => {'status' => 'on', 'action' => 'mark'} );
  my $setSubj = 0;
  $sql = "SELECT preference,value FROM spampref WHERE username='$pop3'";
  if ($wrapDbh->{'EXECUTE'}->($sql)) {
  	my (@whitelist,@blacklist);
	while ($ptrHash=$wrapDbh->{'FETCHHASH'}->()) {
		$name = $ptrHash->{'preference'};
		$value = $ptrHash->{'value'};
		if ($name eq 'rewrite_header') {
			$saNode->setAttribute('subj-text', $value);
			$setSubj = 1;
		}
		if ($name eq 'required_score') {
			$saNode->setAttribute('hits', $value);
		}
		if ($name eq 'whitelist_from') {
			push @whitelist, $value;
		}
		if ($name eq 'blacklist_from') {
                        push @blacklist, $value;
                }
	}
	foreach my $bl (@blacklist) {
		$saNode->addChild(XmlNode->new('blacklist-member', content => $bl));
	}		
	foreach my $wl (@whitelist) {
		$saNode->addChild(XmlNode->new('whitelist-member', content => $wl));
        }
  }
  $wrapDbh->{'FINISH'}->();
  if (! $setSubj) {
	$saNode->setAttribute('subj-text', 'subject ****SPAM****');
  }
  $root->addChild($saNode);
}  

sub makeMailAccountsBackup {
  my ($pop3s,$reseller,$customer,$domain)=@_;

  my ($is_inbox, $archive, $mailContentNode);

  my $archiveName = $domain."_mn_".$filedate;
  if ($maildrop eq "HOMEDIR/Mailbox") {
	if (! $mailboxType) {
		$mailboxType = 'mbox';
	}
	$archive = dumpFile($archiveName, "$pop_homeDir", $pop3s);
  } elsif ($maildrop eq "HOMEDIR/Maildir/") {
	if (! $mailboxType) {
		$mailboxType = 'mdir';
	}
	$archive = makeDumpFile($archiveName, "$pop_homeDir", $pop3s);
  } else {
	if (! $mailboxType) {
		$mailboxType = 'mbox';
	}
	$archive = makeDumpFile($archiveName, "$mailSpool", $pop3s);
  }
  if ($archive) {
	my $from = './'.$ptrArgs->{'output'}.'/'.$archiveName.'.tgz';
	my $to = './'.$ptrArgs->{'output'}.'/resellers/'.$reseller.'/'.$customer.'/'.$domain.'/';
	if (! -d $to) {
		system("mkdir -p $to");
	}
	system("mv $from $to");
	$to = "";
	$mailContentNode = &makeContentNode($archiveName.'.tgz', $to, $storage->{unpacksize}->{$archive}, $storage->_getFileSize($to.$archiveName.'.tgz'), undef); ## without mail type, because it is different for domain, mailbox, responder
    }
    return $mailContentNode;

}

sub addPinfo {
  my ($root, $ptrValue, $ptrMap, $withoutPreferencesNode) = @_;
  my ($item, $plesk, $confixx, $value, $preferencesNode);

  if (scalar(keys %$ptrMap)>0) {
  	if (! $withoutPreferencesNode) {
		$preferencesNode = XmlNode->new('preferences');
	}
	while (($plesk,$confixx) = each %{$ptrMap}) {
		if ( $value = $ptrValue->{$confixx} )  {
			if ( $plesk eq 'locale' ) { ## map name of locale
				if ( exists $mapLocales{$value} ) {
					$value = $mapLocales{$value};
					next unless $value;
				}
			}
			if ($plesk eq 'country') {
				if (exists $mapCountries{lc($value)}) {
					$value = $mapCountries{lc($value)};
					next unless $value;
				}
			}
			if (! $withoutPreferencesNode) {
				$preferencesNode->addChild(XmlNode->new('pinfo', 'content' => $value, 'attributes' => {'name' => $plesk}));
			} else {
				$root ->addChild(XmlNode->new('pinfo', 'content' => $value, 'attributes' => {'name' => $plesk}));
			}
		}
	}
	if (! $withoutPreferencesNode) {
		$root->addChild($preferencesNode);
	}
  }
}


sub addLimits {
  my ($root, $ptrValue, $ptrMap ) = @_;
  my ($item, $plesk, $confixx, $value, $sql, $ptrRow);
  while( ( $plesk, $confixx ) = each %{$ptrMap} ){
  
	$value = $ptrValue->{$confixx};
	if( $value > 0 && ($plesk eq 'disk_space' || $plesk eq 'max_traffic') ){
		$value *= 1024; ## convert to Mb
	}
	$root->addChild( XmlNode->new('limit', 'content' => $value, 'attributes' => {'name' => $plesk}) );

  }
  if ($mailQuotaValue) {
	$root->addChild(XmlNode->new('limit', 'content' => $mailQuotaValue, 'attributes' => {'name' => 'mbox_quota'}));
  }	  
}

sub addPermissions {
  my ($root,$ptrValue,$ptrMap) = @_;
  my ($plesk,$confixx,$value);
  my $shell_processed;
  
  while(($plesk,$confixx) = each %{$ptrMap}){
	if ( $confixx=~/^\d+$/ ) {
		$value = $confixx;
	}else {
		$value = $ptrValue->{$confixx};
	}
	if ($plesk eq 'manage_not_chroot_shell' || $plesk eq 'manage_sh_access') {
		$shell_processed = 1;
	}
	addPermissionNode($root, $plesk, ($value ? 'true' : 'false'));
  }
  my $manage_sh_access = 'false';
  my $manage_not_chroot_shell = 'false';

  if (! $shell_processed) {
	if ($ptrValue->{'shell'}) {  
		if ($ptrValue->{'shell'} == 1) {
			$manage_sh_access = 'true';
			$manage_not_chroot_shell = 'true';
		} else {  # "2"
			$manage_sh_access = 'true';
			$manage_not_chroot_shell = 'false';
		}
	}
	addPermissionNode($root, 'manage_sh_access', $manage_sh_access);
	addPermissionNode($root, 'manage_not_chroot_shell', $manage_not_chroot_shell);
  }
}


sub makeContentNode {
  my ($fileName,$path,$unpackedSize,$packedSize,$type)=@_;
  my ($contentNode, $cidNode);

  if ( $fileName ) {
	$contentNode = XmlNode->new('content');
	if ($type) {
		$cidNode = XmlNode->new('cid', 'attributes' => {'path' => $path, 'type' => $type, 'unpacksize' => $unpackedSize});
	} else {
		$cidNode = XmlNode->new('cid', 'attributes' => {'path' => $path, 'unpacksize' => $unpackedSize});	
	}
	$cidNode->addChild(XmlNode->new('content-file', 'content' => $fileName, 'attributes' => {'size' => $packedSize}));
	$contentNode->addChild($cidNode);		
  }
  return $contentNode;
}


sub makeWebContentNode {
  my ($fileName,$path,$unpackedSize,$packedSize,$typeAndOffsetValues)=@_;
  my ($contentNode, $cidNode);

  if ( $fileName ) {
	$contentNode = XmlNode->new('content');
	while(my ($type,$offset) = each %{$typeAndOffsetValues}){
		if ($offset) {
			$cidNode = XmlNode->new('cid', 'attributes' => {'path' => $path, 'unpacksize' => $unpackedSize, 'type' => $type, 'offset' => $offset});
		} else {
			$cidNode = XmlNode->new('cid', 'attributes' => {'path' => $path, 'unpacksize' => $unpackedSize, 'type' => $type});
		}
		$cidNode->addChild(XmlNode->new('content-file', 'content' => $fileName, 'attributes' => {'size' => $packedSize}));
		$contentNode->addChild($cidNode);
	}		
  }
  return $contentNode;
}

###############################
#
#	Reads IP information
#
###############################
sub readIpInfo() {
  my ($ptrRow,$id,$ip,$sql);
  my (%sharedIps,%exlusiveIps);

  # standard ip is shared
  $sql = "SELECT standardip FROM admin";
  if ($wrapDbh->{'EXECUTE'}->($sql)) {
	($ip) = @{$wrapDbh->{'FETCHROW'}->()};

	$exclIp{$ip} = 0;
  }
  $wrapDbh->{'FINISH'}->();

  $wrapDbh->{'EXECUTE'}->("select ip,anbieter,kunde from ipadressen");
  while ($ptrRow = $wrapDbh->{'FETCHROW'}->()) {
	$ip = $ptrRow->[0];

	# is ip exclusive or share ?
	$exclIp{$ip} = ($ptrRow->[1] || $ptrRow->[2]);
  }
  $wrapDbh->{'FINISH'}->();
}

sub makeIpNode( $ ) {
  my $ip = shift;

  my $type = 'shared';
  if ($exclIp{$ip}) {
	$type = 'exclusive';
  }

  my $ip_node = XmlNode->new('ip');
  $ip_node->addChild(XmlNode->new('ip-type', 'content' => $type));
  $ip_node->addChild(XmlNode->new('ip-address', 'content' => $ip));
  return $ip_node;
}

sub getConfixxVersion {
  my $util = "$installDir/confixx_updatescript.pl";
  my ($out, $majorVersion, $minorVersion, $pathLevel);

  unless (-x $util) {
	return;
  }

  $out = `$util VERSION`;
  chomp $out;
  if ($out =~ /^(?:premium\s+)?(\d+)\.(\d+)\.?(\d+)?/i) {
	$majorVersion = $1;
	$minorVersion = $2;
	$patchLevel = $3 || 0;
  } else {
	$out = `$util --version`;
	chomp $out;
	if ($out =~ /^(\d+)\.(\d+)\.?(\d+)?/) {
		$majorVersion = $1;
		$minorVersion = $2;
		$patchLevel = $3 || 0;
	}
  }

  if ( $majorVersion ) {
	if (	wantarray()	) {
		return(	$majorVersion, $minorVersion, $patchLevel	);
	} else {
	 	return 'Confixx ' . $majorVersion;
	}
  }
}

sub printAgentStatus {
  my $root = XmlNode->new('agent-status');

  my $out = getConfixxVersion();
  unless ($out && defined AgentConfig::iconvBin()) {
    my $item;
	if (defined AgentConfig::iconvBin()) {
	  $item = XmlNode->new('wrong-platform', 'content' =>'');
	} else {
	  $item = XmlNode->new('wrong-platform', 'content' => 'no iconv found on the source host');
	}

	$root->addChild($item);
  }

  $root->serialize(\*STDOUT);
}

sub loadMainConfig {
  my $pathToConf = shift||'';

  unless(-T $pathToConf){
	if ( exists( $ENV{'CONFIXX_ROOT'} ) && -d $ENV{'CONFIXX_ROOT'} ) {
		$pathToConf = $ENV{'CONFIXX_ROOT'}.'/confixx_main.conf';
	}
  }

  unless(-T $pathToConf){
    foreach my $prefix ('./','/root/confixx/','/usr/local/confixx/','/confixx/'){
      $pathToConf = $prefix.'confixx_main.conf';
      last if -T $pathToConf;
    }
  }

#
# get path to confixx from ctontab
#
  unless(-T $pathToConf){
	my(@out,$line,$run);

	my $grep = AgentConfig::grepBin();
	@out = `$grep -hr -e confixx /etc/crontab /etc/cron.d`;

	foreach $line ( @out ){
		chomp $line;
		$run = (split(' ',$line))[6];
		$run=~s/\/[^\/]*$//;
		$pathToConf = $run.'/confixx_main.conf';
		last if -T $pathToConf;
	}
  }

  unless(-T $pathToConf){
	my (@out,$line,$run);
	my $crontab = AgentConfig::crontabBin();
	@out = `$crontab -l`;

	foreach $line ( @out ) {
		chomp $line;
		next if ( $line =~ /^#/ ); ## comment
		$run = (split(' ',$line))[6];
		$run=~s/\/[^\/]*$//;
		$pathToConf = $run.'/confixx_main.conf';
		last if -T $pathToConf;
	}
  }

#
# end get path to confixx from crontab
#
  unless(-T $pathToConf){
	my (@out,$line,$dir);

	foreach $dir ('/root','/usr/local') {
		my $find = AgentConfig::findBin();

		@out=`$find $dir -type f -name confixx_main.conf`;

		foreach $line ( @out ) {
			chop $line;
			if ( -T $line ) {
				$pathToConf=$line;
				last;
			}
		}
		if ( -T $pathToConf ) {
			last;
		}
	}
  }

  if (-T $pathToConf){
	do $pathToConf;
  } else {
	$pathToConf='';
  }

  return $pathToConf;
}

sub getAccessHosts {
  my ($db) = @_;
  my ($sql,@hosts,$ptrRow);

  $db =~s/_/\\_/g;

  $sql = "SELECT host FROM db WHERE db = '$db'";

  if($wrapUserMysql->{'EXECUTE'}->($sql)){
  	while ($ptrRow = $wrapUserMysql->{'FETCHROW'}->()){
		push @hosts,$ptrRow->[0];
	}
  }

  $wrapUserMysql->{'FINISH'}->();

  my $ptrHosts = \@hosts;
  return $ptrHosts;
}

sub getKindsRef {
  my ($node, $name) = @_;

  my (@children, $ret);

  foreach my $key (keys %{$node}) {
	if ($key eq 'children') {
		@children = @{$node->{$key}};
	}
  }

  if ($name) {
	foreach my $child (@children) {
		if ($child->{name} eq $name) {
			push @{$ret}, $child;
		}
	}
  } else {
	$ret = \@children;
  }

  return $ret;
}

sub getKind {
  my ($node, $name) = @_;

  my (@children, $ret);
  foreach my $key (keys %{$node}) {
	if ($key eq 'children') {
		@children = @{$node->{$key}};
	}
  }

  foreach my $child (@children) {
	if ($child->{name} eq $name) {
		$ret = $child;
		last;
	}
  }
  return $ret;
}

sub getFileDate {
  my ($min, $hour, $day, $month, $year) = (localtime)[1,2,3,4,5];
  if ($min < 10) { $min="0".$min; }
  if ($hour < 10) { $hour="0".$hour; }
  if ($day < 10) { $day="0".$day; }
  if ($month < 10) { $month="0".$month; }
  $year = $year - 100;
  if ($year < 10) { $year="0".$year; }
  return $year.$month.$day.$hour.$min;
}

sub getResourceId {
  my $resourceName = shift;
  my $result;
  my $i=1;
  open(F, "echo $resourceName | md5sum |") or die "Can't execute md5sum\n";
  my ($md5sum) = <F>;
  close(F);
  $md5sum=~/(\S+)/;
  $md5sum=$1;
  foreach my $byte (split (//, $md5sum)) {
	if ($i==9 || $i==13 || $i==17 || $i==21) {
		$result.='-';
	}
	$result.=$byte;
	$i++;
  }
  return $result;
}

sub fixContentPath {
  my ($root,$reseller,$client,$domain) = @_;
  
  my (@resellers,@clients,@domains);
  my %domainsClient; # hashes with domain parents info
  my %clientsReseller;
  my $mode = 'a'; ## a - admin, r - reseller, c - client, d - domain

  if ($nocontent) {
	return $root;  	
  }
  
  if (! $reseller) {
  	# process all resellers with children
	
	my $resellersNodeName = $root->getChild('admin')->getChild('resellers');
	if ($resellersNodeName) {
		@resellers =  $resellersNodeName->getChildren('reseller');
	}
  } else {
  	$mode = 'r';
  	if (! $client) {
		push @resellers, $root;
		# process all client for the current reseller
		my $clientsNodeName = $root->getChild('clients');
		if ($clientsNodeName) {
			@clients = $clientsNodeName->getChildren('client');
			foreach my $clientValue (@clients) {
				$clientsReseller{$clientValue->getAttribute('name')} = $reseller;
			}
		}		
	} else {
		$mode = 'c';
		if (! $domain) {
			push @clients, $root;
			$clientsReseller{$client} = $reseller;
			# process all domains for the current client
			my $domainsNodeName = $root->getChild('domains');
	                if ($domainsNodeName) {
	                        @domains = $domainsNodeName->getChildren('domain');
				foreach my $domainValue (@domains) {
	                              $domainsClient{$domainValue->getAttribute('name')} = $client;
	                        }
	                }
		} else {
			push @domains, $root;
			$domainsClient{$domain} = $client;
			$clientsReseller{$client} = $reseller;
			$mode = 'd';
		}
	}
  }
  if (scalar(@resellers)==0 && scalar(@clients)==0 && scalar(@domains)==0) {
  	return $root; 
  }
  
  if (scalar(@domains)==0) {
  	if (scalar(@clients)==0) {
		foreach my $reseller (@resellers) {
			my $clientsNodeName = $reseller->getChild('clients');
	                if ($clientsNodeName) {
	                        my @clientsOfCurrentReseller = $clientsNodeName->getChildren('client');
				push @clients, @clientsOfCurrentReseller;
				foreach my $clientValue (@clientsOfCurrentReseller) {
	                                $clientsReseller{$clientValue->getAttribute('name')} = $reseller->getAttribute('name');
	                        }
	                }
		}
	}
	foreach my $client (@clients) {
		my $domainsNodeName = $client->getChild('domains');
		if ($domainsNodeName) {
			my @domainsOfCurrentClient = $domainsNodeName->getChildren('domain');
			push @domains, @domainsOfCurrentClient;
			foreach my $domainValue (@domainsOfCurrentClient) {
				$domainsClient{$domainValue->getAttribute('name')} = $client->getAttribute('name');
			}
		}
	}
  }
 
  foreach my $domainValue (@domains) {
	my $databasesValue = $domainValue->getChild('databases');
	if ($databasesValue) {
		my @databaseValues = $databasesValue->getChildren('database');
		foreach my $databaseValue (@databaseValues) {
			my $content = $databaseValue->getChild('content');
			if ($content) {
				my @cids = $content->getChildren('cid');
				foreach my $cid (@cids) {
					my $path = $cid->getAttribute('path');
					if ($path) {
						if ($mode eq 'd' || $mode eq 'c' || $mode eq 'r' || $mode eq 'a') {
							$path = 'databases';
							if ($mode eq 'c' || $mode eq 'r' || $mode eq 'a') {
								my $domainName = $domainValue->getAttribute("name");
								if ($domainName) {
									$path="$domainName/$path";
									if ($mode eq 'r' || $mode eq 'a') {	
										my $currentClient = $domainsClient{$domainName};
										if ($currentClient) {
											$path="$currentClient/$path";
										}
										if ($mode eq 'a') {
											my $currentReseller = $clientsReseller{$currentClient};
											if ($currentReseller) {
				        	                                                $path="resellers/$currentReseller/$path";
											}
										}
									}						
								}
							}
						}	
						$cid->setAttribute('path', $path);
					}
				}
			}
		}
	}
	my $mailsystemValue = $domainValue->getChild('mailsystem');
	if ($mailsystemValue) {
		my $content = $mailsystemValue->getChild('content');
		if ($content) {
			my $cid = $content->getChild('cid');
			if ($cid) {
				if ($mode eq 'd' || $mode eq 'c' || $mode eq 'r' || $mode eq 'a') {
					my $path = '';
					if ($mode eq 'c' || $mode eq 'r' || $mode eq 'a') {
						my $domainName = $domainValue->getAttribute("name");
						if ($domainName) {
							$path=$domainName;
							if ($mode eq 'r' || $mode eq 'a') {
								my $currentClient = $domainsClient{$domainName};
								if ($currentClient) {
									$path="$currentClient/$path";
								}
								if ($mode eq 'a') {
									my $currentReseller = $clientsReseller{$currentClient};
									if ($currentReseller) {
										$path="resellers/$currentReseller/$path";
									}
								}
							}
						}
					}
					$cid->setAttribute('path', $path);
				}
			}
		}
	}

	my $phostingValue = $domainValue->getChild('phosting');
	if ($phostingValue) {
		my $content = $phostingValue->getChild('content');
		if ($content) {
			my @cids = $content->getChildren('cid');
			foreach my $cid (@cids) {
				if ($mode eq 'd' || $mode eq 'c' || $mode eq 'r' || $mode eq 'a') {
					my $path = '';
					if ($mode eq 'c' || $mode eq 'r' || $mode eq 'a') {
						my $domainName = $domainValue->getAttribute("name");
						if ($domainName) {
							$path=$domainName;
							if ($mode eq 'r' || $mode eq 'a') {
								my $currentClient = $domainsClient{$domainName};
								if ($currentClient) {
									$path="$currentClient/$path";
								}
								if ($mode eq 'a') {
									my $currentReseller = $clientsReseller{$currentClient};
									if ($currentReseller) {
										$path="resellers/$currentReseller/$path";
									}
								}
							}
						}
					}
					$cid->setAttribute('path', $path);
				}
			}
		}
		
		my $webusersValue = $phostingValue->getChild('webusers');
		if ($webusersValue) {
			my @webusers = $webusersValue->getChildren('webuser');
			foreach my $webuser (@webusers) {
				my $content = $webuser->getChild('content');
				if ($content) {
					my @cids = $content->getChildren('cid');
					foreach my $cid (@cids) {
						if ($mode eq 'd' || $mode eq 'c' || $mode eq 'r' || $mode eq 'a') {
							my $path = '';
							if ($mode eq 'c' || $mode eq 'r' || $mode eq 'a') {
								my $domainName = $domainValue->getAttribute("name");
								if ($domainName) {
									$path=$domainName;
									if ($mode eq 'r' || $mode eq 'a') {
										my $currentClient = $domainsClient{$domainName};
										if ($currentClient) {
											$path="$currentClient/$path";
										}
										if ($mode eq 'a') {
											my $currentReseller = $clientsReseller{$currentClient};
											if ($currentReseller) {
												$path="resellers/$currentReseller/$path";
											}
										}
									}
								}
							}
							$cid->setAttribute('path', $path);
						}
					}
				}					
			}
		}
		my $subdomainsValue = $phostingValue->getChild('subdomains');
		if ($subdomainsValue) {
			my @subdomains = $subdomainsValue->getChildren('subdomain');
			foreach my $subdomain (@subdomains) {
				my $content = $subdomain->getChild('content');
				my @cids = $content->getChildren('cid');
				foreach my $cid (@cids) {
					if ($mode eq 'd' || $mode eq 'c' || $mode eq 'r' || $mode eq 'a') {
						my $path = '';
						if ($mode eq 'c' || $mode eq 'r' || $mode eq 'a') {
							my $domainName = $domainValue->getAttribute("name");
							if ($domainName) {
								$path=$domainName;
								if ($mode eq 'r' || $mode eq 'a') {
									my $currentClient = $domainsClient{$domainName};
									if ($currentClient) {
										$path="$currentClient/$path";
									}
									if ($mode eq 'a') {
										my $currentReseller = $clientsReseller{$currentClient};
										if ($currentReseller) {
											$path="resellers/$currentReseller/$path";
										}
									}
								}
							}
						}
						$cid->setAttribute('path', $path);
					}
				}
			}
		}		
	}
  }
  return $root;
}

sub makeServerNode {
  my ($ptrRow,$sql);
  my %netmask = ("0.0.0.0" => 0, "128.0.0.0" => 1,
		"192.0.0.0" => 2,        "224.0.0.0" => 3,
		"240.0.0.0" => 4,        "248.0.0.0" => 5,
		"252.0.0.0" => 6,        "254.0.0.0" => 7,
		"255.0.0.0" => 8,        "255.128.0.0" => 9,
		"255.192.0.0" => 10,     "255.224.0.0" => 11,
		"255.240.0.0" => 12,     "255.248.0.0" => 13,
		"255.252.0.0" => 14,     "255.254.0.0" => 15,
                "255.255.0.0" => 16,     "255.255.128.0" => 17,
                "255.255.192.0" => 18,   "255.255.224.0" => 19,
                "255.255.240.0" => 20,   "255.255.248.0" => 21,
                "255.255.252.0" => 22,   "255.255.254.0" => 23,
		"255.255.255.0" => 24,   "255.255.255.128" => 25,
		"255.255.255.192" => 26, "255.255.255.224" => 27,
		"255.255.255.240" => 28, "255.255.255.248" => 29,
		"255.255.255.252" => 30, "255.255.255.254" => 31,
		"255.255.255.255" => 32
		);

  ## 1. properties (system-ip, default-ip hostname)

  my $serverNode =  XmlNode->new('server');
  my $propertiesNode = XmlNode->new('properties');

  my $systemIPNode = XmlNode->new('system-ip');
  $systemIPNode->addChild(makeIpNode($confixx_IP));


  my ($dev, $ip, $mask);
  if(open( OUT, "/sbin/ifconfig|" ) ){
	while( <OUT> ){ ## read full output of ifconfig
		chop;
		if( /^(\S+)\s+(.*)/ ){
			$dev = $1;			
			$_ = $2;
		}
		next unless $dev;		
		if( /\s(?:inet|addr|Adresse)(?:\s|:)(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/ ){
			$ip = $1;
			if(/\s(?:Mask|mask)(?:\s|:)(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/ ){
				$mask = $1;
			}				
			if ($ip eq $confixx_IP) {
				last;
			}
		}
	}
	close( OUT );
  }else{
	warn "Error: can't run '/sbin/ifconfig': $!\n";
  }

  if ($mask && $netmask{$mask}) {
	$systemIPNode->addChild(XmlNode->new('ip-netmask', 'content' => $netmask{$mask}));
  }
  if ($dev) {
  	$systemIPNode->addChild(XmlNode->new('ip-interface', 'content' => $dev));
  }
  
  $propertiesNode->addChild($systemIPNode);
  
  my ($standardip, $dnstemplate); 
  $sql = "SELECT standardip,dnstemplate FROM admin";

  if ($wrapDbh->{'EXECUTE'}->( $sql )) {
	if ($ptrRow = $wrapDbh->{'FETCHROW'}->()) {
		$standardip = $ptrRow->[0];
		$dnstemplate = $ptrRow->[1];
		$standardip =~ s/^\s+//;
		$standardip =~ s/\s+$//;
		$propertiesNode->addChild(XmlNode->new('default-ip', 'content' => $standardip));
	}
  }
  $wrapDbh->{'FINISH'}->();
  $propertiesNode->addChild(XmlNode->new('hostname', 'content' => $hostname));
  $serverNode->addChild($propertiesNode);
 
# 2. db-servers

  my $dbServersNode = XmlNode->new('db-servers');
  my $dbServerNode = XmlNode->new('db-server', 'attributes'=>{'type' => 'mysql', 'default' => 'true'});
  $dbServerNode->addChild(XmlNode->new('host', 'content' => $dbServer));
  $dbServerNode->addChild(XmlNode->new('port', 'content' => $dbPort)); 
  my $dbAdminNode = XmlNode->new('db-admin', 'attributes'=>{'name' => $dbUser});
  $dbAdminNode->addChild(XmlNode->new('password', 'attributes'=>{'type' => 'plain'}, 'content' => $dbPw));
  $dbServerNode->addChild($dbAdminNode);
  $dbServersNode->addChild($dbServerNode);
  $serverNode->addChild($dbServersNode);

# 3. dns-settings (Confixx dns templates)

  if ($dnstemplate) {
	my @dnstemplateRecords = split(/\n/, $dnstemplate);
	if (scalar(@dnstemplateRecords) > 0) {
		my $dnssettingsNode = XmlNode->new('dns-settings', 'attributes'=>{'recursion' => 'localnets'});
		my $dnszoneNode = XmlNode->new('dns-zone', 'attributes'=>{'email' => 'root@localhost.localdomain', 'serial-format' => 'UNIXTIMESTAMP', 'type' => 'master'} );
		my $statusNode = XmlNode->new('status');
		$statusNode->addChild(XmlNode->new('enabled'));
		$dnszoneNode->addChild($statusNode);

		
		foreach my $dnstemplateRecord (@dnstemplateRecords) {
			$dnstemplateRecord =~ s/\s+$//;
			next unless($dnstemplateRecord);
			my @dnstemplateValues = split(/\s+/, $dnstemplateRecord);
			my $src = $dnstemplateValues[0];
			$src =~ s/(.*)(##)(.*)(##)(.*)/$1<$3>$5/;
			my $type = $dnstemplateValues[3];
			my $opt = '';
			my $dst = $dnstemplateValues[4];
			if ($type eq 'MX') {
				$opt = $dnstemplateValues[4];
				$dst = $dnstemplateValues[5];
			}
			$dst =~ s/(.*)(##)(.*)(##)(.*)/$1<$3>$5/;
			my $dnsRecNode = XmlNode->new('dnsrec', 'attributes'=>{'src' => $src, 'type' => $type, 'opt' => $opt, 'dst' => $dst});
			$dnszoneNode->addChild($dnsRecNode);
		}
		$dnssettingsNode->addChild($dnszoneNode);
		$serverNode->addChild($dnssettingsNode);		
	}
# 4. ssl:	
	$sql="SELECT crt,privatekey FROM cssl WHERE kunde='admin'";
	if ($wrapDbh->{'EXECUTE'}->($sql)){
		if($ptrRow = $wrapDbh->{'FETCHROW'}->()){
			my $certificatesNode = XmlNode->new('certificates');
			my $certificateNode = XmlNode->new('certificate', 'attributes'=>{'name' => 'default certificate', 'default' => 'true'});
			$certificateNode->addChild(XmlNode->new('certificate-data', 'content' => $ptrRow->[0]));
			$certificateNode->addChild(XmlNode->new('private-key', 'content' => $ptrRow->[1]));
			$certificatesNode->addChild($certificateNode);
			$serverNode->addChild($certificatesNode);
		}
	}
	$wrapDbh->{'FINISH'}->();
  }
  return $serverNode;        
}

sub printHelp {

  print <<"HELP";

Usage:
  $0 <options>

Options:
  -c |--config=<path>        path to confixx_main.conf

  -s |--get-status           get status of the agent
  -dc|--dump-accounts=<list> a coma separated list of resellers or customers to dump
  -dd|--dump-domains=<list>  a coma separated list of domains to dump
  -da|--dump-all             make a full dump

  -lc|--get-content-list     get list of content files
  -nc|--no-content           do not make content files
  -nz|--no-compress          do not compress content files

  -h |--help                 this help

HELP
}

