#!/usr/bin/perl

package DomainInfo;


sub new {
  my %List;
  my $self = { List => \%List };
  bless($self);

  return $self;
}

sub has_domain(){
  my( $self, $name ) = @_;
  return exists ${$self->{List}}{$name};
}

sub new_domain(){
  my %ret = ( name => undef, ip => undef, iptype=> 'shared', rootdir => undef, cgidir => undef, www => undef  );
  return %ret;
}

sub get_count(){
  my( $self ) = @_;
  return scalar( keys %{$self->{List}} );
}

sub get_domain_name(){
   my( $self, $index ) = @_;
   my %accounts = $self->{List};
   my @keys = keys %{$self->{List}};
   return $keys[$index];
}


sub add_domain(){
  my( $self, $domainname, $ip ) = @_;
  if( not $self->has_domain( $domainname ) ){
     my %domain = DomainInfo::new_domain();
     $domain{name} = $domainname;
     $domain{ip} = $ip if $ip;
     ${$self->{List}}{$domainname} = \%domain;
     return 1;
  }
  return 0;
}


sub get_domain(){
  my( $self, $name ) = @_;
  if( $self->has_domain($name) ){ return ${$self->{List}}{$name}; }
  else{ return undef; }
}

sub get_domain_ip(){
  my( $self, $name) = @_;
  my $domain = $self->get_domain($name);
  return ${$domain}{ip} if $domain;
  return undef;
}

sub get_domain_ip_type(){
  my( $self, $name) = @_;
  my $domain = $self->get_domain($name);
  return ${$domain}{iptype} if $domain;
  return undef;
}

sub set_domain_ip_type(){
  my( $self, $name, $iptype) = @_;
  my $domain = $self->get_domain($name);
  if( $domain ){
    ${$domain}{iptype}  = $iptype;
    return 1;
  }
  return 0;
}

sub get_domain_www(){
  my( $self, $name) = @_;
  my $domain = $self->get_domain($name);
  return ${$domain}{www} if $domain;
  return undef;
}

sub set_domain_www(){
  my( $self, $name, $www) = @_;
  my $domain = $self->get_domain($name);
  if( $domain ){
    if( $www ) { ${$domain}{www}  = 1; }
    else { ${$domain}{www}  = 0; }
    return 1;
  }
  return 0;
}





1;