package DumpStatus;

use strict;

use vars qw|@ISA|;

# -- Factory

my @reg_errors;
my @reg_warns;

sub createBackup {
  require BackupDumpStatus;
  return BackupDumpStatus->new();
}

sub createMigration {
  my ($outputFile) = @_;

  require MigrationDumpStatus;
  return MigrationDumpStatus->new($outputFile);
}

# -- DumpStatus interface

sub new {
  my $self = {};
  bless($self, shift);
  $self->_init(@_);
  return $self;
}

sub _init {
  my ($self) = @_;
}

sub start {
  my ($self, $clients, $domains) = @_;

  die "Pure virtual function call";
}

sub startDomain {
  my ($self, $domain) = @_;

  die "Pure virtual function call";
}

sub startClient {
  my ($self, $client) = @_;

  die "Pure virtual function call";
}

sub finish {
  my ($self) = @_;

  die "Pure virtual function call";
}

sub registerError{
  my( $err ) = @_;
  my @data;
  push @data, $err;
  _registerError( \@data );
}

sub registerWarning{
  my( $warn ) = @_;
  my @data;
  push @data, $warn;
  _registerWarning( \@data );
}

sub _registerError{
  my( $data ) = @_;
  push @reg_errors, $data;
}

sub _registerWarning{
  my( $data ) = @_;
  push @reg_warns, $data;
}

sub getRegistedErrors{
  return @reg_errors;
}

sub getRegistedWarnings{
  return @reg_warns;
}

1;

# Local Variables:
# mode: cperl
# cperl-indent-level: 2
# indent-tabs-mode: nil
# tab-width: 4
# End: