#!/usr/bin/perl
package HelpFuncs;
# Port to Unix

use  Logging;


my $logFileName = undef;
my $dumpFileName = undef;
my $statusFileName = undef;

sub set_log_file{
  $logFileName = $_[0];
  unlink $logFileName if $logFileName and -e $logFileName;
}




sub log_debug{
  Logging::debug( "$_[0] ( $_[1] )" );
}

sub log_error{
  Logging::error( "$_[0] ( $_[1] )" );
}

sub log_admin{
  Logging::info( "$_[0] ( $_[1] )" );
}

sub log_info{
  Logging::info( "$_[0] ( $_[1] )" );
}



sub set_dump_file{
 #nothing to do linux
}

sub set_status_file{
 #nothing to do linux
}

sub write_status
{
 #nothing to do linux
}

sub negation{
	my ($val) = @_;
	if ($val eq 'true') {
		return 'false';
	}
	if ($val eq 'false') {
		return 'true'; 
	}
}

sub checkValue{
	my ($val, $defaultVal, $checkVal) = @_;
	if( defined $val ) {
		if ( defined $checkVal ) {
			return $checkVal if $val eq $checkVal;
		}
		else {
			return $val;
		}
	} 
	return $defaultVal;
}

sub dieWithError{
  my( $msg, $errCode ) = @_;
  $errCode = -1 if not $errCode;
  log_error( "The program faield with error $errCode", $msg );
  my $idx = 1;
  my $package = 1;
  my $tab = ' ';
  my $callstack = '';
  while( $package and $idx<15 ) {
      my  ($package, $filename, $line, $subroutine, $hasargs, $wantarray, $evaltext, $is_require, $hints, $bitmask) = caller($idx);
      if( $package ) {
          $tab = $tab . ' ';
          $callstack .= "\n$tab Stack[$idx]. Sub:$subroutine [Package:$package][Filename:$filename]Line:$line";
      }
     $idx = $idx + 1;
    }
  die "\nDie with error:$msg\nCall stack:\n$callstack";
}


sub write_dump{
 #nothing to do linux
}


sub getUniqueDir{
  my( $path, $prefix ) = @_;
  my $cnt = 1;
  while( -e "$path/$prefix\[$cnt\]" ){ $cnt += 1; }
  return "$path/$prefix\[$cnt\]";
}

sub deleteFolder{
  my( $path ) = @_;
  opendir( DH, $path );
  my $dir;
  while( ( $dir = readdir( DH ) ) ){
    if( not $dir eq '.' and not $dir eq '..' ){
      if( -d "$path/$dir" ){
	    deleteFolder( "$path/$dir" );
            if( not rmdir "$path/$dir" ) { log_error "Cannot delete directory $path/$dir"; }
        }
      else{ unlink "$path/$dir" or log_error "Cannot delete file '$path/$dir'"; }
    }
  }
  closedir( DH );
 if( not rmdir $path ) { log_error "Cannot delete directory $path"; }
}

1;