package Status;

use strict;

use XmlNode;

use vars qw($ENABLED $STATUS $WITH_PARENT $ADMIN $CLIENT $EXPIRED $BACKUP $RESELLER);

$ENABLED = 0;
$STATUS = 1;
$WITH_PARENT = 2;
$BACKUP = 4;
$ADMIN = 16;
$CLIENT = 64;
$EXPIRED = 256;
$RESELLER = 32;

my $MASK = $STATUS | $WITH_PARENT | $ADMIN | $CLIENT | $EXPIRED | $RESELLER;

sub makeDisabledBy {
  return XmlNode->new('disabled-by', 'attributes' => {'name', $_[0] });
}

sub make {
   my ($status) = @_;

    my $node = XmlNode->new('status');

   $node->addChild(XmlNode->new('enabled')) if ($status & $MASK)==0 || ($status & $MASK)==$BACKUP;

    my $statuses = { $STATUS => 'domadm', $WITH_PARENT => 'parent',
                     $ADMIN => 'admin', $CLIENT => 'client',
                     $EXPIRED => 'expired', $RESELLER => 'reseller' };
    foreach my $s (keys(%{$statuses})) {
      $node->addChild(makeDisabledBy($statuses->{$s})) if ($status & $s);
    }
    return $node;
}

1;

# Local Variables:
# mode: cperl
# cperl-indent-level: 2
# indent-tabs-mode: nil
# tab-width: 4
# End:
