package Storage::TarBundle;

use strict;
use Storage::Bundle;
use AgentConfig;
use vars qw|@ISA|;

@ISA=qw|Storage::Bundle|;

sub _init {
  my ($self, %options) = @_;
  $self->SUPER::_init(%options);

  $self->{follow_symlinks} = 1 if defined $options{follow_symlinks};

  if (exists $options{include}) {
    $self->{include} = fileListToFile($options{include});
  }
  if (exists $options{exclude}) {
    $self->{exclude} = fileListToFile($options{exclude});
  }
  if (exists $options{no_recursion}) {
    $self->{no_recursion} = 1;
  }

  if (exists $options{add_file}) {
    $self->{add_file} = $options{add_file};
  }

  return -d $self->{srcdir};
}

sub fileListToFile {
  my ($fileList) = @_;

  #FIXME: detect who is passing non-chomped filenames
  chomp @{$fileList};

  my $fileName = POSIX::tmpnam();
  open FILELIST, ">$fileName";
  print FILELIST "$_\n" foreach @{$fileList};
  close FILELIST;

  return $fileName;
}

sub commandLine {
  my ($self) = @_;

  # FIXME: check tar presence
  my $tar = AgentConfig::tarBin();

  # Explicit -f - here because FreeBSD requires it
  my $cmd = "$tar -f - -c";

  $cmd .= " -h" if exists $self->{follow_symlinks};

  # FIXME: --ignore-failed-read

  $cmd .= " --no-recursion" if exists $self->{no_recursion};

  $cmd .= " -X '$self->{exclude}'" if exists $self->{exclude};

  if (exists $self->{include}) {
    $cmd .= " -T '$self->{include}'";
  } else {
    if (exists $self->{add_file}) {
      $cmd .= " --add-file='$self->{add_file}'";
    }else {
        $cmd .= " *";
    }
  }

  return $cmd;
}

sub cleanup {
  my ($self) = @_;

  $self->SUPER::cleanup();

  unlink($self->{include}) if exists $self->{include};
  unlink($self->{exclude}) if exists $self->{exclude};
}