package Db::MysqlDbiBackend;

use strict;
use Db::DbiBackend;
use Db::MysqlUtils;

use vars qw|@ISA|;

@ISA = qw|Db::DbiBackend|;

#
# 'name', 'user', 'password'[, 'host'][, 'socket'][, 'port'][, 'utf8names']
#

sub _init {
  my ($self, %params) = @_;

  $self->SUPER::_init(%params, 'type'=>'mysql');

  if (defined $params{host} and defined $params{socket}) {
	return "socket & host are mutually exclusive";
  }

  $self->{socket} = $params{socket} if defined $params{socket};
  $self->{port} = $params{port} if defined $params{port};
  $self->{utf8names} = $params{utf8names} if defined $params{utf8names};
}

sub _composeDbiAddress {
  my ($self) = @_;

  my $address = $self->SUPER::_composeDbiAddress();
  $address .= ";mysql_socket=$self->{socket}" if defined $self->{socket};
  $address .= ";port=$self->{port}" if defined $self->{port};
  return $address;
}

sub connect {
  my ($self) = @_;

  return if !($self->SUPER::connect());

  if ($self->{utf8names} && Db::MysqlUtils::doesSupportCharacterSets($self)) {
    $self->execute(Db::MysqlUtils::getCharacterSetsSupportSql());
    $self->execute(Db::MysqlUtils::getNamesCharacterSetsSupportSql());
  }

  return 1;
}

sub execute {
  my ($self, $sql) = @_;

  my $res = $self->SUPER::execute($sql);

  return $res if $res;

  #
  # Reconnect on timeout
  #
  Logging::warning("Timeout occured during mysql query. Reconnecting.");
  $self->{dbh}->disconnect();
  die if !$self->connect();

  return $self->SUPER::execute($sql);
}

1;
