package Db::PostgresqlDbiBackend;

use strict;
use Db::DbiBackend;

use vars qw|@ISA|;

@ISA = qw|Db::DbiBackend|;

sub _init {
  my ($self, %params) = @_;

  $self->SUPER::_init(%params, 'type'=>'Pg');
}

sub _composeDbiAddress {
  my ($self) = @_;

  # Postgres don't like host specification for localhost connects
  my $address = "DBI:$self->{type}:dbname=$self->{name}";
  if ($self->{host} ne "localhost") {
    $address .= ";host=$self->{host}" if defined $self->{host};
  }
  return $address;
}
