package Encoding;

use AgentConfig;
use Utf8Checker;

#
# ::setDefaultEncoding()
#
# ::encode($text[, $encoding])
#

my $defaultEncoding;

sub encode {
  my ($text, $fromEncoding) = @_;

  return $text if !$text or $text =~ /^[\x00-\x7f]*$/s;

  $fromEncoding = _getDefaultEncoding() unless $fromEncoding;

  if ($fromEncoding =~ /UTF-?8/i) {
    return $text if Utf8Checker::check($text);

    Logging::warning("Encoding::encode: source UTF-8 encoding declared, but invalid UTF-8 sequence occured. Falling back to ISO-8859-1");
    $fromEncoding = "ISO-8859-1";
  }

  return _iconv($text, $fromEncoding);
}

sub setDefaultEncoding {
  $defaultEncoding = shift;
}

sub _getDefaultEncoding {
  return $defaultEncoding if $defaultEncoding;

  if (exists $ENV{'LANG'}) {
    my @parts = split /\./, $ENV{'LANG'};
    $defaultEncoding = $parts[1] if $parts[1];
    chomp $defaultEncoding;
    return $defaultEncoding if $defaultEncoding;
  }

  if (AgentConfig::localeBin() and open(CHARMAP, AgentConfig::localeBin() . " charmap |")) {
    binmode CHARMAP;
    $defaultEncoding = <CHARMAP>;
    close CHARMAP;
    chomp $defaultEncoding;
    return $defaultEncoding if $defaultEncoding;
  }

  $defaultEncoding = "ISO-8859-1";
  return $defaultEncoding;
}

sub _iconv {
  my ($text, $fromEncoding) = @_;
  $text =~ s/\'/\'"\'"\'/g;

  open(IC, "echo '$text' | " . AgentConfig::iconvBin() . " -f '$fromEncoding' -t UTF-8 |") || return;
  binmode IC;
  my $converted = join "", <IC>;
  close IC;
  chomp $converted;
  return $converted;
}

1;

# Local Variables:
# mode: cperl
# cperl-indent-level: 2
# indent-tabs-mode: nil
# tab-width: 4
# End:
