package Logging;

use strict;
use POSIX;

use vars qw|$verbosity|;
$verbosity = 5;


my %handlerProc;


sub setVerbosity {
  $verbosity = shift;
}

sub getVerbosity {
  return $verbosity;
}

sub setOnError {
 $handlerProc{onerror} = shift;
}

sub setOnWarning {
 $handlerProc{onwarning} = shift;
}

my $outputHandle;

sub setOutput {
  my ($fh) = @_;
  $outputHandle = $fh;
}

sub getOutput{
  return $outputHandle if defined $outputHandle;
  return \*STDERR;
}

sub date {
  return POSIX::strftime("%T", gmtime(time()));
}


sub error {
  if ( $verbosity > 0 ) {
    my $fh = getOutput();
    print $fh ( date(), " ERROR ", @_, "\n" ); 
  }
  $handlerProc{onerror}->( @_ ) if exists $handlerProc{onerror} and ref $handlerProc{onerror} eq 'CODE';
}

sub warning {
  if ( $verbosity > 1) {
    my $fh = getOutput();
    print $fh ( date(), " WARN  ", @_, "\n" );
  }
  $handlerProc{onwarning}->( @_ ) if exists $handlerProc{onwarning} and ref $handlerProc{onwarning} eq 'CODE';
}

sub info {
  if ( $verbosity > 2) {
    my $fh = getOutput();
    print $fh ( date(), " INFO  ", @_, "\n" );
  }
}

sub debug {
  if ( $verbosity > 3) {
    my $fh = getOutput();
    print $fh ( date(), " DEBUG ", @_, "\n" );
  }
}

sub trace {
  if ( $verbosity > 4) {
    my $fh = getOutput();
    print $fh ( date(), " TRACE ", @_, "\n" );
  }
}

1;