#!/usr/bin/perl
package MailAccount;


sub new {
  my %List;
  my $self = { List => \%List };
  bless($self);

  return $self;
}

sub has_account(){
  my( $self, $name ) = @_;
  return exists ${$self->{List}}{$name};
}

sub new_account(){
  my %ret = ( name => undef, pwd => undef, domain => undef, maildir => undef, quota => undef, redirect => undef, redirect_status => 'false', alias => undef, postbox => 'true', isgroup => 'false' );
  return %ret;
}

sub get_count(){
  my( $self ) = @_;
  return scalar( keys %{$self->{List}} );
}

sub get_account_name(){
   my( $self, $index ) = @_;
   my %accounts = $self->{List};
   my @keys = keys %{$self->{List}};
   return $keys[$index];
}

sub add_account(){
  my( $self, $domain, $name, $pwd ) = @_;
  if( not $self->has_account( $name ) ){
     my %account = MailAccount::new_account();
     $account{name} = $name;
     $account{domain} = $domain;
     $account{pwd} = $pwd;
     ${$self->{List}}{$name} = \%account;
     return 1;
  }
  return 0;
}

sub get_account(){
  my( $self, $name ) = @_;
  if( $self->has_account($name) ){ return ${$self->{List}}{$name}; }
  else{ return undef; }
}

sub get_account_pwd(){
  my( $self, $name) = @_;
  my $account = $self->get_account($name);
  return ${$account}{pwd} if $account;
  return undef;
}

sub get_account_domain(){
  my( $self, $name) = @_;
  my $account = $self->get_account($name);
  return ${$account}{domain} if $account;
  return undef;
}


sub set_account_maildir(){
  my( $self, $name, $maildir ) = @_;
#  $maildir =~ s/\/var\/qmail\//C:\/qmail\//os; #Debug!
  my $account = $self->get_account($name);
  if( $account ) { ${$account}{maildir} = $maildir; }
  else{ return 0; }
  return 1;
}

sub get_account_maildir(){
  my( $self, $name) = @_;
  my $account = $self->get_account($name);
  return ${$account}{maildir} if $account;
  return undef;
}

sub set_account_redirect(){
  my( $self, $name, $redir ) = @_;
  my $account = $self->get_account($name);
  if( $account ) {
 	if( defined( ${$account}{redirect} ) ) { ${$account}{redirect} .= ';' . $redir; }
        else{ ${$account}{redirect} = $redir; }
  }
  else { return 0; }
  return 1;
}

sub get_account_redirect(){
  my( $self, $name) = @_;
  my $account = $self->get_account($name);
  return ${$account}{redirect} if $account;
  return undef;
}

sub bool_to_str{
  my( $val ) = @_;
  if( $val ) { return 'true'; }
  return 'false';
}

sub set_account_redirect_satus(){
  my( $self, $name, $status ) = @_;
  my $account = $self->get_account($name);
  if( $account ) { ${$account}{redirect_status} = bool_to_str( $status ); }
  else{ return 0; }
  return 1;
}

sub get_account_redirect_satus(){
  my( $self, $name) = @_;
  my $account = $self->get_account($name);
  return 1 if $account and ${$account}{redirect_status} eq 'true';
  return 0;
}

sub set_account_quota(){
  my( $self, $name, $maildir ) = @_;
  my $account = $self->get_account($name);
  if( $account ) { ${$account}{quota} = $maildir; }
  else{ return 0; }
  return 1;
}

sub get_account_quota(){
  my( $self, $name) = @_;
  my $account = $self->get_account($name);
  return ${$account}{quota} if $account;
  return undef;
}

sub set_account_postbox(){
  my( $self, $name, $status ) = @_;
  my $account = $self->get_account($name);
  if( $account ) { ${$account}{postbox} = bool_to_str( $status ); }
  else{ return 0; }
  return 1;
}

sub get_account_postbox(){
  my( $self, $name) = @_;
  my $account = $self->get_account($name);
  return 1 if $account and ( ${$account}{postbox} eq 'true' );
  return 0;
}

sub set_account_isgroup(){
  my( $self, $name, $status ) = @_;
  my $account = $self->get_account($name);
  if( $account ) { ${$account}{isgroup} = bool_to_str( $status ); }
  else{ return 0; }
  return 1;
}

sub get_account_isgroup(){
  my( $self, $name) = @_;
  my $account = $self->get_account($name);
  return 1 if $account and ${$account}{isgroup} eq 'true';
  return 0;
}

1;