package MigrationDumpStatus;

use strict;
use DumpStatus;
use Logging;
use XmlNode;

use vars qw|@ISA|;

@ISA = qw|DumpStatus|;

sub _init {
  my ($self, $filename) = @_;
  $self->{filename} = $filename;

  Logging::info("-" x 60);
  Logging::info("Migration status reporting initialized.");
  Logging::info("Status file: $filename");
  Logging::info("-" x 60);
}

sub start {
  my ($self, $clients, $domains) = @_;
  $self->{current_client} = undef;
  $self->{current_domain} = undef;
  $self->{clients_count} = $clients;
  $self->{domains_count} = $domains;
  $self->{clients_done} = 0;
  $self->{domains_done} = 0;

  $self->_publish();
}

sub startDomain {
  my ($self, $domain) = @_;
  $self->{current_domain} = $domain;
}

sub endDomain {
  my ($self, $domain) = @_;
  $self->{current_domain} = undef;
  ++$self->{domains_done};
  $self->_publish();
}

sub startClient {
  my ($self, $client) = @_;
  $self->{current_client} = $client;
}

sub endClient {
  my ($self, $client) = @_;
  $self->{current_client} = undef;
  ++$self->{clients_done};
  $self->_publish();
}

sub finishObjects {
  my ($self) = @_;

  $self->{current_client} = undef;
  $self->{current_domain} = undef;
  $self->_publish();
}

sub finish {
}

sub _publish {
  my ($self) = @_;
  my $tmpfile = $self->{filename} . ".tmp";

  open STATUS, ">$tmpfile";
  binmode STATUS;

  my $xmlRoot = XmlNode->new('agent-dump-status' );
  $xmlRoot->setAttribute( 'total-domains', $self->{domains_count} );
  $xmlRoot->setAttribute( 'total-accounts', $self->{clients_count} );
  $xmlRoot->setAttribute( 'completed-domains', $self->{domains_done}<=$self->{domains_count} ? $self->{domains_done} : $self->{domains_count} );
  $xmlRoot->setAttribute( 'completed-accounts', $self->{clients_done}<=$self->{clients_count} ? $self->{clients_done} : $self->{clients_count} );
  $xmlRoot->serialize(\*STATUS);
  close(STATUS);

  rename($tmpfile, $self->{filename});
}


sub registerError{
  my( $self, $err ) = @_;
  my @data;
  if( $err ){
     push @data, $err;
     if( exists $self->{current_domain} && $self->{current_domain} ) {
     	push @data, $self->{current_domain};
        push @data, 'domain';
     }
     elsif( exists $self->{current_client} && $self->{current_client} ){
     	push @data, $self->{current_client};
        push @data, 'account';
     }
     DumpStatus::_registerError( \@data );
  }
}

sub registerWarning{
  my( $self, $warn ) = @_;
  my @data;
  if( $warn ){
     push @data, $warn;
     if( exists $self->{current_domain} && $self->{current_domain} ){
     	push @data, $self->{current_domain};
        push @data, 'domain';
     }
     elsif( exists $self->{current_client} && $self->{current_client} ){
     	push @data, $self->{current_client};
        push @data, 'account';
     }
     DumpStatus::_registerWarning( \@data );
  }
}

1;

# Local Variables:
# mode: cperl
# cperl-indent-level: 2
# indent-tabs-mode: nil
# tab-width: 4
# End: