package Storage::Storage;

use strict;
use Storage::Bundle;

sub new {
  my $self = {};
  bless($self, shift);
  $self->_init(@_);
  return $self;
}

#
# common options:
# 'gzip' => 0|1
#

sub _init {
  my ($self, %options) = @_;
}

#
# bundle parameters:
# 'directory' => string
# bundle options:
# 'include' => ref([string])
# 'exclude' => ref([string])
# 'follow-symlinks' => 1
# 'user' => string
#

#
# Writes the descriptor (XML index) to the storage.
#

sub finish {
  my ($self, $descriptor) = @_;

  die "Pure virtual function call";
}

#
# Writes the descriptor (XML index) to the storage.
#

sub finishChild {
  my ($self, $descriptor, $savePath) = @_;

  die "Pure virtual function call";
}

sub getFilesFromId{
  my ($self, $id) = @_;

  die "Pure virtual function call";
}


sub getFilePathFromId{
  my ($self, $id) = @_;

  die "Pure virtual function call";
}


sub getFilesUnpackSizeFromId{
  my ($self, $id) = @_;

  die "Pure virtual function call";

}

sub writeDiscovered{
  my ( $self, $dumpPath, $dumpXmlName, $dumpSize, $objGuid ) = @_;

 die "Pure virtual function call";
}

sub getDumpFiles{
  my ($self) = @_;

  die "Pure virtual function call";
}

sub getMainDumpXmlFile{
  my ($self) = @_;

  die "Pure virtual function call";
}

sub getDefExtension{
  my ($self) = @_;
  return '';
}


sub noDefExtension{
  my ($self) = @_;
  return 1 if exists $self->{nodefext};
  return 0;
}

sub setNoDefExtension{
  my ($self) = @_;
  $self->{nodefext} = 1;
}

# -- Factory --

sub createMimeStorage {
  return createFileStorage( @_ );
#  my ($gzip, $outputFile, $splitsize) = @_;
#  require Storage::MimeStorage;
#  return Storage::MimeStorage->new('gzip' => $gzip,
#                                   'output_file' => $outputFile,
#                                   'split_size' => $splitsize);
}

#
# Additional option: splitsize. see the split(1) for the formats
#

sub createFileStorage {
  my ($gzip, $outputFile, $splitsize, $sign ) = @_;
  require Storage::FileStorage;
  return Storage::FileStorage->new('gzip_bundle' => $gzip,
                                   'output_dir' => $outputFile,
                                   'split_size' => $splitsize,
                                   'sign' => $sign );
}


sub startCollectStatistics ( $ ) {
  my $self = shift(@_);

  $self->{collectStatistics} = 1;
  $self->{statistics}->{sqlTime} = 0;
  use StopWatch;
  $self->{stopWatch} = StopWatch->new();
}

sub stopCollectStatistics ( $ ) {
  my $self = shift(@_);

  $self->{collectStatistics} = 0;
  delete $self->{statistics};
  delete $self->{stopWatch};
}

sub getStatistics ( $ ) {
  my $self = shift(@_);

  return $self->{statistics};
}

1;