import sys

PROGRAM = sys.argv[0]
MAILMAN_PATH = sys.argv[1]
sys.path.append(MAILMAN_PATH)

import getopt
import string

from Mailman import Utils
from Mailman.MailList import MailList

try:
    True, False
except NameError:
    True = 1
    False = 0

def main():
    try:
        opts, args = getopt.getopt(sys.argv[2:], 'wmh',
                                   ['with-listnames', 'moderators', 'help'])
    except getopt.error, msg:
        usage(1, msg)

    withnames = moderators = False
    for opt, arg in opts:
        if opt in ('-h', '--help'):
            usage(0)
        elif opt in ('-m', '--moderators'):
            moderators = True
        elif opt in ('-w', '--with-listnames'):
            withnames = True

    listnames = args or Utils.list_names()
    bylist = {}

    for listname in listnames:
        listname = string.lower(listname)
        mlist = MailList(listname, lock=0)
        addrs = mlist.owner[:]
        if moderators:
            addrs.extend(mlist.moderator)
        bylist[listname] = addrs

    if withnames:
        for listname in listnames:
            listname = string.lower(listname)
            unique = {}
            for addr in bylist[listname]:
                unique[addr] = 1
            keys = unique.keys()
            keys.sort()
            print listname
            for k in keys:
                print '\t', k
    else:
        unique = {}
        for listname in listnames:
            listname = string.lower(listname)
            for addr in bylist[listname]:
                unique[addr] = 1
        keys = unique.keys()
        keys.sort()
        for k in keys:
            print k



if __name__ == '__main__':
    main()

