#!/bin/sh

usage()
{
  echo "  Usage: `basename $0` <domain_type> <user_home> <docroot_dir> <excludes> <output_dir> <domain_name> <time_stamp> <subdom_dirs> <ftp_dirs>"
  echo "      Where:"
  echo "         domain_type -	0|1 . 0 - domain, 1 - subdomain"
  echo "         user_home -	User home directory. Example: /home/user1"
  echo "         docroot_dir -	Directory with domain content. Example: html"
  echo "         excludes -	List of directories that woun't be archived. Example: cgi-bin,private,temp"
  echo "         output_dir -	Directory for result archive file. Example: /root/migration"
  echo "         domain_name -	Name of domain. Example: domain.com"
  echo "         time_stamp -	Time of backup. Example: 1234567890"
  echo "         subdom_dirs -  In format: subdomain_dir_confix=subdomain_dir_plesk . Example: html/second=second"
  echo "         ftp_dirs -     In format ftp_user=dir. Example: savoy0f1=test"
  echo ""
  exit 1
}

[ $# -ne 9 ] && usage

DOMAIN_TYPE=$1
USER_HOME=$2
DOCROOT_DIR=$3
EXCLUDES=$4
OUTPUT_DIR=$5
DOMAIN_NAME=$6
TIME_STAMP=$7
SUBDOM_VAL=$8
FTP_VAL=$9
[ "x$SUBDOM_VAL" = "x0" ] && SUBDOM_VAL=""
[ "x$FTP_VAL" = "x0" ] && FTP_VAL=""

for i in `echo "$EXCLUDES" | sed 's/,/ /g'`
do
  EXCL_LINE="$EXCL_LINE`echo -n \" --exclude=$i\"`"
done


OUTPUT="`pwd`/$OUTPUT_DIR"
TMP_DIR="confixx_to_plesk9_migrator_tmp_dir_42342450993"
cd $USER_HOME || exit 1
mkdir -p $OUTPUT

ROOT_DIR=`dirname $USER_HOME/$DOCROOT_DIR`

[ -d $TMP_DIR ] && rm -rf $TMP_DIR
cd $ROOT_DIR || exit 2
[ -d $TMP_DIR ] && rm -rf $TMP_DIR
mkdir -p $TMP_DIR
cd $TMP_DIR || exit 3

ln -s $USER_HOME/$DOCROOT_DIR httpdocs || exit 4

tar cfh ${USER_HOME}/${DOMAIN_NAME}.tar httpdocs $EXCL_LINE || exit 5

if [ -d httpdocs/cgi-bin ]; then
  cd httpdocs || exit 6
  tar rfh ${USER_HOME}/${DOMAIN_NAME}.tar cgi-bin || exit 7
  cd .. || exit 8
fi

if [ $DOMAIN_TYPE -eq 0 ]; then
  mkdir statistics || exit 9
  ln -s ${USER_HOME}/log statistics/logs || exit 10
  tar rfh ${USER_HOME}/${DOMAIN_NAME}.tar statistics/logs || exit 11
fi

### Subdomains ###
for VAL in `echo "$SUBDOM_VAL" | sed 's/,/ /g'`
do
  #echo $VAL
  SUB_DIR_CONFIX=`echo $VAL | awk -F"=" '{print $1}'`
  SUB_DIR_PLESK=` echo $VAL | awk -F"=" '{print $2}'`
  mkdir -p subdomains/$SUB_DIR_PLESK || exit 12
  cd subdomains/$SUB_DIR_PLESK || exit 13
  ln -s ${USER_HOME}/$SUB_DIR_CONFIX httpdocs || exit 14
  ln -s ${USER_HOME}/$SUB_DIR_CONFIX/cgi-bin ./ || exit 15
  cd -
  tar rfh ${USER_HOME}/${DOMAIN_NAME}.tar subdomains/$SUB_DIR_PLESK/httpdocs --exclude=cgi-bin || exit 16
  [ -d subdomains/$SUB_DIR_PLESK/cgi-bin ] && ( tar rfh ${USER_HOME}/${DOMAIN_NAME}.tar subdomains/$SUB_DIR_PLESK/cgi-bin || exit 17 )
done

### FTP users ###
for VAL in `echo "$FTP_VAL" | sed 's/,/ /g'`
do
    FTP_USER=`echo $VAL | awk -F"=" '{print $1}'`
    FTP_DIR=` echo $VAL | awk -F"=" '{print $2}'`
    mkdir -p web_users/$FTP_USER || exit 30
    cd web_users/$FTP_USER || exit 31
    ln -s ${USER_HOME}/html/$FTP_DIR ./ || exit 32
    cd -
    tar rfh ${USER_HOME}/${DOMAIN_NAME}.tar web_users/$FTP_USER/$FTP_DIR || exit 34
done

cd $USER_HOME || exit 21
[ -d $TMP_DIR ] && rm -rf $TMP_DIR
cd $ROOT_DIR || exit 22
[ -d $TMP_DIR ] && rm -rf $TMP_DIR

gzip ${USER_HOME}/${DOMAIN_NAME}.tar || exit 19
mv ${USER_HOME}/${DOMAIN_NAME}.tar.gz $OUTPUT/web_${DOMAIN_NAME}_vhost_${TIME_STAMP}.tar.gz || exit 20
echo `du -b $OUTPUT/web_${DOMAIN_NAME}_vhost_${TIME_STAMP}.tar.gz | awk '{print $1}'`
