<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output indent="yes" encoding="UTF-8"/>
  <xsl:variable name='agent_name' select='EnsimXdump/@agent-name'/>

  <xsl:template match='EnsimXdump'>
    <migration-dump agent-name="{$agent_name}">
      <xsl:for-each select="reseller">
        <xsl:call-template name="create-client"/>
      </xsl:for-each>
    </migration-dump>
  </xsl:template>

  <!-- Plesk does not allow to create users listed in xsl:when construction below, so we have to mangle it -->

  <xsl:template name="mangle-very-sys-user">
    <xsl:param name="username"/>
    <xsl:choose>
      <xsl:when test="$username = 'admin' or $username = 'ftp' or $username = 'anonymous' or $username = 'root' or $username = 'mailman' or $username = 'tomcat4'"><xsl:value-of select="concat($username, '1')"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="$username"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

	<xsl:template match="domain-ip">
		<ip>
			<xsl:choose>
				<xsl:when test="../hosting-type/@type='name-based'">
					<ip-type>shared</ip-type>
				</xsl:when>
				<xsl:otherwise>
					<ip-type>exclusive</ip-type>
				</xsl:otherwise>
			</xsl:choose>
			<ip-address>
				<xsl:value-of select='.'/>
			</ip-address>
		</ip>
	</xsl:template>

  <!--
  Key used for removal of duplicate IP addresses in reseller's pool:
	[IP address value][name of the reseller][indication of ip based hosting]
  -->
  <xsl:key name="ip" match="domain/domain-ip"
    use="concat(., ../../pinfo/@username, ../hosting-type/@type[.='ip-based'])"/>

  <xsl:template name="create-client">
    <client name="{pinfo/@username}" contact="{pinfo/@fullname}">

      <!-- password -->
      <xsl:copy-of select="password"/>

      <!-- status? -->
      <xsl:choose>
        <xsl:when test="disabled">
		  <status><disabled-by name="admin"/></status>
        </xsl:when>
        <xsl:otherwise>
		  <status><enabled/></status>
        </xsl:otherwise>
      </xsl:choose>

      <!-- pinfo* -->

      <!-- limit* -->
      <xsl:variable name="disk-quota" select="reseller-limit[@name = 'disk-quota']"/>
      <xsl:if test="$disk-quota">
        <limit name="disk_space"><xsl:value-of select="$disk-quota"/></limit>
      </xsl:if>

      <xsl:variable name="traffic-quota" select="reseller-limit[@name = 'traffic-quota']"/>
      <xsl:if test="$traffic-quota">
        <limit name="max_traffic"><xsl:value-of select="$traffic-quota"/></limit>
      </xsl:if>

      <xsl:variable name="max-users" select="reseller-limit[@name = 'max-users']"/>
      <xsl:if test="$max-users">
        <limit name="max_wu"><xsl:value-of select="$max-users"/></limit>
      </xsl:if>

      <xsl:variable name="ip-based-domains" select="reseller-limit[@name = 'ip-based-domains']"/>
      <xsl:variable name="name-based-domains" select="reseller-limit[@name = 'name-based-domains']"/>
      <xsl:if test="$ip-based-domains or $name-based-domains">
        <xsl:choose>
          <xsl:when test="$ip-based-domains = -1 or $name-based-domains = -1">
            <limit name="max_dom">-1</limit>
          </xsl:when>
          <xsl:otherwise>
            <limit name="max_dom"><xsl:value-of select="$ip-based-domains + $name-based-domains"/></limit>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>

      <!-- permission* -->

      <xsl:if test="reseller-permission[@name='create-ipbased'] or reseller-permission[@name='create-namebased']">
        <permission name="create_domains" allowed="true"/>
      </xsl:if>
      <xsl:if test="reseller-permission[@name='manage-dns-zone']">
        <permission name="manage_dns" allowed="true"/>
      </xsl:if>

      <!-- FIXME: create-users -->

			<ip_pool>
			  <!-- without duplicates -->
			  <xsl:apply-templates select="domain/domain-ip[generate-id(.) = generate-id(key('ip',
			    concat(., ../../pinfo/@username, ../hosting-type/@type[.='ip-based'])))]"/>
			</ip_pool>

      <!-- domain* -->

      <xsl:for-each select="domain">
        <xsl:call-template name="create-domain"/>
      </xsl:for-each>
    </client>
  </xsl:template>

  <xsl:template name="create-domain">
    <domain name="{@name}" www="true">

      <!-- domain_ip -->
      <xsl:apply-templates select="domain-ip"/>

      <!-- status -->
      <xsl:choose>
        <xsl:when test="disabled">
		  <status><disabled-by name="admin"/></status>
        </xsl:when>
        <xsl:otherwise>
		  <status><enabled/></status>
        </xsl:otherwise>
      </xsl:choose>

      <!-- limit* -->
      <xsl:variable name="max-subdomain" select="domain-limit[@name = 'max-subdomain']"/>
      <xsl:if test="$max-subdomain">
        <limit name="max_subdom"><xsl:value-of select="$max-subdomain"/></limit>
      </xsl:if>

      <xsl:variable name="users" select="domain-limit[@name = 'users']"/>
      <xsl:if test="$users">
        <limit name="max_wu"><xsl:value-of select="$users"/></limit>
      </xsl:if>

      <xsl:variable name="disk-quota" select="domain-limit[@name = 'disk-quota']"/>
      <xsl:if test="$disk-quota">
        <limit name="disk_space"><xsl:value-of select="$disk-quota"/></limit>
      </xsl:if>

      <xsl:variable name="traffic-quota" select="domain-limit[@name = 'traffic-quota']"/>
      <xsl:if test="$traffic-quota">
        <limit name="max_traffic"><xsl:value-of select="$traffic-quota"/></limit>
      </xsl:if>

      <xsl:variable name="max-databases" select="domain-limit[@name = 'max-databases']"/>
      <xsl:if test="$max-databases">
        <limit name="max_db"><xsl:value-of select="$max-databases"/></limit>
      </xsl:if>

      <!-- permission* -->
      <!-- FIXME: E-COMMERCE and DEVTOOL are currently IGNORED! -->

      <!-- FIXME: IS FILE MANAGER ALWAYS ACCESSIBLE??? -->
      <xsl:if test="domain-permission[@name='file-manager']">
      </xsl:if>

      <!-- backup moved to domuser -->
      <!-- telnet/ssh moved to phosting -->

      <!-- mailsystem? -->
		<xsl:if test="email">
			<mailsystem>
			<!--xsl:variable name="rejectlist">
				<xsl:apply-templates select="email/reject-list/reject"/>
			</xsl:variable!-->
			<status><enabled/></status>
			<xsl:for-each select="email/mailuser">
				<xsl:variable name="username" select="@name"/>
				<mailuser name="{@name}" mailgroup-enabled="{@mailgroup-enabled}">
					<xsl:variable name="domuser" select="../../domain-user[pinfo/@username=$username]"/>
					<xsl:if test="$domuser/domain-user-limit[@name='disk-quota']">
						<xsl:attribute name="mailbox-quota">
							<xsl:value-of select="$domuser/domain-user-limit[@name='disk-quota']"/>
						</xsl:attribute>
					</xsl:if>				    
				    <xsl:copy-of select="password"/>
          <xsl:if test='../email-permission/@name="spam_filter"'>
             	<mailuser-permission name="manage-spamfilter">true</mailuser-permission>
          </xsl:if>
					<xsl:copy-of select="mailbox"/>
					<xsl:copy-of select="alias[text() != 'catch-all']"/>
					<xsl:copy-of select="mailgroup-member"/>
					<xsl:if test="redirect">
						<xsl:element name="redirect">
							<xsl:attribute name="enabled">true</xsl:attribute>
							<xsl:value-of select="redirect"/>
						</xsl:element>
					</xsl:if>
					<xsl:if test="spamassassin">
						<xsl:element name="spamassassin">
							<xsl:if test="spamassassin[@hits]">
								<xsl:attribute name="hits"><xsl:value-of select="spamassassin/@hits"/></xsl:attribute>
							</xsl:if>
							<xsl:if test="spamassassin[@status]">							
								<xsl:attribute name="status"><xsl:value-of select="spamassassin/@status"/></xsl:attribute>
							</xsl:if>								
							<xsl:if test="spamassassin[@action]">														
								<xsl:attribute name="action"><xsl:value-of select="spamassassin/@action"/></xsl:attribute>
							</xsl:if>					
							<xsl:if test="spamassassin[@subj-text]">			
								<xsl:attribute name="subj-text"><xsl:value-of select="spamassassin/@subj-text"/></xsl:attribute>
							</xsl:if>					
							<!--xsl:copy-of select="$rejectlist" /!-->
							<xsl:copy-of select="spamassassin/blacklist-member" />
							<xsl:copy-of select="spamassassin/whitelist-member" />
							<xsl:copy-of select="spamassassin/unblacklist-member" />
							<xsl:copy-of select="spamassassin/unwhitelist-member" />							
						</xsl:element>
					</xsl:if>
					<xsl:if test='(../../mailscanner/@status="on") and ((../../mailscanner/@scan_incoming="true") or (../../mailscanner/@scan_outgoing="true"))'>
						<xsl:element name="virusfilter">
							<xsl:choose>
								<xsl:when test='(../../mailscanner/@scan_incoming="true") and (../../mailscanner/@scan_outgoing="true")'>
									<xsl:attribute name="state">inout</xsl:attribute>		
								</xsl:when>
								<xsl:otherwise>
									<xsl:choose>
										<xsl:when test='../../mailscanner/@scan_incoming="true"'>
											<xsl:attribute name="state">in</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="state">out</xsl:attribute>
										</xsl:otherwise>	
									</xsl:choose>
								</xsl:otherwise>	
							</xsl:choose>
						</xsl:element>
					</xsl:if>
				</mailuser>
			</xsl:for-each>

			<xsl:if test="email/mailuser/alias = 'catch-all'">
				<catch-all><xsl:value-of select="email/mailuser[alias = 'catch-all']/@name"/>@<xsl:value-of select="@name"/></catch-all>
			</xsl:if>
			</mailsystem>
		</xsl:if>

      <!-- dns-zone? -->
	  <xsl:if test="dns-zone">
	    <xsl:element name="dns-zone">
		   <xsl:attribute name="email"><xsl:value-of select="dns-zone/@email"/></xsl:attribute>
		   <xsl:attribute name="type"><xsl:value-of select="dns-zone/@type"/></xsl:attribute>
		   <xsl:copy-of select="dns-zone/status"/>
		   <xsl:for-each select="dns-zone/dnsrec">
				<xsl:copy><xsl:copy-of select="@*"/></xsl:copy>
		   </xsl:for-each>
		  <xsl:if test="email/email-permission/@name='webmail'">
				<xsl:element name="dnsrec">
					<xsl:attribute name="src"><xsl:text>webmail.</xsl:text><xsl:value-of select="@name"/><xsl:text>.</xsl:text></xsl:attribute>
					<xsl:attribute name="type"><xsl:text>A</xsl:text></xsl:attribute>
					<xsl:attribute name="dst"><xsl:value-of select="domain-ip"/></xsl:attribute>
    			</xsl:element>
		  </xsl:if>
	    </xsl:element>
      </xsl:if>

	  <xsl:copy-of select="domain-alias"/>
	  <xsl:copy-of select="database"/>

	  <!-- maillists? -->
	  <xsl:if test="maillist">
		<maillists>
		  <status><enabled/></status>
		  <xsl:copy-of select="maillist"/>
		</maillists>
	  </xsl:if>

      <!-- traffic? --> <!-- FIXME: work with it -->

      <!-- certificate* --> <!-- FIXME: no certificates migration -->
      <xsl:copy-of select="certificate"/>

      <!-- domainuser -->
      <domainuser contact="{domain-admin/pinfo/@username}" status="true">
        <xsl:copy-of select="domain-admin/password"/>
        <xsl:if test="domain-admin/pinfo/@e-mail">
          <pinfo name="email"><xsl:value-of select="domain-admin/pinfo/@e-mail"/></pinfo>
        </xsl:if>  
        <xsl:if test="domain-permission[@name='create-subdomains']">
          <permission name="manage_subdomains" allowed="true"/>
        </xsl:if>
        <xsl:if test="domain-permission[@name='majordomo']">
          <permission name="manage_maillists" allowed="true"/>
        </xsl:if>
        <xsl:if test="domain-permission[@name='bind']">
          <permission name="manage_dns" allowed="true"/>
        </xsl:if>
        <xsl:if test="domain-permission[@name='backup-utils']">
          <permission name="make_dumps" allowed="true"/>
          <permission name="allow_local_backups" allowed="true"/>
          <permission name="allow_ftp_backups" allowed="true"/>
        </xsl:if>
        <xsl:if test="email/email-permission[@name='spam_filter']">
          <permission name="manage_spamfilter" allowed="true"/>
        </xsl:if>

      </domainuser>

      <!-- (shosting|fhosting|phosting)? --> <!-- FIXME: make it works -->

      <phosting>

        <xsl:if test="web/web-permission[@name='frontpage']">
          <xsl:attribute name="fp">true</xsl:attribute>
        </xsl:if>

        <xsl:if test="monitoring/monitoring-permission[@name='analog' or @name='webalizer']">
          <xsl:attribute name="webstat">true</xsl:attribute>
        </xsl:if>

        <xsl:copy-of select="@cid_docroot"/>
        <xsl:copy-of select="@cid_cgi"/>
        <xsl:copy-of select="@cid_webstat"/>
        <xsl:copy-of select="@cid_ftpstat"/>
        <xsl:copy-of select="@cid_private"/>

		<xsl:if test="domain-permission[@name='ssl']">
		  <xsl:attribute name="https">true</xsl:attribute>
		</xsl:if>

		<xsl:if test="domain-permission[@name='ssl'] and domain-permision[@name='frontpage ']">
		  <xsl:attribute name="fpssl">true</xsl:attribute>
		</xsl:if>

        <xsl:variable name="domain" select="."/>

        <xsl:variable name="sysusername">
          <xsl:for-each select="//domain[domain-admin/pinfo/@username = $domain/domain-admin/pinfo/@username]">
            <xsl:if test="@name = $domain/@name">
              <xsl:variable name="admin-name" select="$domain/domain-admin/pinfo/@username"/>
              <xsl:choose>
                <xsl:when test="position() = 1">
                  <xsl:call-template name="mangle-very-sys-user">
                    <xsl:with-param name="username" select="$admin-name"/>
                  </xsl:call-template>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="concat($admin-name, position())"/></xsl:otherwise>
              </xsl:choose>
            </xsl:if>
          </xsl:for-each>
        </xsl:variable>

        <sysuser name='{$sysusername}'>
          <xsl:if test="domain-permission[@name='ssh' or @name='telnet']">
            <xsl:attribute name="shell"></xsl:attribute>
          </xsl:if>
          <xsl:copy-of select="domain-admin/password"/>
        </sysuser>

        <!-- scripting -->

		  <!-- php is unconditionally enabled on Ensim -->
        <scripting php="true">
          <xsl:if test="web/web-permission[@name='cgi']">
            <xsl:attribute name='cgi'>true</xsl:attribute>
          </xsl:if>
          <xsl:if test="web/web-permission[@name='mod_perl']">
            <xsl:attribute name='perl'>true</xsl:attribute>
          </xsl:if>
          <xsl:if test="web/web-permission[@name='ssi']">
            <xsl:attribute name='ssi'>true</xsl:attribute>
          </xsl:if>
          <xsl:if test="domain-permission[@name='e-commerce']">
            <xsl:attribute name='miva'>true</xsl:attribute>
          </xsl:if>
        </scripting>

        <!-- fpuser -->

        <xsl:if test="web/web-permission[@name='frontpage']">
          <fpuser name="{$sysusername}">
            <xsl:copy-of select="domain-admin/password"/>
          </fpuser>
        </xsl:if>

        <!-- logrotation -->
        <xsl:copy-of select="logrotation"/>

        <!-- anonftp -->

        <xsl:if test="ftp/ftp-permission[@name='anon-ftp']">
          <anonftp pub="true" incoming="true" display-login="false">
            <xsl:copy-of select="ftp/@cid"/>
            <xsl:copy-of select="ftp/@cid_incoming"/>

            <xsl:if test="domain-limit[@name = 'disk-quota']">
              <anonftp-limit name="incoming-disk-quota"><xsl:value-of select="domain-limit[@name='disk-quota']/text()"/></anonftp-limit>
            </xsl:if>

            <anonftp-permission name="incoming-mkdir"/>
            <anonftp-permission name="incoming-download"/>
          </anonftp>
        </xsl:if>

        <!-- pdir -->
        <xsl:apply-templates select="pdir"/>

        <!-- webuser -->
        <xsl:for-each select="domain-user[@cid]">
          <xsl:variable name="user" select="."/>
          <xsl:variable name="quota" select="$user/domain-user-limit[@name = 'disk-quota']"/>
          <xsl:variable name="username" select="pinfo/@username"/>
          <xsl:for-each select="//domain[domain-user/pinfo/@username = $username]">
            <xsl:if test="@name = $domain/@name">
              <webuser>
                <xsl:copy-of select="$user/@cid"/>

                <sysuser>
				  <xsl:attribute name="name">
					<xsl:call-template name="mangle-very-sys-user">
					  <xsl:with-param name="username">
						<xsl:choose>
						  <xsl:when test="position() = 1">
							<xsl:value-of select="$username"/>
						  </xsl:when>
						  <xsl:otherwise>
							<xsl:value-of select="concat($username, position())"/>
						  </xsl:otherwise>
						</xsl:choose>
					  </xsl:with-param>
					</xsl:call-template>
				  </xsl:attribute>
				  <xsl:if test="$quota">
					<xsl:attribute name="quota">
					   <xsl:value-of select="$quota"/>
					</xsl:attribute>
				</xsl:if>
                  <xsl:copy-of select="$user/password"/>
                </sysuser>

                <scripting ssi="false" php="true" perl="false" asp="false" python="false" coldfusion="false">
                  <xsl:choose>
                    <xsl:when test="$user/domain-user-permission[@name='cgi']">
                      <xsl:attribute name="cgi">true</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:attribute name="cgi">false</xsl:attribute>
                    </xsl:otherwise>
                  </xsl:choose>
                </scripting>
              </webuser>
            </xsl:if>
          </xsl:for-each>
        </xsl:for-each>

        <!-- subdomain -->

        <xsl:for-each select="subdomain">
          <subdomain name="{@name}">
            <xsl:copy-of select="@cid_docroot"/>
            <xsl:copy-of select="@cid_cgi"/>
            <scripting ssi="false" php="true" perl="false" asp="false" python="false" coldfusion="false">
				<xsl:if test="../domain-permission[@name='e-commerce']">
					<xsl:attribute name="miva">true</xsl:attribute>
				</xsl:if>
              <xsl:choose>
                <xsl:when test="subdomain-permission/@name = 'cgi'">
                  <xsl:attribute name="cgi">true</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:attribute name="cgi">false</xsl:attribute>
                </xsl:otherwise>
              </xsl:choose>
            </scripting>
          </subdomain>
        </xsl:for-each>
      </phosting>

    </domain>
  </xsl:template>

  <xsl:template match="pdir">
		<xsl:element name="pdir">
			<xsl:choose>
				<xsl:when test="substring(@name, 1,9)='/cgi-bin/'">
					<xsl:attribute name="nonssl"><xsl:text>false</xsl:text></xsl:attribute>
					<xsl:attribute name="cgi"><xsl:text>true</xsl:text></xsl:attribute>
					<xsl:attribute name="name"><xsl:text>/</xsl:text></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="nonssl"><xsl:text>true</xsl:text></xsl:attribute>
					<xsl:attribute name="cgi"><xsl:text>false</xsl:text></xsl:attribute>
					<xsl:choose>
						<xsl:when test="substring-after(@name, '/html/')=''">
							<xsl:attribute name="name"><xsl:text>/</xsl:text></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="name"><xsl:value-of select="substring-after(@name, '/html/')"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>	
				</xsl:otherwise>
			</xsl:choose>
			<xsl:attribute name="ssl"><xsl:text>false</xsl:text></xsl:attribute>
			<xsl:attribute name="title"><xsl:value-of select="@title"/></xsl:attribute>
			<xsl:copy-of select="pduser"/>
		</xsl:element>
  </xsl:template>

  <!--xsl:template match="reject-list/reject">
	  <xsl:element name="blacklist-member">
		  <xsl:apply-templates/>
	  </xsl:element>
  </xsl:template!-->
  
</xsl:stylesheet>