package DatabaseContentDumper;

use strict;
use warnings;

use Logging;
use ContentTransport::Rsync;
use ContentTransport::Archive;
use File::Basename;
use File::Path;
use Storage::ContentNameCreator;
use XmlNode;

# TODO copied as-is from PPCPL migration agent
sub getDatabaseContent {
  my ($base, $dbAdminLogin, $dbAdminPassword, $dbName, $dbType, $domainName) = @_;

  my $contentFileName = $base->{namecreator}->getDbDstFile('sqldump', $domainName, $dbName);
  my $sqldumpNode = $base->{archive_transport}->addDbContent($contentFileName, (
    'type' => $dbType,
    'name' => $dbName,
    'user' => $dbAdminLogin,
    'password' => $dbAdminPassword));
  if (ref($sqldumpNode) eq 'XmlNode') {
    return XmlNode->new('content', 'children' => [$sqldumpNode]);
  }

  Logging::warning("No database content found for '$dbName'.");
  return;
}

1;
