package CustomLogging;

# This package contains log file creation functions

use strict;
use warnings;

use Logging;

#
# hash of opened file descriptors
# $contentList{'filename'} => descriptor
#
my %contentList;

sub addToLog {
  my ($fileName, $str) = @_;
  my $filehandle;

  unless (defined($filehandle = $contentList{$fileName})) {
    unless (open($filehandle, "> $fileName")) {
      Logging::warning("Failed to open file '$fileName' for writing");
      return;
    }
    $contentList{$fileName} = $filehandle;
  }

  print $filehandle $str;
}

sub closeLogs {
  foreach my $filehandle (values %contentList) {
    close($filehandle);
  }
}

sub getLogsList {
  return keys %contentList;
}

sub closeAndGetLogsList {
  closeLogs();
  return getLogsList();
}

1;
