use strict;
use warnings;

package HashUtils;

# @param @hashes array of hash references
# @return reference to a hash, that has all the keys and values from source hashes;
#   for every duplicate key the value from the last hash with this key is used
sub mergeHashes {
  my (@hashes) = @_;
  my %result;

  foreach my $hash (@hashes) {
    @result{keys %$hash} = values %$hash;
  }

  return \%result;
}

# @param $hash - reference to a hash to slice
# @param @keys - array of strings 
# @return reference to a hash that has key - value pairs from source hash
#   only for keys is in @keys array
sub hashSlice {
  my ($hash, @keys) = @_;
  my %result;
  foreach my $key (@keys) {
    $result{$key} = $hash->{$key};
  }
  return \%result;
}

# @param $valuesHash - reference to a hash with values
# @param $mapHash - reference to a map hash
# @return reference to a hash - values hash with keys replaced according to map
#
# Example: 
#   $valuesHash = {'a' => 1, 'b' => 2}
#   $mapHash = {'a' => 'c', 'b' => 'd'}
#   $result = {'c' => 1, 'd' => 2}
sub replaceKeys {
  my ($valuesHash, $mapHash) = @_;
  my %result = map { $mapHash->{$_} => $valuesHash->{$_} } keys %$valuesHash;
  return \%result;
}

1;
