package PreMigrationChecks;

use strict;
use warnings;

use Dumper;
use PreMigration;

# put here all checks that could be performed independently from agent
sub checkOverall {
  unless (-e "/usr/bin/getapplversion") {
    print "Can't locate the PPCPL on this host.\n";
    exit (1);
  }
  # TODO put the service plan error to each reseller's node
  PreMigration::message('SERVICE_PLANS_NOT_MIGRATED', {});
  PreMigration::message('SERVER_SSL_CERTIFICATE_NOT_MIGRATED', {});
  my @duplicatedLogins = Dumper::getDuplicatedLogins();
  PreMigration::assert(scalar(@duplicatedLogins) > 0, 'DUPLICATED_SITE_LOGIN_NAMES',
      {'duplicateList' => PreMigration::formatList(@duplicatedLogins)}
  );
}

sub checkClient {
  my ($domain) = @_;

  my %context = ('client' => $domain, 'domain' => $domain, 'user' => Dumper::getSiteIdByDomain($domain));

  PreMigration::assert(scalar(Dumper::getDatabaseNames($domain)) > 1, 'MULTIPLE_DATABASES', {%context});
  my @statsEngines = Dumper::getEnabledWebstats($domain);

  my $hasAnalogEnabled          = scalar(grep { $_ eq 'analog' } @statsEngines) > 0;
  my @statsEnginesWithoutAnalog = grep { $_ ne 'analog' } @statsEngines;
  PreMigration::assert(scalar(@statsEnginesWithoutAnalog) > 0, 'WEBSTATS_DATA_NOT_MIGRATED', {%context, 'enabledEngines' => join (', ', @statsEnginesWithoutAnalog)});
  PreMigration::assert(scalar(@statsEnginesWithoutAnalog) > 1, 'MULTIPLE_WEBSTATS_ENABLED',
      {%context, 'enabledEngines' => join (', ', @statsEnginesWithoutAnalog)}
  );
  PreMigration::assert($hasAnalogEnabled, 'ANALOG_WEBSTATS_NOT_MIGRATED', {%context});

  PreMigration::assert(scalar(@{Dumper::getClientCronJobs($domain)}) > 0, 'CRON_JOBS', {%context});
  PreMigration::assert(scalar(Dumper::getDomainAliases($domain)) > 0, 'DOMAIN_ALIASES_NOT_MIGRATED', {%context});
  PreMigration::assert(scalar(Dumper::getMailResponders($domain)) > 0, 'MAIL_RESPONDERS_NOT_MIGRATED', {%context});
  PreMigration::assert(scalar(Dumper::getPowerToolsAvailability($domain)) > 0, 'POWER_TOOLS_AVAILABLE', {%context});
  PreMigration::assert(scalar(keys %{Dumper::getMaillists($domain)}) > 0, 'MAILING_LISTS', {%context});
}
1;
