package PreMigrationMessages;

use strict;
use warnings;

use PreMigration;

# Context variables common to all messages
our %COMMON_CONTEXT = (
    'panelName' => 'PPCPL',
  );

our %MESSAGES = (
  'ENABLED_SITE_HAS_NO_IPINFO' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::CP,
    'briefMessage' => 'An inconsistency was found: the site {domain} is enabled, but information about its IP address is missing.',
    'detailedMessage' => '{panelName} internal error occurred.'
  },
  'CANNOT_GENERATE_FTPUSER_NAME' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::CP,
    'briefMessage' => 'Unable to generate an FTP username for the subdomain {domain} belonging to the user {owner}.',
    'detailedMessage' => 'The migration agent failed to generate a unique FTP username. In Parallels Plesk Panel, FTP usernames are limited to {maxLength} characters. You can review all FTP usernames that are longer than {maxLength} characters, and manually rename them so that the first {maxLength} characters are unique.'
  },
 'ANONYMOUS_FTP_ON_SHARED_IP' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    'briefMessage' => 'Anonymous FTP account for the site {domain} cannot be migrated because this site uses a shared IP address.',
    'detailedMessage' => 'To enable anonymous FTP in Parallels Plesk Panel, assign a dedicated IP address to the domain. To disable anonymous FTP, simply leave the existing shared IP address.'
  },
 'ANONYMOUS_FTP_DIRECTORY_CONTENT' => {
    'severity' => PreMigration::INFO,
    'component' => PreMigration::WEB,
    'briefMessage' => "The contents of the anonymous FTP directory will be migrated to the anon_ftp directory.",
    'detailedMessage' => 'After migration, the user will be able to find the contents of the anonymous FTP directory in the anon_ftp directory.'
  }, 
  'MULTIPLE_WEBSTATS_ENABLED' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    'briefMessage' => "There are several web statistics analyzers enabled for the site {domain}: {enabledEngines}. Parallels Plesk Panel can use only one of them per a domain.",
    'detailedMessage' => "If several web statistics tools are enabled at once, after migration, Parallels Plesk Panel will enable the default one. You can select another one after migration."
  },
  'ANALOG_WEBSTATS_NOT_MIGRATED' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    'briefMessage' => "The Analog web statistics analyzer is enabled for the site '{domain}'. It is not supported by Parallels Plesk Panel.",
    'detailedMessage' => "After migration, a default web statistics analyzer will be enabled in Parallels Plesk Panel. You can later switch between AWStats and Webalizer in Panel settings."
  },
  'SERVICE_PLANS_NOT_MIGRATED' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::CP,
    'briefMessage' => "Service plans will not be migrated to Parallels Plesk Panel.",
    'detailedMessage' => "The model of service plans in Parallels Plesk Panel is different from that of PPCPL. After migration, review and set up service plans in Parallels Plesk Panel."
  },
  'SERVER_SSL_CERTIFICATE_NOT_MIGRATED' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::CP,
    'briefMessage' => "Server SSL certificate will not be migrated to Parallels Plesk Panel.",
    'detailedMessage' => "Transfer the server SSL certificate manually during migration."
  },
  'DOMAIN_ALIASES_NOT_MIGRATED' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    'briefMessage' => "Domain aliases for the domain {domain} will not be migrated to Parallels Plesk Panel.",
    'detailedMessage' => ""
  },
  'MAIL_RESPONDERS_NOT_MIGRATED' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::MAIL,
    'briefMessage' => "Mail autoresponders for the domain {domain} will not be migrated to Parallels Plesk Panel.",
    'detailedMessage' => ""
  },
  'DUPLICATED_SITE_LOGIN_NAMES' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::CP,
    'briefMessage' => "Duplicate site administrator usernames were found on the {panelName} installation.",
    'detailedMessage' => "Parallels Plesk Panel does not allow duplicate usernames. Duplicates will be automatically renamed during migration. The affected usernames are {duplicateList}."
  },
  'POWER_TOOLS_AVAILABLE' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    # TODO it may also be useful to find actual usage of power tools 
    # (complicated because there is a separate database table per application, i.e a table named 'xoops-2.0.16-1.0')
    'briefMessage' => "There are power tools available to the administrator of the site {domain}. The control panel settings of installed power tools will not be migrated.",
    'detailedMessage' => "The installed power tools can only be migrated as files. Application files and databases will be migrated, but the settings in control panel will not. The application settings and functionality should be verified after migration."
  },
  'MAILING_LISTS' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::MAIL,
    'briefMessage' => "There are mailing lists used by the administrator of the site {domain}. Message archives will not be migrated.",
    'detailedMessage' => "Only administrator's e-mail, password, and subscribers' e-mail addresses are migrated."
  },
  'WEBSTATS_DATA_NOT_MIGRATED' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    'briefMessage' => "There is one or more log analysis tools enabled: {enabledEngines}. Settings and logs of log analysis tools will not be migrated.",
    'detailedMessage' => "Only HTML reports generated by these tools will be migrated along with other hosted content."
  },
  'CRON_JOBS' => {
    'severity' => PreMigration::WARNING,
    'component' => PreMigration::WEB,
    'briefMessage' => "Site '{domain}' has crontab entries. Cron jobs cannot be migrated.",
    'detailedMessage' => 'Migration of crontab entries is not supported by the current version of migration agent. You should move all crontab entries to Parallels Plesk Panel server manually.'
  },

);
