package ContentDumperBase;

use strict;
use warnings;

use ContentTransport::Archive;
use Storage::ContentNameCreator;

use vars qw|@ISA|;

sub new {
  my $self = {};
  bless( $self, shift );
  $self->_init(@_);
  return $self;
}

sub _init {
  my ($self, $storagepolicy) = @_;

  $self->{storage} = $storagepolicy;
  $self->{namecreator} = Storage::ContentNameCreator->new();
  
  $self->{content_transport_type} = 'archive';
  $self->{archive_transport} = ContentTransport::Archive->new( $self, $self->{storage} );
  # always use archive content transport for some cids (sql_dump, error_docs)
  $self->{content_transport} = $self->{archive_transport};
}

sub getContentTransportDescription {
  my ($self) = @_;

  return $self->{content_transport}->getContentTransportDescription();
}

1;
