# Copyright 1999-2014. Parallels IP Holdings GmbH. All Rights Reserved.
package DumperUtils;

# This package contains common Dumper functions

use strict;
use warnings;

use Logging;

sub readFile {
  my ($fileName) = @_;

  unless (-r $fileName) {
	return undef;
  }

  open(INPUT, "< $fileName");
  binmode INPUT;
  my $content = join('', <INPUT>);
  close(INPUT);

  return $content;
}

sub getFileLines {
  my ($fileName) = @_;

  my @lines;
  if (open(FILE, "< $fileName")) {
    while (<FILE>) {
      chomp; # strip line separator[s]
      push @lines, $_;
    }
    close(FILE);
  }

  return \@lines;
}

sub writeFile {
  my ($fileName, $content) = @_;

  if (open(OUTPUT, "> $fileName")) {
    print OUTPUT $content;
    close(OUTPUT);
  } else {
    Logging::warning("Failed to open file '$fileName' for writing");
  }
}

1;
