# Copyright 1999-2015. Parallels IP Holdings GmbH. All Rights Reserved.
package Packer;

use strict;

use XmlNode;
use HelpFuncs;

sub makeLimitNode {
  my ( $name, $value ) = @_;
  unless ( defined($value) && ( $value !~ '/^\s*$/' ) ) {
    $value = '-1';
  }
  my $item = XmlNode->new( 'limit' );
  $item->setAttribute( 'name', $name );
  $item->setText( $value );
  return $item;
}

sub makeIpNode {
  my ( $ip ) = @_;
  my $item = XmlNode->new( 'ip' );
  $item->setText( $ip );
  return $item;
}

sub makeProtectedDirNode {
  my ( $name, $title, $users) = @_;
  my $protectedDirNode = XmlNode->new('pdir');

  $protectedDirNode->setAttribute( 'name', $name );
  $protectedDirNode->setAttribute( 'title', $title );
  if ( ref($users) =~ /HASH/ ) {
    while ( ( my $userName, my $userData ) = each( %{$users} ) ) {
      my $userNode = XmlNode->new('pduser');
      $userNode->setAttribute( 'name', $userName );
      $userNode->setAttribute( 'password', $userData->{'password'} );
      $userNode->setAttribute( 'encoding', $userData->{'encoding'} ) if exists $userData->{'encoding'};
      $protectedDirNode->addChild($userNode);
    }
  }
  return $protectedDirNode;
}


sub makeFtpUserNode {
  my ( $account, $password, $directory, $shell, $quota) = @_;
  my $ftpuserNode = XmlNode->new('ftpuser');
  $ftpuserNode->setAttribute( 'name', $account );

  if ( $password && $password !~ /^\!/ ) {
    $ftpuserNode->setAttribute( 'password', $password );
  }
  if ( $directory ) {
    $ftpuserNode->setAttribute( 'directory', $directory );
  }
  if ( $shell ) {
    $ftpuserNode->setAttribute( 'shell', $shell );
  }
  if ( $quota ) {
    $ftpuserNode->setAttribute( 'quota', $quota );
  }
  return $ftpuserNode;
}

sub makePasswordNode {
  my ($password, $type) = @_;

  unless ( defined ( $password ) ) {
    Logging::warning("'undef' password passed to makePasswordNode. Set to empty");
    $password = '';
  }

  if ( $password eq '' ) {
    $type = 'plain';
  } 
  else {
    if ( $type ne 'plain' ) {
      $type = 'encrypted';
    }
  }
  my $passwordNode = XmlNode->new( 'password' );
  $passwordNode->setAttribute( 'type', $type ); 
  $passwordNode->setText( $password );
  return $passwordNode;
}

sub addSpamassassinLists {
  my ( $root, $cfgvalues, $listname ) = @_;
  return unless defined $cfgvalues;

  foreach my $item ( @{$cfgvalues} ) {
    if ($item) {
      my $list_name_node = XmlNode->new( $listname );
      $list_name_node->setText( $item );
      $root->addChild( $list_name_node );
    }
  }
  return $root;
}

sub addForwarders {
  my ( $mailNode, $ptrAliases ) = @_;

  foreach my $ptrRow ( @{$ptrAliases} ) {

    my $src = $ptrRow->[0];
    my $dst = $ptrRow->[1];

    next unless ( $src =~ /^([^@]+)@[^@]+$/ );
    $src = $1;

    $dst =~ s/^\s+//;
    $dst =~ s/\s+$//;

    foreach my $email ( split /,/, $dst ) {
      next unless ( $email =~ /[^@]+@[^@]+/ );
      next if ( $email =~ /^['"]?\|/ );    # autoresponder
      my $forwardNode = XmlNode->new('forward');
      $forwardNode->setAttribute( 'mailname', $src );
      $forwardNode->setAttribute( 'redirect', $email );
      $mailNode->addChild($forwardNode);
    }
  }
  return $mailNode;
}


1;