#!/usr/bin/eperl

use vars qw($dumpDir $ptrArgs $workDir $storage);
use strict;
use DB_File;

use AgentConfig;
use SpamAssassinCfg;

use XmlNode;
use Imapd2Md;

my $dbName='appldb';
#my $dbHost='localhost';
my $dbType='Pg';

#
# parse command line
#
my %arg_opts = ('--help|-h'=>'',
				'--get-status|-s'=>'',
				'--dump-accounts|-dc'=>'s',
				'--dump-domains|-dd'=>'s',
				'--dump-all|-da'=>'',
				'--get-content-list|-lc'=>'',
				'--no-content|-nc'=>'',
				'--no-compress|-nz'=>'',
				'--output|-o'=>'s',
				'--status-file|-sf'=>'s',
			   );

#
# global variables
#

my $kilobyte = 1024;
my $megabyte = $kilobyte*$kilobyte;

my $defaultDomainsAccount = "DefaultEnsimDomains";
my $defaultDomainsFullname = "Default Ensim Domains";

my $ensimVersion;

my $ignoredUsers_ = {'root' => '1',
					 'bin' => '1',
					 'daemon' => '1',
					 'adm' => '1',
					 'lp' => '1',
					 'sync' => '1',
					 'shutdown' => '1',
					 'halt' => '1',
					 'mail' => '1',
					 'uucp' => '1',
					 'operator' => '1',
					 'games' => '1',
					 'gopher' => '1',
					 'ftp' => '1',
					 'news' => '1',
					 'mysql' => '1',
					 'nobody' => '1',
					 'zope' => '1',
					 'majordomo' => '1',
					 'tomcat4' => '1',
					 'apache' => '1',
					 'ensimrootmail' => '1',
					 'sshd' => '1',
		                         'smmsp' => '1',
					};

my %ignoredUsers = %{$ignoredUsers_};



my $quotaHome = "/home/virtual";

my $quotaDev;
if (eval "require Quota;") {
  $quotaDev = Quota::getqcarg($quotaHome);
}

#
# end global variables
#


#@@INCLUDE FILE="agent.include.pl"@@
if (-f 'agent.include.pl') {
  require 'agent.include.pl';
} else {
  require '../agent.include.pl';
}
#@@/INCLUDE@@

$ptrArgs = &getArguments (\@ARGV,\%arg_opts);

my ($outPath,$dumpFile,$statusFile);

$workDir = AgentConfig::cwd();

$dumpFile = $workDir.'/dump.xml';
$statusFile = $workDir.'/dumping-status.xml';
$dumpDir = $workDir.'/pma';

my $objDumpStatus = &makeDumpStatus($ptrArgs->{'status-file'}||$statusFile);

my $rootName = 'EnsimXdump';
my $dtdName = 'EnsimX.dtd';

my $wrapDbh = getDbConnect($dbType, undef, undef, $dbName);

if (exists $ptrArgs->{'get-status'}) {
  printAgentStatus();
  exit 0;
}

unless (ref($wrapDbh)=~/HASH/ && ref($wrapDbh->{'EXECUTE'})=~/CODE/) {
  die "Unable to connect to Ensim DB. Giving up.";
}

#
# get MIME Base64 encoder
#
my $wrapBase64 = makeMIMEBase64();


if (exists ($ptrArgs->{'dump-all'}) ||
	exists ($ptrArgs->{'dump-accounts'}) ||
	exists ($ptrArgs->{'dump-domains'})) {

  my ($root,@accounts,@domains,$ptrAccounts,$ptrDomains, $value);
  initStorage();
  getDumpDir($dumpDir);

  if (exists $ptrArgs->{'no-compress'}) {
	setCompress(0);
  }

  &printToLog("Work dir: $workDir");
  &printToLog("Dump file: $dumpFile");
  &printToLog("Status file: ".$objDumpStatus->{'FILE'}->());


  if ($value = $ptrArgs->{'dump-accounts'}) {
	if ($value eq "-") {
	  $value = <STDIN>;
	  chomp $value;
	}
	@accounts = split(/\s*,\s*/,$value);
	$ptrAccounts = \@accounts;
  }

  if ($value = $ptrArgs->{'dump-domains'}) {
	if ($value eq "-") {
	  $value = <STDIN>;
	  chomp $value;
	}
	@domains = split(/\s*,\s*/,$value);
	$ptrDomains = \@domains;
  }
  #
  # generate a xml dump
  #

  $root = &getEnsimXDump($dumpDir, $ptrAccounts, $ptrDomains, $rootName);

  #
  # print dump to output
  #
  $storage->finish($root);
} elsif (exists $ptrArgs->{'get-content-list'}) {
  makeContentList();
} else {
  &printHelp();
}

exit 0;

#
# end main
#
#==============================================================
#
# subroutines
#

sub printAgentStatus {
  my $root = XmlNode->new('agent-status');

  my $rpm = AgentConfig::rpmBin();
  $ensimVersion = `$rpm -q webppliance-version`;

  unless ($ensimVersion =~ /^webppliance-version-([^-]+)-[^-]+$/ && defined AgentConfig::iconvBin()) {
    my $item;
	if (defined AgentConfig::iconvBin()) {
	  $item = XmlNode->new('wrong-platform', 'content' => '');
	} else {
	  $item = XmlNode->new('wrong-platform', 'content' => 'no iconv found on the source host');
	}

	$root->addChild($item);
  }

  $root->serialize(\*STDOUT);
}

sub getEnsimXDump {
  my ($dumpDir, $ptrAccounts, $ptrDomains, $rootName) = @_;
  $rootName = 'PleskXDump' unless $rootName;

  my $root = XmlNode->new($rootName, 'attributes'=>{'agent-name' => 'EnsimX'});

  if (ref($ptrDomains) =~ /ARRAY/ && (@{$ptrDomains} > 0)) {

	my $list = getSqlList(@{$ptrDomains});
	my $sql = "SELECT site_id FROM siteinfo WHERE domain in ($list)";

	$wrapDbh->{'EXECUTE'}->($sql);

	my $ptrRow;
	my %domainIds;
	while ($ptrRow = $wrapDbh->{'FETCHROW'}->()) {
	  $domainIds{(@{$ptrRow})[0]} = 1;
	}

	$wrapDbh->{'FINISH'}->();

	createSelectedDomains($root, \%domainIds);

  } elsif (ref($ptrAccounts) =~ /ARRAY/ && (@{$ptrAccounts} > 0)) {
	my %accountIds;

	my @accounts = @{$ptrAccounts};

	if (grep {$_ eq $defaultDomainsAccount} @accounts) {
	  $accountIds{0} = 1;
	}

	@accounts = grep {$_ ne $defaultDomainsAccount} @accounts;

	my $list = join(',', map {"'$_'"} @accounts);
	my $sql = "SELECT reseller_id FROM reseller_info WHERE username in ($list)";

	$wrapDbh->{'EXECUTE'}->($sql);

	my $ptrRow;
	while ($ptrRow = $wrapDbh->{'FETCHROW'}->()) {
	  $accountIds{(@{$ptrRow})[0]} = 1;
	}

	$wrapDbh->{'FINISH'}->();

	createSelectedAccounts($root, \%accountIds);

  } else {
	createAllAccounts($root);
  }

  return $root;
}

sub createAllAccounts {
  my ($parent) = @_;
  my %accounts;

  my $sql = "SELECT DISTINCT reseller_info.reseller_id, username " .
	"FROM reseller_info LEFT JOIN reseller " .
	  "ON reseller_info.reseller_id = reseller.reseller_id ".
		"WHERE (reseller_info.reseller_id <> 0) OR (site_id IS NOT NULL)";

  unless($wrapDbh->{'EXECUTE'}->($sql) == 0) {
    my $ptrRow;
    while ($ptrRow = $wrapDbh->{'FETCHROW'}->()) {
	  my @accountInfo = @$ptrRow;
	  $accounts{$accountInfo[0]} = 1;
    }

    $wrapDbh->{'FINISH'}->();
  } else {
    $accounts{0} = 1;
  }
  createSelectedAccounts($parent, \%accounts);
}

sub countDomainsForAccounts {
  my @accounts = @_;

  my $accountsList = getSqlList(@accounts);
  my $sql = "SELECT COUNT(site_id) FROM reseller WHERE reseller_id IN ($accountsList)";
  $wrapDbh->{'EXECUTE'}->($sql) or die "Unable to retrieve sites list from reseller table";
  my $domainsCount = $wrapDbh->{'FETCHROW'}->()->[0];
  $wrapDbh->{'FINISH'}->();

  return $domainsCount;
}

sub createSelectedAccounts {
  my ($parent, $accountsPtr) = @_;
  my %accounts = %{$accountsPtr};

  my $domainsCount = countDomainsForAccounts(keys %accounts);

  $objDumpStatus->{'COUNTS'}->(scalar(%accounts), $domainsCount);
  $objDumpStatus->{'PRINT'}->();

  my $account;
  foreach $account (keys %accounts) {
    createAccountNode($parent, $account);
  }
}

sub createSelectedDomains {
  my ($parent, $domainsPtr) = @_;
  my %domains = %{$domainsPtr};

  $objDumpStatus->{'COUNTS'}->(0, scalar(%domains));
  $objDumpStatus->{'PRINT'}->();

  my $account = XmlNode->new('reseller');
  createPasswordNode($account, '', 'plain');
  createPinfoNode($account, '', undef, undef);

  my $domain;
  foreach $domain (keys %domains) {
	createDomain($account, $domain);
  }

  $parent->{'ADDCHILD'}->($account);
}

sub createAccountNode {
  my ($parent, $accountId) = @_;

  &printToLog("Creating account $accountId");

  my $sql = "SELECT reseller_id, username, email, password, fullname, enabled,".
	"total_threshold, enabled_bandwidth, total_quota, enabled_diskquota,".
	  "total_ipbased, total_namebased, enabled_ipinfo_nb, enabled_ipinfo_ip,".
		"total_maxusers, enabled_users, ".
		"enabled_zone_mgmt ".
		  "FROM reseller_info ".
			"NATURAL LEFT JOIN reseller_bandwidth ".
			  "NATURAL LEFT JOIN reseller_diskquota ".
				"NATURAL LEFT JOIN reseller_users ".
				  "NATURAL LEFT JOIN reseller_ipinfo ".
				  "NATURAL LEFT JOIN reseller_bind ".
					"WHERE (reseller_id = '$accountId')";

  my ($ptrHash,%info);
  if($wrapDbh->{'EXECUTE'}->($sql)){
    $ptrHash = $wrapDbh->{'FETCHHASH'}->();
    %info = %$ptrHash if (ref($ptrHash)=~/HASH/);
  }
  $wrapDbh->{'FINISH'}->();

  $objDumpStatus->{'ACCOUNT'}->($info{'fullname'});
  $objDumpStatus->{'PRINT'}->();

  my $item = XmlNode->new('reseller');

  &createPasswordNode($item, $info{'password'}, 'encrypted');

  my $username = $info{'username'};
  my $fullname = $info{'fullname'};
  if ($username eq "") {
	$username = $defaultDomainsAccount;
	$fullname = $defaultDomainsFullname;
  }

  &createPinfoNode($item, $username, $fullname, $info{'email'});

  unless (exists $ptrArgs->{'no-content'}) {
	&createLimitNode($item, 'reseller', 'traffic-quota',
					 $info{'total_threshold'},
					 $info{'enabled_bandwidth'} == 0 || $info{'total_threshold'} == 0);

	&createLimitNode($item, 'reseller', 'disk-quota',
					 $info{'total_quota'},
					 $info{'enabled_diskquota'} == 0 || $info{'total_quota'} == 0);

	&createLimitNode($item, 'reseller', 'max-users',
					 $info{'total_maxusers'}, $info{'reseller_id'} eq "0");
	&createLimitNode($item, 'reseller', 'ip-based-domains',
					 $info{'total_ipbased'}, $info{'reseller_id'} eq "0");
	&createLimitNode($item, 'reseller', 'name-based-domains',
					 $info{'total_namebased'}, $info{'reseller_id'} eq "0");

	&createPermissionNode($item, 'reseller', 'create-users',
						  $info{'enabled_users'});
	&createPermissionNode($item, 'reseller', 'create-ipbased',
						  $info{'enabled_ipinfo_ip'});
	&createPermissionNode($item, 'reseller', 'create-namebased',
						  $info{'enabled_ipinfo_nb'});
	&createPermissionNode($item, 'reseller', 'manage-dns-zone',
						  $info{'enabled_zone_mgmt'});
						  
	if ($info{'enabled'} == 0) {
	  my $disabledNode = XmlNode->new('disabled');
	  $item->{'ADDCHILD'}->($disabledNode);
	}
  }

  createAllDomainsForAccount($item, $accountId);

  $parent->{'ADDCHILD'}->($item);
}

sub createAllDomainsForAccount {
  my ($parent, $accountId) = @_;

  my $sql = "SELECT site_id FROM reseller WHERE reseller_id = '$accountId'";

  $wrapDbh->{'EXECUTE'}->($sql);

  my $ptrRow;
  while ($ptrRow = $wrapDbh->{'FETCHROW'}->()) {
	my $domainId = (@$ptrRow)[0];

	createDomain($parent, $domainId);
  }
  $wrapDbh->{'FINISH'}->();
}

sub createDomain {
  my ($parent, $domainId) = @_;

  &printToLog("Creating domain $domainId");

  my $item = XmlNode->new('domain');
  $parent->{'ADDCHILD'}->($item);

  #
  # MAIN CONFIGURATION FILES
  #
  my %domainInfo       = %{readConfigFile($domainId, 'siteinfo')};
  my %ipinfo           = %{readConfigFile($domainId, 'ipinfo')};

  $item->setAttribute('name', $domainInfo{'domain'});

  $objDumpStatus->{'DOMAIN'}->($domainInfo{'domain'});
  $objDumpStatus->{'PRINT'}->();

  # NO MORE INFORMATION REQUIRED IN '--no-content' MODE
  if (exists $ptrArgs->{'no-content'}) {
    #We need to dump ip and hosting type for mapping
    my $htNode = XmlNode->new('hosting-type');
    my $domainIpNode;

    if ($ipinfo{'namebased'} eq '1') {
	  $htNode->setAttribute('type', 'name-based');
	  $ipinfo{'nbaddrs'} =~ /\[\'(.+)\'\]/;
	  $domainIpNode = XmlNode->new('domain-ip', 'content' => $1);
    } else {
	  $htNode->setAttribute('type', 'ip-based');
	  $ipinfo{'ipaddrs'} =~ /\[\'(.+)\'\]/;
	  $domainIpNode = XmlNode->new('domain-ip', 'content' => $1);
    }
    $item->addChild($htNode);
    $item->addChild($domainIpNode);
	return;
  }

  my $siteDisabled = makeSafeFileParser("/home/virtual/site" . $domainId . "/info/disabled");
  if (defined $siteDisabled) {
	  my $disabledNode = XmlNode->new('disabled');
	  $item->{'ADDCHILD'}->($disabledNode);
	}

  #
  # PARSE USERS INFO
  #
  my $passwdInfo = parsePasswdShadow($domainId);

  my $domadmNode = XmlNode->new('domain-admin');
  createPasswordNode($domadmNode,
					 $passwdInfo->{$domainInfo{'admin_user'}}->{'password'},
					 'encrypted');

  createPinfoNode($domadmNode, $domainInfo{'admin_user'},
				  undef, $domainInfo{'email'});
  $item->{'ADDCHILD'}->($domadmNode);

  #
  # HOSTING TYPE & IP
  #
  my $htNode = XmlNode->new('hosting-type');
  my $domainIpNode;
  my $domainIp;

  if ($ipinfo{'namebased'} eq '1') {
	$htNode->{'ATTRIBUTE'}->('type', 'name-based');
	$ipinfo{'nbaddrs'} =~ /\[\'(.+)\'\]/;
    $domainIp = $1;
	$domainIpNode = XmlNode->new('domain-ip', 'content' => $domainIp);
  } else {
	$htNode->{'ATTRIBUTE'}->('type', 'ip-based');
	$ipinfo{'ipaddrs'} =~ /\[\'(.+)\'\]/;
    $domainIp = $1;
	$domainIpNode = XmlNode->new('domain-ip', 'content' => $domainIp);
  }
  $item->{'ADDCHILD'}->($htNode);
  $item->{'ADDCHILD'}->($domainIpNode);

  #
  # ADDITIONAL CONFIGURATION FILES
  #
  my %aliasesInfo      = %{readConfigFile($domainId, 'aliases')};
  my %diskquotaInfo    = %{readConfigFile($domainId, 'diskquota')};
  my %bandwidthInfo    = %{readConfigFile($domainId, 'bandwidth')};
  my %analogInfo       = %{readConfigFile($domainId, 'analog')};
  my %webalizerInfo    = %{readConfigFile($domainId, 'webalizer')};
  my %usersInfo        = %{readConfigFile($domainId, 'users')};
  my %subdomainInfo    = %{readConfigFile($domainId, 'subdomain')};
  my %mivamerchantInfo = %{readConfigFile($domainId, 'mivamerchant')};
  my %mivamerchant5Info = %{readConfigFile($domainId, 'mivamerchant5')};
  my %filesInfo        = %{readConfigFile($domainId, 'files')};
  my %vhbackupInfo     = %{readConfigFile($domainId, 'vhbackup')};
  my %develenvInfo     = %{readConfigFile($domainId, 'develenv')};
  my %sshInfo          = %{readConfigFile($domainId, 'ssh')};
  my %telnetInfo       = %{readConfigFile($domainId, 'telnet')};
  my %sslInfo          = %{readConfigFile($domainId, 'openssl')};
  my %dbaseInfo        = %{readConfigFile($domainId, 'mysql')};
  my %mailscannerInfo  = %{readConfigFile($domainId, 'mailscanner')};
  my %majordomoInfo    = %{readConfigFile($domainId, 'majordomo')};
  my %bindInfo         = %{readConfigFile($domainId, 'bind')};

  #
  # CONTENT
  #
  my $domainName = $domainInfo{'domain'};

  my $docroot = getFstPath($domainId) . "/home/" .
	$domainInfo{'admin_user'} . "/mainwebsite_html";
  my $cgi = getFstPath($domainId) . "/home/" .
	$domainInfo{'admin_user'} . "/mainwebsite_cgi";

  if (-d $docroot) {
	my $filename = makeDumpFile("$dumpDir/$domainName\_docroot",
								$docroot);
	$item->{'ATTRIBUTE'}->('cid_docroot', $filename);
  }

  if (-d $cgi) {
	my $filename = makeDumpFile("$dumpDir/$domainName\_cgi",
								$cgi);
	$item->{'ATTRIBUTE'}->('cid_cgi', $filename);
  }

  my $oldwebstatroot = getFstPath($domainId) . "/var/www/webalizer/";
  my $webstatroot = getFstPath($domainId) . "/var/www/html/webalizer/web/";
  my $ftpstatroot = getFstPath($domainId) . "/var/www/html/webalizer/ftp/";
  my ($cid_webstat, $cid_ftpstat);

  if (-d $oldwebstatroot) {
    $cid_webstat = $storage->addTar("$dumpDir/$domainName\_webstat", "directory" => $oldwebstatroot);
    $item->setAttribute('cid_webstat', $cid_webstat) if $cid_webstat;
  }elsif (-d $webstatroot) {
    $cid_webstat = makeDumpFile("$dumpDir/$domainName\_webstat", $webstatroot);
    $item->setAttribute('cid_webstat', $cid_webstat) if $cid_webstat;
  }

  if (-d $ftpstatroot) {
    $cid_ftpstat = makeDumpFile("$dumpDir/$domainName\_ftpstat", $ftpstatroot);
    $item->setAttribute('cid_ftpstat', $cid_ftpstat) if $cid_ftpstat;
  }

  # feature request. Bug 106473
  my $mivaroot = getFstPath($domainId) . "/var/www/";

  if (-d $mivaroot."/mivadata") {
    my $cid_miva = makeDumpFile("$dumpDir/$domainName\_miva", $mivaroot, "mivadata");
    $item->setAttribute('cid_private', $cid_miva) if $cid_miva;
  }

  #
  # ALIASES
  #
  if ($aliasesInfo{'enabled'} == '1') {
	$aliasesInfo{'aliases'} =~ /\[(.+)\]/;
	my @aliases = map { /^\'(.*)\'$/; $1 } split /\s*,\s*/, $1;

	my $alias;
	foreach $alias (@aliases) {
	  printToLog($domainName);
	  printToLog($alias);
	  if ($alias =~ /^(.*)\.(.*)$/) {
		my $aliasNode = XmlNode->new('domain-alias');
                $aliasNode->{'ATTRIBUTE'}->('name',$alias);
                $aliasNode->{'ATTRIBUTE'}->('mail', ($1=~/mail/)? 'true' : 'false');
                $aliasNode->{'ATTRIBUTE'}->('web','true');
                my $statusNode = XmlNode->new('status');
                $statusNode->{'ADDCHILD'}->(XmlNode->new('enabled'));
                $aliasNode->{'ADDCHILD'}->($statusNode);
		$item->{'ADDCHILD'}->($aliasNode);
	  }
	}
  }

  #
  # MONITORING
  #
  my $monitoringNode = XmlNode->new('monitoring');
  $monitoringNode->{'ATTRIBUTE'}->('cycle-start', $bandwidthInfo{'rollover'});

  createPermissionNode($monitoringNode, 'monitoring',
					   'analog', $analogInfo{'enabled'});

  createPermissionNode($monitoringNode, 'monitoring',
					   'webalizer', $webalizerInfo{'enabled'});

  $item->{'ADDCHILD'}->($monitoringNode);

  #
  # DOMAIN LIMITS
  #

  createLimitNode($item, 'domain', 'disk-quota',
				  $diskquotaInfo{'quota'}*$megabyte,
				  $diskquotaInfo{'enabled'} == 0);

  createLimitNode($item, 'domain', 'traffic-quota',
				  $bandwidthInfo{'threshold'},
				  $bandwidthInfo{'enabled'} == 0);

  createLimitNode($item, 'domain', 'users',
				  $usersInfo{'maxusers'}, !defined($usersInfo{'maxusers'}));

  createLimitNode($item, 'domain', 'max-subdomain',
				  $subdomainInfo{'max'}, !defined($subdomainInfo{'max'}));

  createLimitNode($item, 'domain', 'max-databases', $dbaseInfo{'dbasenum'}, !defined($dbaseInfo{'dbasenum'}));

  #
  # DOMAIN PERMISSIONS
  #
  createPermissionNode($item, 'domain',
					   'create-subdomains', $subdomainInfo{'enabled'});

  if($mivamerchantInfo{'enabled'} or $mivamerchant5Info{'enabled'}){
    createPermissionNode($item, 'domain', 'e-commerce', 1);
  }

  createPermissionNode($item, 'domain',
					   'e-commerce', $mivamerchantInfo{'enabled'});

  createPermissionNode($item, 'domain',
					   'file-manager', $filesInfo{'enabled'});

  createPermissionNode($item, 'domain',
					   'backup-utils', $vhbackupInfo{'enabled'});

  createPermissionNode($item, 'domain',
					   'devtools', $develenvInfo{'enabled'});

  createPermissionNode($item, 'domain',
					   'ssh', $sshInfo{'enabled'});

  createPermissionNode($item, 'domain',
					   'telnet', $telnetInfo{'enabled'});

  createPermissionNode($item, 'domain',
					   'ssl', $sslInfo{'enabled'});
					   
  createPermissionNode($item, 'domain',
					   'bind', $bindInfo{'zone_mgmt'});

  createPermissionNode($item, 'domain',
					   'majordomo', $majordomoInfo{'enabled'});
					   

  #
  # DOMAIN USERS
  #
  my %mailusers = %{createDomainUsersNode($domainId, $item, $passwdInfo)};

  #
  # WEB
  #
  createWebNode($domainId, $item);

  #
  # SUBDOMAINS
  #
  my %subdomainsList = createSubdomains($domainId, $domainInfo{'domain'}, $item);

  #
  # MAILLISTS
  #
  my $aliasesToIgnore = createMaillists($domainId, $domainInfo{'domain'}, $item);

  #
  # EMAIL
  #
  createMailNode($domainId, $domainInfo{'domain'}, $item, \%mailusers, $aliasesToIgnore);

  #
  # LOGROTATION
  #
  createLogrotationNode($domainId, $item, $domainInfo{'email'});

  #
  # FTP
  #
  createFtpNode($domainId, $item);

  #
  # Protected Directories
  #
  createPdirNodes($domainId, $item);

  #
  # DB
  #
  createDbNode($domainId, $item);

  #
  # MailScanner
  #
  createMailScannerNode($domainId, $item, \%mailscannerInfo);

  #
  # CERTIFICATE
  #
  createSslNode($domainId, $item, \%sslInfo);

  #
  # DNS ZONE
  #
  my $webmailRecord = !defined $subdomainsList{'webmail'};

  createDnsZoneNode($domainId, $item, $webmailRecord, $domainInfo{'email'}, $domainName, $domainIp);
}


sub getUserQuota {
  my ($uid) = @_;

  unless (eval "require Quota;") {
    return undef;
  }

  my ($bc, $bs, $bh, $bt, $ic, $is, $ih, $it) = Quota::query($quotaDev, $uid, 0);

  if (defined $bs) {
	return $bs * 1024;
  }

  return undef;
}

sub parsePasswdShadow {
  my ($domainId) = @_;

  my $passwdReader = makeFileParser(getFstPath($domainId) . "/etc/passwd");
  my $shadowReader = makeSafeFileParser(getFstPath($domainId) . "/etc/shadow");

  my (%passwd, %shadow);

  if (defined($passwdReader)) {
	%passwd = %{$passwdReader->{'PARSE'}->('KEYSEPARATOR' => ':',
										   'VALUESEPARATOR' => ':')};
  } else {
	return undef;
  }

  if (defined($shadowReader)) {
	%shadow = %{$shadowReader->{'PARSE'}->('KEYSEPARATOR' => ':',
										   'VALUESEPARATOR' => ':')};
  }

  my %userParams;

  my ($username, $paramsPtr);
  while (($username, $paramsPtr) = each %passwd) {
	my @params = @{$paramsPtr};
	my $fullname = $params[3]; #see the 'passwd' format reference
	my $id = $params[1]; #see the 'passwd' format reference
	my $password;

	if (%shadow && defined($shadow{$username})) {
	  my @shadowParams = @{$shadow{$username}};
	  $password = $shadowParams[0]; #see the 'shadow' format reference
	}

	$userParams{$username} = { 'fullname' => $fullname, 'password' => $password, 'id' => $id };
  }

  return \%userParams;
}

sub createDomainUsersNode
{
	my ($domainId, $parent, $usersInfo) = @_;
	my %domainInfo  = %{readConfigFile($domainId, 'siteinfo')};
	my @pamlistlist = ('imap', 'proftpd', 'smtp_relay', 'ssh', 'telnet');

	my %pamlists;
	my $pamlist;

	foreach $pamlist (@pamlistlist) {
		$pamlists{$pamlist} = {};

		my $pamlistfile;
		open($pamlistfile, getFstPath($domainId) . "/etc/" . $pamlist . ".pamlist");
		if (defined($pamlistfile)) {
			binmode $pamlistfile;
			while (my $line = <$pamlistfile>) {
				chomp $line;
				$pamlists{$pamlist}{$line} = 1;
			}
			close($pamlistfile);
		}
	}


  my %cgiPermissions = %{retrieveCgiPermissions($domainId)};

  my %domusers;

  my $username;
  foreach $username (keys %{$usersInfo}) {
	if (defined($ignoredUsers{$username})) {# || $username eq $domainInfo{'admin_user'}) {
	  next;
	}

	my $domainName = $domainInfo{'domain'};
	my $password = $usersInfo->{$username}->{'password'};

	if ($username ne $domainInfo{'admin_user'}) {

	  my $fullname = $usersInfo->{$username}->{'fullname'};
	  my $domuser = XmlNode->new('domain-user');
	  my $contentRoot = getFstPath($domainId) . "/home/" . $username;

	  if (-d $contentRoot) {
		my $fileName = makeDumpFile("$dumpDir/$domainName\_$username",
									$contentRoot);
		if ($fileName) {
		  $domuser->{'ATTRIBUTE'}->('cid', $fileName);
		}
	  }

	  my $_username = $username;
	  $_username =~ s/\./_/g;

	  createPinfoNode($domuser, $_username, $fullname, undef);
	  if (defined($password)) {
		createPasswordNode($domuser, $password, 'encrypted');
	  }
          else{
          	createPasswordNode($domuser, '', 'plain');
                printToLog( "The password of domain '$domainName' user '$domuser' is unknown!" );
          }

	  #LIMITS
	  my $userQuota = getUserQuota($usersInfo->{$username}->{'id'});

	  createLimitNode($domuser, 'domain-user', 'disk-quota',
					  $userQuota,	!defined($userQuota) || $userQuota eq "0");

	  #PERMISSIONS
	  createPermissionNode($domuser, 'domain-user', 'ftp',
						   defined($pamlists{'proftpd'}{$username}));

	  createPermissionNode($domuser, 'domain-user', 'ssh',
						   defined($pamlists{'ssh'}{$username}));

	  createPermissionNode($domuser, 'domain-user', 'telnet',
						   defined($pamlists{'telnet'}{$username}));

	  createPermissionNode($domuser, 'domain-user', 'cgi',
						   defined($cgiPermissions{$username}));

	  $parent->{'ADDCHILD'}->($domuser);
	}

	my $mailbox = getFstPath($domainId) . "/var/spool/mail/" . $username;
	my $inboxFileName;
	if (-f $mailbox) {
	  printToLog("Packing $username\@$domainName INBOX");
	  $inboxFileName = makeDumpFile("$dumpDir/$username\@$domainName\_mbox",
							   getFstPath($domainId) . "/var/spool/mail",
							   $username, undef, undef, "-h");
	}

	my @mail;

	my $mailhome = getFstPath($domainId) . "/home/$username";
	my $mailboxlist = "$mailhome/.mailboxlist";
	if (-f $mailboxlist) {
	  open MAILBOXLIST, "<$mailboxlist";
	  binmode MAILBOXLIST;
	  while (<MAILBOXLIST>) {
		chomp;
		if (-f "$mailhome/$_") {
		  push @mail, $_;
		}
	  }
	}
        my $fileName;
	if (@mail) {
          my $idname = $dumpDir . "/$username" . "@" . "$domainName.mdir";
          my $srcdir = $idname . ".converted";
          mkdir $srcdir or die "Cannot create folder to convert mail messages!";
          my $mailfolder;
          foreach $mailfolder(@mail) {
               printToLog( "Convert $username\@$domainName mail folder '$mailfolder'" );
               my $destPath = $mailfolder;
               $destPath =~ s/^mail//g;
               $destPath =~ s/^\///g;
               $destPath =~ s/\./_/g;
               $destPath =~ s/\//\./g;
               $destPath = ".$destPath";
               my $ret = &Imapd2Md::convertit( "$mailhome/$mailfolder", "$srcdir/$destPath" );
               if( $ret ){ printToLog("Error while convertion mailbox '$mailfolder': $ret "); }
               else{ system( "touch", "$srcdir/$destPath/maildirfolder" ) if -e "$srcdir/$destPath"; }
          }
	  $fileName = makeDumpFile( $idname, $srcdir );
	}

        $domusers{$username} = { 'password' => $password, 'cid' => $fileName, 'type' => 'mdir', 'cid_inbox' => $inboxFileName };

  }

  return \%domusers;
}

sub retrieveCgiPermissions {
  my ($domainId, $username) = @_;

  my %cgiAllowed = ();
  my (%db, $user);

  tie %db, "DB_File", "/etc/virtualhosting/cgi/site" . $domainId . ".cgi_owner_map",
	O_RDONLY, 0666, $DB_HASH;

  foreach $user (values %db) {
	$cgiAllowed{$user} = "1";
  }

  untie %db;

  return \%cgiAllowed;
}

sub createWebNode {
  my ($domainId, $parent) = @_;

  #
  # CONFIGURATION FILES
  #
  my %apacheInfo       = %{readConfigFile($domainId, 'apache')};
  my %cgiInfo          = %{readConfigFile($domainId, 'cgi')};
  my %mod_perlInfo     = %{readConfigFile($domainId, 'mod_perl')};
  my %ssiInfo          = %{readConfigFile($domainId, 'ssi')};
  my %weblogsInfo      = %{readConfigFile($domainId, 'weblogs')};
  my %tomcat4Info      = %{readConfigFile($domainId, 'tomcat4')};
  my %frontpageInfo    = %{readConfigFile($domainId, 'frontpage')};


  my $item = XmlNode->new('web');
  $item->{'ATTRIBUTE'}->('web-server-name', $apacheInfo{'webserver'});
  $item->{'ATTRIBUTE'}->('cgi-content-root', $cgiInfo{'scriptalias'});
  $item->{'ATTRIBUTE'}->('perl-content-root', $mod_perlInfo{'alias'});

  #
  # PERMISSIONS
  #
  createPermissionNode($item, 'web', 'web', $apacheInfo{'enabled'});
  createPermissionNode($item, 'web', 'cgi', $cgiInfo{'enabled'});
  createPermissionNode($item, 'web', 'ssi', $ssiInfo{'enabled'});
  createPermissionNode($item, 'web', 'mod_perl', $mod_perlInfo{'enabled'});
  createPermissionNode($item, 'web', 'weblogs', $weblogsInfo{'enabled'});
  createPermissionNode($item, 'web', 'tomcat', $tomcat4Info{'enabled'});
  createPermissionNode($item, 'web', 'frontpage', $frontpageInfo{'enabled'});

  #
  # WEBUSERS
  #
  createWebUsersNode($domainId, $item);

  $parent->{'ADDCHILD'}->($item);
}

sub createWebUsersNode {
  my ($domainId, $parent) = @_;

}

sub createSubdomains {
  my ($domainId, $domain, $parent) = @_;

  my ($subdomainsfile, %subdomains);
  open($subdomainsfile, "/etc/virtualhosting/subdomain/site" . $domainId . ".map");
  binmode $subdomainsfile;
  while (<$subdomainsfile>) {
	unless(/^www/) {
	  my @info = split;
	  my @domparts = split /\./, $info[0];
	  $subdomains{$domparts[0]} = $info[1];
	}
  }

  my ($subdomainscgifile, %subdomainscgi);
  open($subdomainscgifile, "/etc/virtualhosting/subdomain/site" . $domainId . ".cgisubmap");
  binmode $subdomainscgifile;
  while (<$subdomainscgifile>) {
	unless(/^www/) {
	  my @info = split ":";
	  $subdomainscgi{$info[0]} = 1;
	}
  }

  my ($subdomain, $location);
  while (($subdomain, $location) = each %subdomains) {

	my $node = XmlNode->new('subdomain');
	$node->{'ATTRIBUTE'}->('name', $subdomain);

	if (-d $location . "/html") {
	  my $htmlcontent = makeDumpFile("$dumpDir/$subdomain.${domain}_htdocs",
									 $location . "/html", ('.'), (), '-h');

	  if (defined $htmlcontent) {
		$node->{'ATTRIBUTE'}->('cid_docroot', $htmlcontent);
	  }
	}

	if (-d $location . "/cgi-bin") {
	  my $cgicontent = makeDumpFile("$dumpDir/$subdomain.${domain}_cgibin",
									$location . "/cgi-bin", ('.'), (), '-h');

	  if (defined $cgicontent) {
		$node->{'ATTRIBUTE'}->('cid_cgi', $cgicontent);
	  }
	}

	if (defined $subdomainscgi{$subdomain.".".$domain}) {
	  my $sdpn = XmlNode->new('subdomain-permission');
	  $sdpn->{'ATTRIBUTE'}->('name', 'cgi');
	  $node->{'ADDCHILD'}->($sdpn);
	}

	$parent->{'ADDCHILD'}->($node);
  }

  return %subdomains;
}

sub createMaillists {
  my ($domainId, $domain, $parent) = @_;

  my %aliasesToIgnore;

  open(LISTLIST, "find " . getFstPath($domainId) . "/var/lib/majordomo/lists -type f -name '*.config' -mindepth 1 -maxdepth 1 |");
  binmode LISTLIST;
  while(<LISTLIST>) {
	chomp;
	my $configFileName = $_;

	/([^\/]+)\.config/;
	my $listName = $1;

	/^(.+)\.config$/;
	my $usersFileName = $1;

	my $admin_passwd = "";

	open(LISTCONFIG, $configFileName);
	binmode LISTCONFIG;
	while (<LISTCONFIG>) {
	  if (/admin_passwd\s=\s(.*)$/) {
		$admin_passwd = $1;
		last;
	  }
	}
	close LISTCONFIG;

	my $item = XmlNode->new('maillist');
	$item->{'ATTRIBUTE'}->('name', $listName);

        my $statusNode = XmlNode->new('status');
        $statusNode->{'ADDCHILD'}->(XmlNode->new('enabled'));
        $item->{'ADDCHILD'}->($statusNode);

	my $listOwner = 'owner-not-found';
	my $aliasGatherer = sub {
	  my ($alias, $redirects, $localDelivery, $responders) = @_;

	  if ($alias eq $listName . '-owner') {
		if (@{$localDelivery}) {
		  $listOwner = $localDelivery->[0] . '@' . $domain;
		} elsif (@{$redirects}) {
		  $listOwner = $redirects->[0];
		}
		return 0;
	  }

	  return 1;
	};
	traverseMailAliases($domainId, $aliasGatherer);

	$item->{'ADDCHILD'}->(XmlNode->new('owner', 'content' => $listOwner));
	createPasswordNode($item, $admin_passwd, 'plain');

	open(LISTMEMBERS, $usersFileName);
	binmode LISTMEMEBERS;
	while (<LISTMEMBERS>) {
	  chomp;
	  $item->{'ADDCHILD'}->(XmlNode->new('recipient', 'content' => $_));
	}

	$parent->{'ADDCHILD'}->($item);

	$aliasesToIgnore{'owner-' . $listName} = 1;
	$aliasesToIgnore{$listName . '-owner'} = 1;
	$aliasesToIgnore{$listName . '-request'} = 1;
	$aliasesToIgnore{$listName . '-approval'} = 1;
  }
  close LISTLIST;

  return \%aliasesToIgnore;
}

sub createMailNode {
  my ($domainId, $domain, $parent, $domusersRef, $aliasesToIgnore) = @_;
  my %domusers = %{$domusersRef};


  #
  # CONFIGURATION FILES
  #
  my %sqmailInfo       = %{readConfigFile($domainId, 'sqmail')};
  my %sendmailInfo     = %{readConfigFile($domainId, 'sendmail')};
  my %majordomoInfo    = %{readConfigFile($domainId, 'majordomo')};
  my %vacationInfo     = %{readConfigFile($domainId, 'vacation')};

  unless ($sendmailInfo{'enabled'}) {
	return;
  }

  my $item = XmlNode->new('email');
  $item->{'ATTRIBUTE'}->('mail-server-name', $sendmailInfo{'mailserver'});

  #
  # PERMISSIONS
  #
  createPermissionNode($item, 'email', 'majordomo',
					   $majordomoInfo{'enabled'});
  createPermissionNode($item, 'email', 'autoresponder',
					   $vacationInfo{'enabled'});
  createPermissionNode($item, 'email', 'webmail',
					   $sqmailInfo{'enabled'});

  #
  # MAILALIASES & DOMAIN USERS
  #

  my %singleAliases;
  my %complexAliases;

  my $aliasGatherer = sub {
	my ($alias, $redirects, $localDelivery, $responders) = @_;

	if (defined $domusers{$alias}) {
	  return 1;
	}

	if (defined $aliasesToIgnore->{$alias}) {
	  return 1;
	}

	if (@{$redirects} == 0 && @{$localDelivery} == 0 && @{$responders} == 0) {
	  return 1;
	}

	if (@{$redirects} == 0 && @{$localDelivery} == 1 && @{$responders} == 0) {
	  unless (defined $singleAliases{$localDelivery->[0]}) {
		$singleAliases{$localDelivery->[0]} = [];
	  }
	  push @{$singleAliases{$localDelivery->[0]}}, $alias;
	} else {
	  $complexAliases{$alias} = { 'redirects' => $redirects,
								  'localDelivery' => $localDelivery,
								  'responders' => $responders };
	}
	return 1;
  };
  traverseMailAliases($domainId, $aliasGatherer);

  my ($domuser, $p);
  while (($domuser, $p) = each(%domusers)) {
	createDomuserMailNode($item, $domain, $domainId, $domuser, $p, $singleAliases{$domuser});
  }


  my ($alias, $complexAlias);
  while (($alias, $complexAlias) = each %complexAliases) {
	createComplexAliasMailNode($item, $domain, $alias, $complexAlias);
  }

	createRejectListNode($item, $domain, $domainId);

  $parent->{'ADDCHILD'}->($item);
}

sub createRejectListNode{
  my ($parent, $domain, $domainId) = @_;
 
  my $rejectlistnode;
  open(INPUT, getFstPath($domainId) . "/etc/mail/access");
  binmode INPUT;
  while (<INPUT>) {
	  if (/^(.*)\s+REJECT$/) {
	    if(not defined $rejectlistnode){
	      $rejectlistnode = XmlNode->new( 'reject-list' );
		  }
	    my $item = XmlNode->new('reject', 'content' => $1);
	    $rejectlistnode->{'ADDCHILD'}->($item);
	  }
  }
  if(defined $rejectlistnode) {
    $parent->{'ADDCHILD'}->($rejectlistnode);
  }
}



sub makeSpamassassinNode{
  my ( $root, $config, $home) = @_;

  return unless -e "$config";

  my $saEnabled = 'on';

  my $sanode = XmlNode->new( 'spamassassin' );
  $root->{'ADDCHILD'}->( $sanode );
  $sanode->{'ATTRIBUTE'}->('status',$saEnabled);

  my $saConfig = SpamAssassinCfg::parseConfig( $config, $home );

  my $cfgvalues = SpamAssassinCfg::getConfigRequireScore( $saConfig );
  $sanode->{'ATTRIBUTE'}->('hits',$cfgvalues) if $cfgvalues;

  $cfgvalues = SpamAssassinCfg::getConfigRewriteHeadr( $saConfig );
  if( $cfgvalues ){
          if( scalar(@{$cfgvalues})==2 ){
                  $sanode->{'ATTRIBUTE'}->('subj-text',${$cfgvalues}[1]) if lc(${$cfgvalues}[0]) eq 'subject';
          }
          $sanode->{'ATTRIBUTE'}->('action', 'mark');
   }

  $cfgvalues = SpamAssassinCfg::getConfigBlackList( $saConfig );
  makeSpamassassinLists( $sanode, $cfgvalues, 'blacklist-member' );

  $cfgvalues = SpamAssassinCfg::getConfigWhiteList( $saConfig );
  makeSpamassassinLists( $sanode, $cfgvalues, 'whitelist-member' );

  $cfgvalues = SpamAssassinCfg::getConfigUnBlackList( $saConfig );
  makeSpamassassinLists( $sanode, $cfgvalues, 'unblacklist-member' );

  $cfgvalues = SpamAssassinCfg::getConfigUnWhiteList( $saConfig );
  makeSpamassassinLists( $sanode, $cfgvalues, 'unwhitelist-member' );
  return 1;
}

sub makeSpamassassinLists{
  my ( $root, $cfgvalues, $listname ) = @_;
  return unless defined $cfgvalues;

  foreach my $item( @{$cfgvalues} ){
      $root->{'ADDCHILD'}->( XmlNode->new( $listname, 'content' => $item ) ) if $item;
  }
}

sub createDomuserMailNode {
  my ($parent, $domain, $domainId, $domuser, $paramsPtr,  $aliasesPtr) = @_;
  my %params = %{$paramsPtr};
  my $password = $params{'password'};

  my $forward = "/home/virtual/".$domain."/home/".$domuser."/.forward";

  my $mailuserNode = XmlNode->new('mailuser');
  $mailuserNode->{'ATTRIBUTE'}->('name', $domuser);
  if (defined($password)) {
	createPasswordNode($mailuserNode, $password, 'encrypted');
  }

  my $mailboxNode = XmlNode->new('mailbox');

  if (defined $params{'cid'} or defined $params{'cid_inbox'}) {
  	if( defined $params{'type'} ) { $mailboxNode->{'ATTRIBUTE'}->('type', $params{'type'}); }
	else { $mailboxNode->{'ATTRIBUTE'}->('type', 'mbox'); }
  }

  if (defined $params{'cid'}) {
	$mailboxNode->{'ATTRIBUTE'}->('cid', $params{'cid'});
  }

  if (defined $params{'cid_inbox'}) {
	$mailboxNode->{'ATTRIBUTE'}->('cid_inbox', $params{'cid_inbox'});
  }

  $mailuserNode->{'ADDCHILD'}->($mailboxNode);

  if (defined($aliasesPtr)) {
	my $alias;
	foreach $alias (@{$aliasesPtr}) {
	  my $aliasNode = XmlNode->new('alias', 'content' => $alias);
	  $mailuserNode->{'ADDCHILD'}->($aliasNode);
	}
  }

  if (-e $forward) {
    my @content;
    open(FORWARD, "< $forward");
    while(<FORWARD>){
      if(not s/^\\//){
        @content = split(/;/, $_);
      }
    }
    close FORWARD;
    chomp @content;
    if (scalar(@content) == 1) {
      $mailuserNode->setAttribute('mailgroup-enabled','false');
      $mailuserNode->{'ADDCHILD'}->(XmlNode->new('redirect', "content" => $content[0]));
    }else{
      $mailuserNode->setAttribute('mailgroup-enabled','true');
      foreach my $member (@content) {
        $mailuserNode->addChild(XmlNode->new('mailgroup-member', 'content' => $member ));
      }
    }

  }else{
    $mailuserNode->setAttribute('mailgroup-enabled','false');
  }

	if(not defined makeSpamassassinNode($mailuserNode, getFstPath($domainId) . "/home/". $domuser. "/.spamassassin/user_prefs" ), getFstPath($domainId) . "/home/". $domuser) {
			#use default domain settings:
			makeSpamassassinNode($mailuserNode, getFstPath($domainId) . "/etc/mail/spamassassin/local.cf", getFstPath($domainId));
	}
  
  $parent->{'ADDCHILD'}->($mailuserNode);
}

sub createComplexAliasMailNode {
  my ($parent, $domain, $alias, $complexAliasPtr) = @_;
  my %complexAlias = %{$complexAliasPtr};

  my $item = XmlNode->new('mailuser');
  $item->{'ATTRIBUTE'}->('name', $alias);

  if (@{$complexAlias{'localDelivery'}} || @{$complexAlias{'redirects'}}) {
	$item->{'ATTRIBUTE'}->('mailgroup-enabled', 'true');
  } else {
	$item->{'ATTRIBUTE'}->('mailgroup-enabled', 'false');
  }
  my $redirect;
  foreach $redirect (@{$complexAlias{'redirects'}}) {
	my $redirectNode = XmlNode->new('mailgroup-member', 'content' => $redirect);
	$item->{'ADDCHILD'}->($redirectNode);
  }

  my $localDelivery;
  foreach $localDelivery (@{$complexAlias{'localDelivery'}}) {
	my $ldNode = XmlNode->new('mailgroup-member', 'content' => $localDelivery . "@" . $domain);
	$item->{'ADDCHILD'}->($ldNode);
  }

  my $autorespondersNode = XmlNode->new('autoresponders');
  $autorespondersNode->{'ATTRIBUTE'}->('enabled', 'true');

  my ($nresp, $responder);
  $nresp = 1;
  foreach $responder (@{$complexAlias{'responders'}}) {
	my $respondernode = XmlNode->new('autoresponder');
	$respondernode->{'ATTRIBUTE'}->('name', 'responder' . $nresp++);
	$respondernode->{'ATTRIBUTE'}->('subject', $responder->{'subject'});
	$respondernode->{'ADDCHILD'}->(XmlNode->new('text', 'content' => $responder->{'body'}));
	$autorespondersNode->{'ADDCHILD'}->($respondernode);
  }

  $item->{'ADDCHILD'}->($autorespondersNode);

  $parent->{'ADDCHILD'}->($item);
}

sub traverseMailAliases {
  my ($domainId, $executor) = @_;

  my $configReader = makeFileParser(getFstPath($domainId). "/etc/aliases");
  my %aliases = %{$configReader->{'PARSE'}->('KEYSEPARATOR' => ':',
											 'COMMENT' => '#',
											 'VALUESEPARATOR' => ',')};

  my ($alias, $ptrActions);
  while (($alias, $ptrActions) = each %aliases) {
	my @actions = @{$ptrActions};
	my (@redirects, @localDelivery, @responders);

	@actions = map { chomp; s/^\s*(.*)$/$1/; $_; } @actions;
	foreach (@actions) {
	  if (/^"\|responder\.sh\s+\S+\s+(\S+)"$/) {
		open INPUT, getFstPath($domainId) . $1;
		binmode INPUT;
		my $subject = <INPUT>;
		my $body;
		while (<INPUT>) {
		  $body .= $_;
		}
		close(INPUT);

		$subject = $wrapBase64->{'ENCODE'}->($subject);
		$body = $wrapBase64->{'ENCODE'}->($body);

		chomp $subject;
		chomp $body;

		push @responders, { 'subject' => $subject, 'body' => $body };
	  } elsif (/^([\w\.-]+)$/) {
		push @localDelivery, $1;
	  } elsif (/^([\w@\.-]+)$/) {
		push @redirects, $1;
	  } elsif (/^"\|\/usr\/lib\/majordomo\/wrapper$"/) {
		&printToLog("Majordomo action ignored: " . $_);
	  } elsif (/^:include:/) {
		&printToLog("Majordomo action ignored: " . $_);
	  } else {
		&printToLog("Unknown action detected: " . $_);
	  }
	}
	if ($executor->($alias, \@redirects, \@localDelivery, \@responders) == 0) {
	  last;
	}
  }
}

sub createLogrotationNode {
  my ($domainId, $parent, $adminemail) = @_;

  open(LOGROT, getFstPath($domainId) . "/etc/logrotate.conf") or return;
  binmode LOGROT;

  my $mult = 1;
  my $maxnumber;
  my $maxsize;
  my $period = 'monthly';

  while (<LOGROT>) {
	chomp;
	if (/^rotate\s+(\d+)*$/) {
	  $maxnumber = $1;
	} elsif (/^size\s+(\d+)(.?)$/) {
	  if ($2 eq '') {
		$mult = 1;
	  } elsif ($2 eq 'M') {
		$mult = $megabyte;
	  } elsif ($2 eq 'k') {
		$mult = $kilobyte;
	  }
	  $maxsize = $1;
	} elsif (/^(daily|weekly|monthly)$/) {
	  $period = $1;
	}
  }

  if (not(defined($maxnumber)) or not(defined($maxsize))) {
	printToLog("Log rotation configuration is not complete.");
	return;
  }

  my $logrotationnode = XmlNode->new('logrotation');
  $logrotationnode->{'ATTRIBUTE'}->('enabled', 'true');
  $logrotationnode->{'ATTRIBUTE'}->('max-number-of-logfiles', $maxnumber);
  $logrotationnode->{'ATTRIBUTE'}->('compress', 'true');
  $logrotationnode->{'ATTRIBUTE'}->('email', $adminemail) if defined($adminemail);

  if($maxsize != 0) {
	my $logrotationsizenode = XmlNode->new('logrotation-maxsize', 'content' => ($maxsize * $mult));
	$logrotationnode->{'ADDCHILD'}->($logrotationsizenode);
  } else {
	my $logrotationperiodnode = XmlNode->new('logrotation-period');
	$logrotationperiodnode->{'ATTRIBUTE'}->('period', $period);
	$logrotationnode->{'ADDCHILD'}->($logrotationperiodnode);
  }
  $parent->{'ADDCHILD'}->($logrotationnode);
}

sub createFtpNode {
  my ($domainId, $parent) = @_;

  #
  # CONFIGURATION FILES
  #
  my %anonftpInfo      = %{readConfigFile($domainId, 'anonftp')};
  my %proftpdInfo      = %{readConfigFile($domainId, 'proftpd')};
  my %domainInfo       = %{readConfigFile($domainId, 'siteinfo')};

  my $domainName = $domainInfo{'domain'};

  unless ($proftpdInfo{'enabled'}) {
	return;
  }

  my $item = XmlNode->new('ftp');
  $item->{'ATTRIBUTE'}->('ftp-server-name', $proftpdInfo{'ftpserver'});

  createPermissionNode($item, 'ftp', 'anon-ftp', $anonftpInfo{'enabled'});

  my $anonftpPub = getFstPath($domainId) . "/var/ftp/pub";
  if (-d $anonftpPub) {
	my $fileName = makeDumpFile("$dumpDir/$domainName\_\_\_anonftp",
								$anonftpPub);
	if ($fileName) {
	  $item->{'ATTRIBUTE'}->('cid', $fileName);
	}
  }

  my $anonftpIncoming = getFstPath($domainId) . "/var/ftp/incoming";
  if (-d $anonftpIncoming) {
	my $fileName = makeDumpFile("$dumpDir/$domainName\_\_\_anonftp\_incoming",
								$anonftpIncoming);
	if ($fileName) {
	  $item->{'ATTRIBUTE'}->('cid_incoming', $fileName);
	}
  }

  $parent->{'ADDCHILD'}->($item);
}

sub createPdirNodes {
  my ($domainId, $parent) = @_;

  my %htusers;
  my %htgroups;

  my $htpasswdReader =
	makeSafeFileParser(getFstPath($domainId) . "/var/www/.htpasswd");

  if (defined($htpasswdReader)) {
	%htusers = %{$htpasswdReader->{'PARSE'}->('KEYSEPARATOR'  => ':')};
  }

  my $htgroupReader = makeSafeFileParser(getFstPath($domainId) .
										 "/var/www/.htgroup");
  if (defined($htgroupReader)) {
	%htgroups = %{$htgroupReader->{'PARSE'}->('KEYSEPARATOR' => ':')};

	my $group;
	foreach $group (keys %htgroups) {
	  my @members = split(/\s+/, $htgroups{$group});
	  $htgroups{$group} = \@members;
	}
  }

  my $cgiaccesses;
  open($cgiaccesses, "find '" . getFstPath($domainId) . "/var/www/cgi-bin' -name .htaccess -type f |");
  binmode $cgiaccesses;
  while (<$cgiaccesses>) {
   	chomp $_;
		createPdirNode($domainId,$_,\%htgroups,\%htusers,'/cgi-bin/',$parent);
  }
  close $cgiaccesses;

	my $accesses;
	open($accesses, "find '" . getFstPath($domainId) . "/var/www/html' -name .htaccess -type f |");
  binmode $accesses;

  while (<$accesses>) {
   	chomp $_;
   	createPdirNode($domainId,$_,\%htgroups,\%htusers,'/html'.getRelDir($domainId, $_),$parent);
  }
  close $accesses;
}

sub createPdirNode {
  my ($domainId, $access, $usergroups, $users, $name, $parent) = @_;
  my %htgroups = %{$usergroups};
  my %htusers = %{$users};

	my $pdirnode = XmlNode->new('pdir');
	$pdirnode->{'ATTRIBUTE'}->('name', $name);

	my %pdirusers;

	open ACCESS, $access;
	binmode ACCESS;
	while (<ACCESS>) {
	  chomp $_;
	  if (/require\s+group\s+(.*)$/) {
		  my @groups = split /\s+/, $1;
		  my $group;
		  foreach $group (@groups) {
		  	if (defined($htgroups{$group})) {
			    my $htuser;
			    foreach $htuser (@{$htgroups{$group}}) {
			      if (defined($htusers{$htuser})) {
				      $pdirusers{$htuser} = $htusers{$htuser};
			      }
			      else {
				      $pdirusers{$htuser} = '';
			      }
  			  }
    	  }
 	    }
	  } 
	  elsif (/AuthName \"(.*)\"$/) {
		  $pdirnode->{'ATTRIBUTE'}->('title', $1);
	  }
	}
	close ACCESS;

	if (%pdirusers) {
	  my ($user, $password);
	  while (($user, $password) = each %pdirusers) {
		  my $htusernode = XmlNode->new('pduser');
		  $htusernode->{'ATTRIBUTE'}->('name', $user);
		  if ($password eq '') {
		    createPasswordNode($htusernode, '', 'plain');
  		}
	  	else {
		    createPasswordNode($htusernode, $password, 'encrypted');
  		}
	  	$pdirnode->{'ADDCHILD'}->($htusernode);
	  }
	}
  $parent->{'ADDCHILD'}->($pdirnode);
}

sub getRelDir {
  my ($domainId, $name) = @_;
  my $prefix = getFstPath($domainId) . "/var/www/html";
  if ($name =~ /^\Q$prefix\E(.*)\.htaccess$/) {
	my $name = $1;
	if ($name =~ /^(.*)\/$/ and $name ne '/') {
	  return $1;
	}
	return $name;
  }

  die "Cannot remove '$prefix' from the '$name'";
}

sub createDbNode {
  my ($domainId, $parent) = @_;
  my ($ptrRow, $ptrHash);

  #
  # CONFIGURATION FILES
  #
  my %mysqlInfo = %{readConfigFile($domainId, 'mysql')};
  my %domainInfo = %{readConfigFile($domainId, 'siteinfo')};
  $domainInfo{'domain'}=~s/\./_/g;
  if (!exists $mysqlInfo{'dbaseprefix'}) {
    $mysqlInfo{'dbaseprefix'} = $domainInfo{'domain'}; # Bug 92808
  }

  my $dbPassword = getMysqlPassword();

  my $wrapUserMysql = getDbConnect('mysql', 'root', $dbPassword, 'mysql', 'localhost');

  my $sql = "SHOW DATABASES LIKE '" . $mysqlInfo{'dbaseprefix'} . "%'";

  $wrapUserMysql->{'EXECUTE'}->($sql);

  my @userDatabases;
  while ($ptrRow = $wrapUserMysql->{'FETCHROW'}->()) {
	push @userDatabases, (@{$ptrRow})[0];
  }
  $wrapUserMysql->{'FINISH'}->();

  my ($dbName);
  foreach $dbName (@userDatabases) {

	my $dbNode = XmlNode->new('database');
	$dbNode->{'ATTRIBUTE'}->('name', $dbName);
	$dbNode->{'ATTRIBUTE'}->('type', 'mysql');
    $dbNode->{'ATTRIBUTE'}->('version', Db::MysqlUtils::getVersion());

	#skip bases with '.'
	if ($dbName =~ /\./) {
	  next;
	}

	my $db = getDbConnect('mysql', 'root', $dbPassword, $dbName, 'localhost');

	if (defined($db)) {
	  my $dbDump = makeDumpDb($dbName, 'mysql', 'root',
							  $dbPassword, 'localhost');
	  $dbNode->{'ATTRIBUTE'}->('cid', $dbDump);

	  addDbUsers($dbNode, $dbName, $wrapUserMysql);

	  $parent->{'ADDCHILD'}->($dbNode);
	}
  }
}

sub createMailScannerNode {
  my ($domainId, $parent, $mailscannerInfoPtr) = @_;

  if ($mailscannerInfoPtr->{'enabled'} eq '0') {
	return;
  }
  my $mailscannerNode = XmlNode->new('mailscanner');
  $mailscannerNode->{'ATTRIBUTE'}->('status', 'on');
  
  my $scan_incoming = 'false';
  my $scan_outgoing = 'false';
  if ($mailscannerInfoPtr->{'scan_incoming'} eq '1') {
    $scan_incoming = 'true'; 
  }
  if ($mailscannerInfoPtr->{'scan_outgoing'} eq '1') {
    $scan_outgoing = 'true'; 
  }
  $mailscannerNode->{'ATTRIBUTE'}->('scan_incoming', $scan_incoming);
  $mailscannerNode->{'ATTRIBUTE'}->('scan_outgoing', $scan_outgoing);
  
  $parent->{'ADDCHILD'}->($mailscannerNode);
}

sub createSslNode {
  my ($domainId, $parent, $sslInfoPtr) = @_;

  if ($sslInfoPtr->{'enabled'} eq '0') {
	return;
  }

  my $childCount = 0;
  my $sslNode = XmlNode->new('certificate');
  my $content;
  my $confDir = getFstPath($domainId) . "/etc/httpd/conf";

  $content = readFile($confDir . "/ssl.crt/server.crt");
  if ($content) {
	$sslNode->{'ADDCHILD'}->(XmlNode->new('certificate-data', 'content' => $content));
        $childCount += 1;
  }

  $content = readFile($confDir . "/ssl.csr/server.csr");
  if ($content) {
	$sslNode->{'ADDCHILD'}->(XmlNode->new('signing-request', 'content' => $content));
        $childCount += 1;
  }

  $content = readFile($confDir . "/ssl.key/server.key");
  if ($content) {
	$sslNode->{'ADDCHILD'}->(XmlNode->new('private-key', 'content' => $content));
        $childCount += 1;
  }

  $parent->{'ADDCHILD'}->($sslNode) if $childCount>0;
}

sub addDnsRecord {
  my ($node, $type, $src, $dst, $opt) = @_;

  my $rec = XmlNode->new('dnsrec', 'attributes' => {'type' => $type, 'src' => $src });
  if (defined $dst) {
    $rec->{'ATTRIBUTE'}->('dst', $dst);
  }
  if (defined $opt) {
    $rec->{'ATTRIBUTE'}->('opt', $opt);
  }
  $node->{'ADDCHILD'}->($rec);
}

sub createDnsZoneNode {
  my ($domainId, $parent, $webmailRecord, $adminEmail, $domainName, $domainIp) = @_;

  my $dnsfile = "/var/named/db.".$domainName;

  return unless -e $dnsfile;

  my $node = XmlNode->new('dns-zone',
                     'attributes' => {'email' => $adminEmail,
                                      'type' => 'master'});

  $node->{'ADDCHILD'}->(XmlNode->new('status', 'children' => [XmlNode->new('enabled')]));

  # Code below is borrowed from Perl::Net::DNS::Zone::Parser with slight modifications
  open(DNS, "named-checkzone -D $domainName $dnsfile |");
  my $loadzone_result;

  PARSELOAD: while (<DNS>) {
    if (/^zone $domainName\/IN: (.*)/) {
      unless ($1 =~ /^loaded serial \d+( \(signed\))?$/) {
        close(DNS);
        return;
      }
      last PARSELOAD;
    }
  }

  CONTENT: while (<DNS>) {
    # and the zone is nicely cannonicalized by named-checkzone -D
    last if /^OK$/;

    if (/^\S+\s+\d+\s+IN\s+(NS|A|CNAME|MX|PTR|TXT)\s+/o) {
      
      my $type=$1;
      
      chomp $_;
      Logging::info("Canonized record: " . $_);

      my ($src, $ttl, $in, $type, $opt, $dst) = split(/\s+/, $_);
      if ($dst) {
        addDnsRecord($node, $type, $src, $dst, $opt);
      } else {
        addDnsRecord($node, $type, $src, $opt);
      }
    }
  }

  unless (close(DNS)) {
	# manual dns file parsing
	open(DNS, "<$dnsfile");

	while (<DNS>) {
		if (/^(\S*?)(?:\.?$domainName\.)?\s+(NS|A|CNAME|MX|PTR|TXT)\s+(?:(\S+)\s+)?(\S+?)$/i) {
			addDnsRecord($node, $2, ($1 ? "$1." : "")."$domainName.", $4, $3);
		}
	}

	close(DNS);
  }

  $parent->{'ADDCHILD'}->($node);
}

sub readConfigFile {
  my ($domainId, $fileName) = @_;

  my $configReader = makeSafeFileParser("/home/virtual/site" . $domainId .
										"/info/current/" . $fileName);

  if (defined $configReader) {
	return $configReader->{'PARSE'}->('KEYSEPARATOR'  => '=',
									  'COMMENT' => '\[DEFAULT\]');
  } else {
	return { "enabled" => 0 };
  }
}

sub createPasswordNode {
  my ($parent, $password, $type) = @_;

  my $item = XmlNode->new('password', 'content' => $password);
  $item->{'ATTRIBUTE'}->('type', $type);
  $parent->{'ADDCHILD'}->($item);
}

sub createPinfoNode {
  my ($parent, $username, $fullname, $email) = @_;

  my $item = XmlNode->new('pinfo');
  $item->{'ATTRIBUTE'}->('username', $username);
  $item->{'ATTRIBUTE'}->('fullname', $fullname) if defined($fullname);
  $item->{'ATTRIBUTE'}->('e-mail', $email) if defined($email);
  $parent->{'ADDCHILD'}->($item);
}

sub createLimitNode {
  my ($parent, $prefix, $name, $value, $unlimited) = @_;

  if ($unlimited) {
	return;
  }

  my $item = XmlNode->new($prefix . "-limit", 'content' => sprintf("%.0f", $value));
  $item->{'ATTRIBUTE'}->('name', $name);
  $parent->{'ADDCHILD'}->($item);
}

sub createPermissionNode {
  my ($parent, $prefix, $name, $create) = @_;

  if ($create) {
	my $item = XmlNode->new($prefix . "-permission");
	$item->{'ATTRIBUTE'}->('name', $name);
	$parent->{'ADDCHILD'}->($item);
  }
}

sub getFstPath {
  my ($domainId) = @_;
  return "/home/virtual/site" . $domainId . "/fst";
}

#FIXME: move decryptor to the external script

sub getMysqlPassword {

  my $python = AgentConfig::pythonBin();
  my $script =<< "EOS"
import os
import sys
import rotor
mysqlrotkey = ('\%c\%c\%c\%c\%c\%c\%c' % (chr(3), chr(12), chr(234), chr(2), '3', 'e', chr(222)))
def read_mysqlpass():
    if os.path.exists('/etc/appliance/.vpf'):
        f = open('/etc/appliance/.vpf', 'r')
        file = f.read()
        f.close()
        if (len(file) >= 1):
            rotpass = file
            rt = rotor.newrotor(mysqlrotkey, 11)
            rt.decrypt(rotpass)
            return rt.decryptmore(rotpass)
    return ''
sys.stdout.write(str(read_mysqlpass()))
EOS
;
	unless (open(PY, "$python -c \"$script\" |")) {
		return '';
	}
	binmode PY;

	my $passwd = <PY>;
	close(PY);
	chomp $passwd;

	return $passwd;
}

sub printHelp {

  print <<"HELP";

Usage:
$0 <options>

Options:
-s |--get-status           get status of the agent
-dc|--dump-accounts=<list> a coma separated list of resellers to dump
-dd|--dump-domains=<list>  a coma separated list of customers to dump
-da|--dump-all             make a full dump

-lc|--get-content-list     get list of content files
-nc|--no-content           do not make content files
-nz|--no-compress          do not compress content files

-h |--help                 this help

HELP
}