package Dumper;
require 'agent.include.pl';

# use for dump of user's mysql databases
use vars qw($storage);

use strict;

use XmlNode;
use AgentConfig;
use Mailman;
use SpamAssassinCfg;
use Logging;


my $DEFAULT_RESELLER = 'root';

my %mapLimits = (
  'max_addon'     => 'MAXADDON',
  'max_parked'    => 'MAXPARK',
  'max_ftpusers'  => 'MAXFTP',
  'max_maillists' => 'MAXLST',
  'max_box'       => 'MAXPOP',
  'max_db'        => 'MAXSQL',
  'max_subdom'    => 'MAXSUB',
);

# List of cPanel features.
# Features marked as 2 are included to the dump.
# Do not forget change cPanel.xsd, if change flags.
my %mapFeatures = (
  'addoncgi'               => 1,    #Addon Cgi Scripts
  'addondomains'           => 2,    #Addon Domain Manager
  'advguest'               => 1,    #Advanced Guestbook
  'agora'                  => 1,    #Agora Shopping Cart
  'analog'                 => 1,    #Analog Stats
  'emailauth'              => 1,    #Email Authentication
  'autoresponders'         => 1,    #Autoresponder Manager
  'awstats'                => 1,    #Awstats Stats
  'backup'                 => 2,    #Backup Manager
  'bandwidth'              => 1,    #Bandwidth Stats
  'bbs'                    => 1,    #PHPBB2
  'blockers'               => 1,    #Email Filtering Manager
  'boxtrapper'             => 1,    #BoxTrapper Spam Trap
  'cgi'                    => 1,    #CGI Center
  'changemx'               => 1,    #Ability to Change MX
  'chat'                   => 1,    #Chat Rooms
  'clamavconnector_scan'   => 2,    #Virus Scanner
  'clock'                  => 1,    # Java Clock
  'countdown'              => 1,    #Java Countdown
  'counter'                => 1,    #Counter
  'cpanelpro_support'      => 1,    #Support System Submission
  'cpanelpro_images'       => 1,    #Image Manager
  'cron'                   => 2,    #Crontab
  'defaultaddress'         => 1,    #Default Address Manager
  'diskusageviewer'        => 1,    #Disk Usage Viewer
  'emaildomainfwd'         => 1,    #Email Domain Forwarding
  'emailscripts'           => 1,    #Email Scripts (cgiemail,formmail)
  'entropybanner'          => 1,    #Entropy Banner
  'entropysearch'          => 1,    #Entropy Search
  'errlog'                 => 1,    #Error Log
  'errpgs'                 => 1,    #Customer Error Pages
  'fantastico'             => 1,    #
  'filemanager'            => 1,    #File Manager
  'forwarders'             => 1,    #Forwarder Manager
  'frontpage'              => 1,    #Frontpage
  'ftpaccts'               => 1,    #Ftp Account Manager
  'ftpsetup'               => 2,    #Ftp Settings
  'getstart'               => 1,    #Getting Started Wizard
  'guest'                  => 1,    #Simple Guestbook
  'handlers'               => 1,    #Apache Handlers Manager
  'hotlink'                => 1,    #Hotlink
  'ipdeny'                 => 1,    #IP Deny Manager
  'indexmanager'           => 1,    #File Manager Directory Selection
  'interchange'            => 1,    #Interchange Shopping Cart
  'lastvisits'             => 1,    #Latest Visitors
  'cpanelpro_leechprotect' => 1,    #Leech Protect
  'lists'                  => 2,    #Mailman List Manager
  'mime'                   => 1,    #Mime Types Manager
  'modules-perl'           => 1,    #Install Perl Modules
  'modules-php-pear'       => 1,    #Install PHP Pear Modules
  'modules-ruby'           => 1,    #Install Ruby Modules
  'mysql'                  => 1,    #Mysql
  'nettools'               => 1,    #Network Tools
  'parkeddomains'          => 2,    #Parked Domain Manager
  'password'               => 2,    #Password Change
  'pgp'                    => 1,    #PGP/GPG
  'php-config'             => 1,    #See PHP Configuration
  'phpmyadmin'             => 1,    #PhpMyAdmin
  'phppgadmin'             => 1,    #PhpPgAdmin
  'popaccts'               => 1,    #Email Account Manager
  'postgres'               => 1,    #PostgresSQL
  'randhtml'               => 1,    #Random Html Generator
  'rawlog'                 => 2,    #Raw Access Logs
  'redirects'              => 1,    #Redirect Manage
  'ror'                    => 1,    #Ruby on Rails
  'scgiwrap'               => 1,    #Simple Cgi Wrapper
  'searchsubmit'           => 1,    #Search Engine Submit Tool
  'serverstatus'           => 1,    #Server Status Viewer
  'setlang'                => 1,    #Change Language
  'spamassassin'           => 2,    #SpamAssassin
  'spambox'                => 1,    #SpamAssassin Spam Box
  'ssh'                    => 1,    #SSH Connection Window
  'sslinstall'             => 1,    #SSL Host Installer
  'sslmanager'             => 1,    #SSL Manager
  'statmanager'            => 2,    #Statistics Program Manager
  'statselect'             => 1,    #Choose Log Programs
  'style'                  => 1,    #Change Style
  'subdomains'             => 2,    #Subdomain Manager
  'subdomainstats'         => 1,    #Subdomain Stats
  'traceaddy'              => 1,    #Ability to Trace an email address
  'updatecontact'          => 1,    #Update Contact Information
  'videotut'               => 1,    #Video Tutorials
  'webalizer'              => 1,    #Webalizer Stats
  'webdisk'                => 1,    #Web Disk
  'webmail'                => 1,    #Webmail
  'webprotect'             => 1,    #Webprotect
  'backupwizard'           => 1,    #Backup Wizard
);


#
# global variables
#
my $dumpDir = '/';

my ( $ptrRowResellers, %resellers_accounts, @default_reseller_account,
  $ptrQuota, $ptrResellerInfo, %servers_ips );

# %resellers_accounts is a hash of non-reseller accounts owned by ressller
#     { key => reseller_name, value => [ account1_name, account2_name, ...]}

# @default_reseller_account is an array of non-reseller accounts owned by
# default reseller (root)

my $ptrUserdomainsHash;
my %trueUserDomains;
my %trueDomainAccounts;
my %anonftps;

my %accountNodes;

#
# end global variables
#

my (%cPanelConfig);

my $rootName = 'cpanel-migration-dump';

my (%featureList);

my $installDir = $cPanelConfig{'installDir'} || '/var/cpanel';

my $wrapUserMysql;


#
# get MIME Base64 encoder
#
my $wrapBase64 = makeMIMEBase64();

sub initStorage {
	initStorage(shift);
}

sub printToLog{
	Logging::info(shift);
}

sub printToError {
  Logging::error(shift);
}

sub loadMainConfig {
  my $pathToConf = shift || '';
  my $ptrHash = shift || \%cPanelConfig;

  unless ( -T $pathToConf ) {
    foreach my $prefix ( './', '/var/cpanel/' ) {
      $pathToConf = $prefix . 'cpanel.config';
      if ( -T $pathToConf ) {
        last;
      }
    }
  }

  if ( -T $pathToConf ) {
    if ( ref($ptrHash) =~ /HASH/ ) {
      if ( $pathToConf =~ /(.+)\/[^\/]+/ ) {
        $ptrHash->{'installDir'} = $1;
      }
      if ( open( CF, "<$pathToConf" ) ) {
        binmode CF;
        my ( $key, $value );
        while ( my $line = <CF> ) {
          chomp $line;
          next unless $line;
          next if ( $line =~ /^#/ );
          ( $key, $value ) = split( /\s*=\s*/, $line, 2 );
          $key =~ s/^\s+//;
          $ptrHash->{$key} = $value;
        }
        close(CF);
      }
    }
  }
  else {
    $pathToConf = '';
  }
  return $pathToConf;
}

sub parseInputDomainNamesToRealDomanNames {
  my $input = $_[0];
  my @domains = split( /\s*,\s*/, $input );
  my @result;
  my $ptrUserdomainsHash;
  my $myUserdomainsHash;
  foreach my $domainName (@domains) {
    push @result, $domainName;
    if ( not defined getDomainOwner($domainName) ) {
      unless ( ref($myUserdomainsHash) =~ /HASH/ ) {
        my $fileParser = makeFileParser('/etc/userdomains');
        $myUserdomainsHash =
          $fileParser->{'PARSE'}->( 'KEYSEPARATOR' => ':' );
      }
      if ( ref($myUserdomainsHash) =~ /HASH/ ) {
        if ( exists ${ %{$myUserdomainsHash} }{$domainName} ) {
          my $account       = ${ %{$myUserdomainsHash} }{$domainName};
          my $accountDomain = getDomainName($account);
          if ($accountDomain) {
            printToLog(
              "Include read domain name '$accountDomain' from domain name '$domainName' of owner '$account' to dump selected domain"
            );

            #push @domains, $accountDomain;
            push @result, $accountDomain;
          }
          else {
            printToLog("Cannot find name '$domainName'[owner='$account']");
          }
        }
      }
    }
  }
  return @result;
}

sub setDumpDir {
	$dumpDir = shift;
	getDumpDir($dumpDir); # clean up dir
}

#######################################################
#
#  Get all client accounts, registered in the system
#
#######################################################
sub getAllAccounts {
  my @all_accounts;

  my $users_dir = "$installDir/users";
  opendir( USRS, $users_dir ) || die "Can't open directory $users_dir: $!";
  my @accts = readdir(USRS);
  closedir(USRS);
  chomp(@accts);

  # remove duplicate and possible wrong entries
  foreach my $account (@accts) {
    next if ( $account =~ /\./ || grep( /^$account$/, @all_accounts ) );
    push @all_accounts, $account;
  }

  return @all_accounts;
}

sub initialize {
  my @all_accounts = getAllAccounts();

  %featureList = loadFeatureList();
}

sub loadFeatureList {
  my %list;

  my $features_dir = "$installDir/features";
  opendir( FLST, $features_dir ) || die "Can't open directory $features_dir: $!";
  my @lsts = readdir(FLST);
  closedir(FLST);

  foreach my $lst (@lsts) {
    my $cfg = "$features_dir/$lst";
    if ( -T $cfg ) {
      printToLog("Reading feature list: $lst");
      my $cfgParser = &makeFileParser($cfg);
      my $values = $cfgParser->{'PARSE'}->( 'KEYSEPARATOR' => '=' );
      $list{$lst} = $values;
      printToLog("Feature list '$lst' is read");
    }
  }

  #convert disabled options
  if ( exists $list{'disabled'} ) {
    printToLog("Apply disabled feature list");
    foreach my $key ( keys %list ) {
      if ( not $key eq 'disabled' ) {
        my $vals = $list{$key};
        foreach my $diskey ( keys %{ $list{'disabled'} } ) {
          ${$vals}{$diskey} = 0
            if ${ $list{'disabled'} }{$diskey} == 0
              and exists ${$vals}{$diskey};
        }
      }
    }
  }

  #create default
  if ( exists $list{'default'} ) {
    printToLog("Apply default feature list");
    foreach my $mapkey ( keys %mapFeatures ) {
      ${ $list{'default'} }{$mapkey} = 1
        if not exists ${ $list{'default'} }{$mapkey};
    }
  }
  return %list;

}

##########################################
#
#   $ptrAccounts - accounts, that have been specified as a --dump-accounts
#   $ptrDomains  - domains, that have been specified as a --dump-domains
#
##########################################
sub getDump {

  my ( $dumpDir, $ptrResellers, $ptrClients,  $ptrDomains, $rootName ) = @_;

  my @domains = parseInputDomainNamesToRealDomanNames($ptrDomains);    #handle bug 137852
  $ptrDomains = \@domains;

  my $root =
    XmlNode->new( $rootName, 'attributes' => { 'agent-name' => 'cPanel', 'dump-version' => '11.0' } );

  my (
    $reseller, $fileResellers, $ptrRows, $owner, $item,
    $account,  $ptrHash,       $key,     $value
  );

  my @all_accounts = getAllAccounts();

  %featureList = loadFeatureList();

  # No accounts - nothing to dump
  return $root if ( -1 == $#all_accounts );

  my $resellers_file = "$installDir/resellers";
  if ( -f $resellers_file ) {

    # Find all the resellers in the system
    $fileResellers = &makeFileParser(
      $resellers_file,
      'KEYSEPARATOR'      => ':',
      'VALUESEPARATOR'    => ',',
      'KEYVALUESEPARATOR' => ' '
    );

    # All the resellers in the system (not including the default reseller)
    $ptrRowResellers = $fileResellers->{'PARSE'}->();
  }

  # Associative array of domain owners => {0 if only this domain should
  # be dumped and 1 if all domains should be dumped, domain}
  my %accounts;

 # If domains were specified through command line search their owning accounts
  if ( ref($ptrDomains) =~ /ARRAY/ ) {

    foreach my $domain ( @{$ptrDomains} ) {
      if ( $owner = &getDomainOwner($domain) ) {
        if ( exists( $accounts{$owner} ) ) {
          push @{ $accounts{$owner}->[1] }, $domain;
        }
        else {
          $accounts{$owner} = [ 0, [$domain] ];
        }
      }
    }
  }

  # If accounts were specified through command line - mark them for dumping
  if ( ref($ptrClients) =~ /ARRAY/ ) {
    foreach my $account ( @{$ptrClients} ) {
      $accounts{$account} = [ 1, undef ];
    }
  }

  # Check that all found resellers are exists
  foreach my $reseller ( keys %{$ptrRowResellers} ) {
    unless ( -T "$installDir/users/$reseller" ) {
      printToLog("Could not find appropriate user account for reseller '$reseller'. Skipping.");
      delete $ptrRowResellers->{$reseller};
      next;
    }
  }

# If no accounts/domains were specified through command line $checkAccounts is 0
  my $checkAccounts = scalar(%accounts);

  my %reseller_owner = {};

  # For each account in the system
  foreach $account (@all_accounts) {
    my $fileUser = makeFileParser("$installDir/users/$account");

    next unless ($fileUser);

    $ptrRows = $fileUser->{'PARSE'}->( 'KEYSEPARATOR' => '=' );

    # If file is empty or wrong format
    unless ( ref($ptrRows) =~ /HASH/ ) {
      printToLog("Failed parse account file for '$account': File is empty or has wrong format.");
      delete $ptrRowResellers->{$account};
      next;
    }

    $owner = $ptrRows->{'OWNER'};

    if ( $owner
      && ( $owner ne $account )
      && ( $owner ne $DEFAULT_RESELLER )
      && ( exists $ptrRowResellers->{$owner} ) )
    {
      if ( exists $ptrRowResellers->{$account} ) {
        $reseller_owner{$account} = $owner;
      }
      else {
        push @{ $resellers_accounts{$owner} }, $account;    # customer
      }

    }
    else {
      # Account belongs to default reseller
      if ( exists $ptrRowResellers->{$account} ) {
        $reseller_owner{$account} = undef;
      }
      else {
        push @default_reseller_account, $account;
      }
    }
  }

  # Get disk quotas
  my $fileUser = makeFileParser("/etc/quota.conf");
  $ptrQuota = $fileUser->{'PARSE'}->('KEYSEPARATOR' => '=','VALUESEPARATOR' => '');

  unless ( ref($ptrQuota) =~ /HASH/ ) {
    $ptrQuota = {};
  }

  #
  # prepare reseller's info
  #
  $ptrResellerInfo = {};

  my $reseller_limits_bynumber_file = "$installDir/reseller-limits-bynumber";
  if ( -f $reseller_limits_bynumber_file ) {
    $fileUser = makeFileParser($reseller_limits_bynumber_file);
    $ptrHash =
      $fileUser->{'PARSE'}->( 'KEYSEPARATOR' => '=', 'VALUESEPARATOR' => '' );

    if ( ref($ptrHash) =~ /HASH/ ) {
      while ( ( $reseller, $value ) = each( %{$ptrHash} ) ) {
        $ptrResellerInfo->{$reseller} = { 'limits-bynumber' => $value };
      }
    }
  }

  my $reseller_resource_limits = "$installDir/reseller-resource-limits";
  if ( -f $reseller_resource_limits ) {
    $fileUser = makeFileParser($reseller_resource_limits);
    $ptrHash =
      $fileUser->{'PARSE'}->( 'KEYSEPARATOR' => ' ', 'VALUESEPARATOR' => '' );

    if ( ref($ptrHash) =~ /HASH/ ) {
      my ( $tail, $keyLimit, $valLimit, $ptrLimits );

      while ( ( $reseller, $value ) = each( %{$ptrHash} ) ) {
        ( $key, $tail ) = split( ' ', $value, 2 );
        $ptrLimits = {};

        foreach my $chunk ( split( /\s*:\s*/, $tail ) ) {
          if ( $chunk =~ /(\S+)\s*=\s*(\S+)/ ) {
            $ptrLimits->{$1} = $2;
          }
        }

        if ( exists $ptrResellerInfo->{$reseller} ) {
          $ptrResellerInfo->{$reseller}->{'resource-limits'} =
            [ $key, $ptrLimits ];
        }
        else {
          $ptrResellerInfo->{$reseller} =
            { 'resource-limits' => [ $key, $ptrLimits ] };
        }
      }
    }
  }
  #
  # end prepare reseller's info
  #

  #
  # parse httpd.conf
  #
  my $httpdconf_file = "/etc/httpd/conf/httpd.conf";
  unless ( open( INPUT, "<$httpdconf_file" ) ) {
    &printToError("Error: unable to open '$httpdconf_file': $!");
  }
  binmode INPUT;
  my ( $ip, $state, @vDomains, $vDomain );
  $state = 0;
  while (<INPUT>) {
    chomp;
    next unless $_;
    next if (/^#/);
    if ( $state == 1 ) {
      if (/<\/VirtualHost>/) {
        foreach $vDomain (@vDomains) {
          $vDomain =~ s/^www\.//;
          $servers_ips{$vDomain} = $ip;
        }
        @vDomains = ();
        $state    = 0;
      }
      elsif (/^\s*Server(?:Name|Alias)\s+(.*)$/) {
        push @vDomains, split( ' ', $1 );
      }
    }
    else {
      if (/<VirtualHost\s(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})>/) {
        $ip       = $1;
        @vDomains = ();
        $state    = 1;
      }
    }
  }
  close(INPUT);
  #
  # end parse httpd.conf
  #

  ##
  # Determine number of objects to dump
  ##
  #TODO: fix clients and domains count
  my $clientCount  = 1;    #scalar(keys %resellers)+1;
  my $domainCount  = 0;
  my %domainCounts = 1;

  #foreach $reseller (keys %resellers) {
  #$domainCounts{$reseller}=0;
  #}

  unless ( keys %trueUserDomains ) {
    my $fileUser = makeFileParser("/etc/trueuserdomains");
    $ptrHash = $fileUser->{'PARSE'}->( 'KEYSEPARATOR' => ':' );
    if ( ref($ptrHash) =~ /HASH/ ) {
      %trueUserDomains = ( %{$ptrHash} );
    }
  }
  my ($domain);
  while ( ( $domain, $owner ) = each %trueUserDomains ) {
    if ( exists( $domainCounts{$owner} ) ) {
      $domainCounts{$owner}++;
      $domainCount++;
    }
  }

  if ( ref($ptrDomains) =~ /ARRAY/ ) {
    $domainCount = $#{$ptrDomains};
  }

  #$objDumpStatus->{'COUNTS'}->( $clientCount, $domainCount );



  my %resellerNodes = {};

  foreach $reseller ( sort keys %{$ptrRowResellers} ) {

    &printToLog("Reseller '$reseller' is started");

    #$objDumpStatus->{'ACCOUNT'}->($reseller);
    #$objDumpStatus->{'PRINT'}->();

    #make reseller node with child account nodess
 #   $item = &makeResellerNode( $reseller, \@{ $resellers_accounts{$reseller} } );

    if ( ref($item) =~ /XmlNode/ ) {
      $resellerNodes{$reseller} = $item;
      &printToLog("Reseller '$reseller' is successfully dumped");
    }
    else {
      &printToLog("Reseller '$reseller' is not dumped");
    }

    #	$domainCount-=$domainCounts{$reseller};
    #	foreach $owner (@{$resellers{$reseller}}) {
    #	  $domainCount-=$domainCounts{$owner};
    #	}

    #$objDumpStatus->{'COUNTS'}->( 0, $domainCount );

  }

#  my $key;
#  my $value;

#ONLY DOMAINS START
#  foreach $key ( keys %resellerNodes ) {
#    $value = $resellerNodes{$key};

    # TODO: test at first do not add itself
#    if ( defined $reseller_owner{$key} ) {
#      $resellerNodes{ $reseller_owner{$key} }->addChild($value, 0);
#    }
#    else {
      #$root->addChild($value, 0);
#    }
#  }
#ONLY DOMAINS END

  &printToLog("Start dumping accounts that belong to root");

  #$objDumpStatus->{'ACCOUNT'}->('[default]');
  #$objDumpStatus->{'PRINT'}->();

  if (@default_reseller_account) {
#ONLY DOMAINS START
#    foreach my $root_owned_account ( sort @default_reseller_account ) {
#ONLY DOMAINS END
   foreach my $root_owned_account ( sort @all_accounts ) {
      $item = &makeAccountNode($root_owned_account);
      if ( ref($item) =~ /XmlNode/ ) {
        $root->addChild($item);
        &printToLog(
          "Client '$root_owned_account' owned by root is successfully dumped"
        );
      }
      else {
        &printToLog(
          "Client '$root_owned_account' owned by root is not dumped");
      }
    }
  }

  #$objDumpStatus->{'ACCOUNT'}->('');
  #$objDumpStatus->{'DOMAIN'}->('');
  #$objDumpStatus->{'COUNTS'}->( 0, 0 );
  #$objDumpStatus->{'PRINT'}->();

  return $root;
}

#
# makeResellerNode
#
#   arguments:
#       $reseller - name of rteseller
#       $ptrAccounts - pointer to array of accounts
#
sub makeResellerNode {
  my ( $reseller, $ptrAccounts ) = @_;

  my ( $account, $item, $ptrUserHash, $fileParser );

  my $root = XmlNode->new('reseller');
  $root->setAttribute( 'name', $reseller );

  if ($reseller) {

    $fileParser = &makeFileParser("$installDir/users/$reseller");
    $ptrUserHash = $fileParser->{'PARSE'}->( 'KEYSEPARATOR' => '=' );

    my ( $ptrHash, $value, $key, $xmlKey, $userKey );
    $ptrHash = $ptrResellerInfo->{$reseller};

    if ( ref($ptrHash) =~ /HASH/ ) {

      #
      # limits
      #
      $value = $ptrHash->{'limits-bynumber'};
      if ($value) {
        $root->addChild( &makeLimitNode( 'max_accounts', $value ) );
      }
      if ( exists $ptrHash->{ $ptrHash->{'resource-limits'} } ) {
        ( $key, $ptrHash ) = @{ $ptrHash->{'resource-limits'} };
      }

      if ($key) {
        $value = $ptrHash->{'bw'};
        if ( $value =~ /(\d+)/ ) {
          $value = $1 * 1024 * 1024;
          $root->addChild( &makeLimitNode( 'max_traffic', $value ) );
        }
        $value = $ptrHash->{'disk'};
        if ( $value =~ /(\d+)/ ) {
          $value = $1 * 1024 * 1024;
          $root->addChild( &makeLimitNode( 'disk_space', $value ) );
        }
      }
    }

    while ( ( $xmlKey, $userKey ) = each(%mapLimits) ) {
      $value = $ptrUserHash->{$userKey};
      if ( $value =~ /\d+/ ) {
        $root->addChild( &makeLimitNode( $xmlKey, $value ) );
      }
      else {
        $root->addChild( &makeLimitNode($xmlKey) );
      }
    }
    #
    # end limits
    #

    #
    # permissions
    #
    $ptrHash = $ptrRowResellers->{$reseller};
    if ( ref($ptrHash) =~ /HASH/ ) {
      if ( exists $ptrHash->{'create-acct'} ) {
        $root->addChild( &makePermissionNode('create_accounts') );
      }
      if ( exists $ptrHash->{'create-dns'} ) {
        $root->addChild( &makePermissionNode('create_domains') );
      }
      if ( exists $ptrHash->{'edit-dns'} ) {
        $root->addChild( &makePermissionNode('manage_dns') );
      }

    }
    #
    # end permissions
    #

    if ( ref($ptrUserHash) =~ /HASH/ ) {
      makeFeaturesNode( $root, $ptrUserHash->{'FEATURELIST'} )
        if exists $ptrUserHash->{'FEATURELIST'};
    }

    $item = &makeAccountNode( $reseller, $ptrUserHash, 'is reseller' );
    $root->addChild($item);

  }

  foreach $account ( sort @{$ptrAccounts} ) {
    $item = &makeAccountNode( $account );
    $root->addChild($item);
  }

  return $root;
}

sub getAccountName {
  my $domain = shift;

  unless ( keys %trueDomainAccounts ) {
		# initialize %trueDomainAccounts
  }

  return trueDomainAccounts{ $domain } ;
}



sub getDomainName {
  my $account = shift;

  unless ( keys %trueUserDomains ) {

    #
    # calculate $ptrTrueUserDomainsHash
    #
    my $fileParser = &makeFileParser('/etc/trueuserdomains');
    my $ptrHash = $fileParser->{'PARSE'}->( 'KEYSEPARATOR' => ':' );
    if ( ref($ptrHash) =~ /HASH/ ) {
      %trueUserDomains = ( %{$ptrHash} );
    }
  }

  my ( $domain, $owner );
  while ( ( $domain, $owner ) = each %trueUserDomains ) {
    if ( $owner eq $account ) {
      return $domain;
    }
  }
  return undef;
}

sub getDomainOwner {
  my $domain = shift;
  unless ( keys %trueUserDomains ) {

    #
    # calculate $ptrTrueUserDomainsHash
    #
    my $fileParser = &makeFileParser('/etc/trueuserdomains');
    my $ptrHash = $fileParser->{'PARSE'}->( 'KEYSEPARATOR' => ':' );
    if ( ref($ptrHash) =~ /HASH/ ) {
      %trueUserDomains = ( %{$ptrHash} );
    }
  }

  return $trueUserDomains{$domain};

}

sub epoch2CrDate {
  my $epoch = shift;
  unless ( $epoch ) {
    return "1970-01-01";
  }
  my ($mday, $mon, $year) = (localtime($epoch)) [3 .. 5];
  return sprintf("%04D-%02D-%02D", $year+1900, $mon+1, $mday);
}

sub makeAccountNode {

  my ( $account, $ptrUserHash, $isReseller, $shallowMode ) = @_;

  my (
    $ptrLines, $ptrHash, $ptrQuota, $xmlKey, $userKey,
    $value,    $key,     $domain,   $item
  );

  unless ($shallowMode) {
    if ( exists $accountNodes{ $account } ) {
      return $accountNodes{ $account };
    }
  }

  my $home = getHomeDir($account);

  my $root = XmlNode->new('account');
  $root->setAttribute( 'name', $account );

  unless ($shallowMode) {
    if ( -T "$home/.contactemail" ) {

      my $fileParser = makeFileParser("$home/.contactemail");
      $ptrLines = $fileParser->{'PARSE'}->();
      if ( ref($ptrLines) =~ /ARRAY/ ) {
        $root->setAttribute( 'email', $ptrLines->[0] || '' );
      }

    }
    else {
      $root->setAttribute( 'email', '' );
    }
  }

  unless ( ref($ptrUserHash) =~ /HASH/ ) {
    my $fileParser = makeFileParser("$installDir/users/$account");
    $ptrUserHash = $fileParser->{'PARSE'}->( 'KEYSEPARATOR' => '=' );
  }

  unless ($shallowMode) {
    if ( ref($ptrUserHash) =~ /HASH/ ) {
      $root->setAttribute( 'date', epoch2CrDate( $ptrUserHash->{'STARTDATE'} ) );
    }

    unless ($isReseller) {
      my $diskSpace = $ptrQuota->{$account};
      if ( $diskSpace =~ /(\d+)/ ) {
        $diskSpace = $1 * 1024 * 1024;
        $root->addChild(&makeLimitNode('disk_space', $diskSpace));
      }

      if ( ref($ptrUserHash) =~ /HASH/ ) {
        # handle limits
        $mapLimits{'max_traffic'} = 'BWLIMIT';
        while ( ( $xmlKey, $userKey ) = each(%mapLimits) ) {
          $value = $ptrUserHash->{$userKey};
          if ( $value =~ /\d+/ ) {
            $root->addChild(&makeLimitNode($xmlKey, $value));
          }
          else {
            $root->addChild(&makeLimitNode($xmlKey));
          }
        }

        delete $mapLimits{'max_traffic'};    ## clean map
      }
    }
    if ( ref($ptrUserHash) =~ /HASH/ ) {
      makeFeaturesNode( $root, $ptrUserHash->{'FEATURELIST'} ) if exists $ptrUserHash->{'FEATURELIST'};
    }

    # SpamAssssin migration
    makeSpamassassinNode( $root, $home );
  }

  #
  # Handle domain
  #
  $domain = &getDomainName($account);

  if ($domain) {

    Logging::info("Domain '$domain' is started");

    #$objDumpStatus->{'DOMAIN'}->($domain);
    #$objDumpStatus->{'PRINT'}->();
    $item = &makeIpNode( $domain, $ptrUserHash );

    $root->addChild($item);

    $item = &makeDomainNode( $domain, $account, $shallowMode );
    $root->addChild($item);

    Logging::info("Domain '$domain' is dumped");
  }

  unless ($shallowMode) {
    $accountNodes{$account} = $root;
  }

  return $root;
}

sub makeFeaturesNode {
  my ( $root, $feature ) = @_;

  if ( exists $featureList{$feature} ) {
    my $fvalues = $featureList{$feature};
    foreach my $fkey ( keys %mapFeatures ) {
      if ( 2 == $mapFeatures{$fkey} and exists ${$fvalues}{$fkey} ) {
        my $fnode = XmlNode->new( 'feature' );
        $fnode->setAttribute( 'name', $fkey );
        if ( ${$fvalues}{$fkey} ) {
          $fnode->setAttribute( 'allowed', 'true' );
        }
        else {
          $fnode->setAttribute( 'allowed', 'false' );
        }
        $root->addChild($fnode);
      }
    }
  }
  else { printToLog("Cannot get featureList '$feature'"); }
}

sub makeIpNode {
  my ( $domain, $ptrUserHash ) = @_;

  my ( $ptrRows, $ip, $item, $ptrRow, $dmn );

  unless ( $ip = $servers_ips{$domain} ) {
    my $fileParser = makeFileParser("$installDir/accts.db");
    $ptrRows = $fileParser->{'PARSE'}->( 'VALUESEPARATOR' => ',' );
    foreach $ptrRow ( @{$ptrRows} ) {
      $dmn = $ptrRow->[0];
      $dmn =~ s/^\s+//;
      $dmn =~ s/\s+$//;
      if ( $ptrRow->[2] =~ /(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/ ) {
        $ip = $1;
        unless ( exists( $servers_ips{$domain} ) ) {
          $servers_ips{$domain} = $ip;
        }
      }
    }
    unless ( $ip = $servers_ips{$domain} ) {
      unless ( $ip = $ptrUserHash->{'IP'} ) {
        my $zone = "/var/named/$domain.db";
        my $pattern =
          qr/^\Q$domain\E\.\s+(?:\d+\w?\s+)IN\s+A\s+(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/;
        if ( -T $zone ) {
          if ( open( INPUT, "<$zone" ) ) {
            binmode INPUT;
            while (<INPUT>) {
              if (/$pattern/) {
                $ip = $1;
                last;
              }
            }
            close(INPUT);
            if ($ip) {
              $servers_ips{$domain} = $ip;
            }
          }
        }
      }
    }
  }
  unless ( $ip ) {
    $ip = getMainIP();
  }
  $item = XmlNode->new( 'ip' );
  $item->setText( $ip );

  return $item;
}

sub makeDomainNode {
  my ( $domain, $account, $shallowMode ) = @_;

  my $root = XmlNode->new('domain');
  $root->setAttribute( 'name', $domain );

  my (
    @subdomains, @ftpusersdirs,   $subdomain, $acc,
    $ptrRows,    $ptrRow,         $path,      @dirs,
    $dir,        @subdompatterns, @exclude,   $dumpFile,
    $item,       $ptrProftpdRows
  );

  my $home = getHomeDir($account);

  #
  # subdomain dirs
  #
  unless ( ref($ptrUserdomainsHash) =~ /HASH/ ) {
    my $fileParser = makeFileParser('/etc/userdomains');
    $ptrUserdomainsHash = $fileParser->{'PARSE'}->( 'KEYSEPARATOR' => ':' );
  }
  if ( ref($ptrUserdomainsHash) =~ /HASH/ ) {
    my $pattern = qr/^(.+)\.\Q$domain\E$/;
    while ( ( $subdomain, $acc ) = each %{$ptrUserdomainsHash} ) {
      next unless ( $acc eq $account );
      if ( $subdomain =~ /$pattern/ ) {
        $dir = $1;
        push @subdomains,     $dir;
        push @subdompatterns, qr/^\Q$dir\E(?:\/.*)?/;
      }
    }
  }
  #
  # end subdomain dirs
  #

  #
  # ftp dirs
  #
  if ( -T "/etc/proftpd/$account" ) {
    my $fileParser = makeFileParser("/etc/proftpd/$account");
    $ptrProftpdRows = $fileParser->{'PARSE'}->(
      'VALUESEPARATOR' => ':',
      'KEYSEPARATOR'   => '',
    );
    if ( ref($ptrProftpdRows) =~ /ARRAY/ ) {
      my ( $subdompattern, $pattern, $is_subdomain_directory );
      $pattern = qr/\Q$home\E\/public_html\/(.*)/;
      foreach $ptrRow ( @{$ptrProftpdRows} ) {
        next unless ( $ptrRow->[4] eq $account );
        $path = $ptrRow->[5];
        if ( $path =~ /$pattern/ ) {
          $dir                    = $1;
          $is_subdomain_directory = 0;
          foreach $subdompattern (@subdompatterns) {
            if ( $dir =~ /$subdompattern/ ) {
              $is_subdomain_directory = 1;
              last;
            }
          }
          next if ($is_subdomain_directory);
          push( @ftpusersdirs, $dir );
        }
      }
    }
  }
  @subdompatterns = ();
  #
  # end ftp dirs
  #

  #
  # content of domain
  #
#  if ( -d "$home/cgi-bin" ) {
#    @exclude = ('cgi-bin');
#  }
#  else {
#    @exclude  = ();
#    $dumpFile = &makeDumpFile( "$dumpDir/cgi_domain_$account", "$home/public_html/cgi-bin" );
#    $root->setAttribute( 'cid_cgi', $dumpFile ) if $dumpFile;
#  }
#  push @exclude, @subdomains, @ftpusersdirs;
#  $dumpFile = &makeDumpFile( "$dumpDir/docroot_domain_$account", "$home/public_html", ['.'], \@exclude );
#  $root->setAttribute( 'cid_docroot', $dumpFile ) if $dumpFile;
  #
  # end content of domain
  #

  unless ($shallowMode) {
    if ( $item = &makeAnonFtpdNode($account) ) {
      $root->addChild($item);
    }
  }

  &addFtpUserNodes($root, $domain, $account, \@subdomains, \@ftpusersdirs, $ptrProftpdRows);

  #if ($noContent) {
  #  return $root;
  #}

  unless ($shallowMode) {
    &addProtectedDirs($root, $domain, $account,	\@subdomains);
  }

  &addSubDomains($root, $domain, $account, \@subdomains, $shallowMode);

  &addAddOnDomains($root, $domain, $account);

  unless ($shallowMode) {
    &addMailNode($root, $domain, $account);

    &addDatabases($root, $account);

    &addMailLists($root, $domain, $account);
  }

  return $root;
}

sub addMailLists {
  my ( $root, $domain, $account ) = @_;

  unless ( defined Mailman::version() ) {
    printToLog("Unable to found Mailman installation. Skip dumping maillists.");
    return;
  }

  printToLog("Get maillists of '$domain'");
  my $maillists = XmlNode->new( 'maillists' );

  my @lists = Mailman::getMailLists($domain);
  foreach my $listname (@lists) {
    printToLog("Found maillist '$listname'");
    my @owners = Mailman::getListOwners($listname);
    if (@owners) {
      my $reallistname = $listname;
      $reallistname =~ s/(.*)(_$domain)/$1/;
      my $maillist = XmlNode->new( 'maillist' );
      $maillist->setAttribute( 'name', $reallistname );
      for my $listOwner (@owners) {
      	my $owner_node = XmlNode->new( 'owner' );
      	$owner_node->setText( $listOwner );
        $maillist->addChild($owner_node);
      }
      $maillist->addChild( makePasswordNode( Mailman::getListPassword($listname) , 'encrypted' ));

      my %listMembers = Mailman::getListMembers($listname);
      for my $memberEmail ( keys %listMembers ) {
        my $member = XmlNode->new( 'recipient' );
        $member->setText( $memberEmail );
        if ( $listMembers{$memberEmail} ne "" ) {
          $member->setAttribute( 'fullname', $listMembers{$memberEmail} );
        }
        $maillist->addChild($member);
      }

#      my $archDir = Mailman::getMailListArchiveDir($listname);
#      if ($archDir) {
#        if (
#          my $dumpFile = makeDumpFile(
#            "$archDir/maillist_$listname\@$domain", $archDir,
#            Mailman::getMailListArchiveFiles($listname)
#          )
#          )
#        {
#          $maillist->setAttribute( 'cid', $dumpFile );
#        }
#      }

      $maillists->addChild($maillist);

    }
    else {
      printToLog("Bad maillist '$listname', cannot find owner, skipped");
    }

  $root->addChild($maillists);

  }

}

sub addDatabases {
  my ( $root, $account ) = @_;
  addMySQLDatabases( $root, $account );
  addPgSQLDatabases( $root, $account );
}

sub addMySQLDatabases {
  my ( $root, $account ) = @_;

  my ( $ptrRow, $database, $item, $dumpFile, $sql, @dbNames );

  unless ( ( ref($wrapUserMysql) =~ /HASH/ )
    && ( ref( $wrapUserMysql->{'EXECUTE'} ) =~ /CODE/ ) )
  {

    $wrapUserMysql =
      getDbConnect( 'mysql', 'root', undef, 'mysql', 'localhost' );
  }

  my $datadir;
  $sql = "SHOW variables LIKE 'datadir'";
  if (  $wrapUserMysql->{'EXECUTE'}->($sql)
    and $ptrRow = $wrapUserMysql->{'FETCHROW'}->() )
  {
    $datadir = $ptrRow->[1];
  }
  $wrapUserMysql->{'FINISH'}->();

  $sql =
      "SELECT DISTINCT db FROM db WHERE db like '"
    . $account
    . "\_%' or db like '"
    . $account
    . "\\\_%'";
  if ( $wrapUserMysql->{'EXECUTE'}->($sql) ) {
    while ( $ptrRow = $wrapUserMysql->{'FETCHROW'}->() ) {
      push @dbNames, $ptrRow->[0];
    }
  }
  $wrapUserMysql->{'FINISH'}->();

  foreach $database (@dbNames) {
    $database =~ s/\\_/_/g;
    next unless -d $datadir . $database;
    $item = XmlNode->new('database');
    $item->setAttribute( 'name',    $database );
    $item->setAttribute( 'type',    'mysql' );
    $item->setAttribute( 'version', Db::MysqlUtils::getVersion() );

    printToLog("Started $database dumping...");

#    if ( $dumpFile = &makeDumpDb( $database, 'mysql', 'root' ) ) {
#      $item->setAttribute( 'cid', $dumpFile );
#    }

    addDbUsers( $item, $database, $wrapUserMysql );

    $root->addChild($item);

    printToLog("done");
  }
}

sub addPgSQLDatabases {
  my ( $root, $account ) = @_;

  my ( $ptrRow, $database, $item, $dumpFile, $sql, @dbNames, %dbUsers );

  #if ($donotMigratePostgresql) {
  #  printToLog("Postgresql database migration disabled by user settings");
  #  return;
  #}

  if ( !AgentConfig::psqlBin() ) {
    Logging::warning("Unable to find psql");
    return;
  }
  $Db::Connection::UsePostgreShellBackendAsSudo = 1;

  my $wrapUserPgsql =
    getDbConnect( 'postgresql', 'postgres', undef, 'template1', 'localhost' );
  if ( ref($wrapUserPgsql) eq 'HASH' ) {
    if (  ref( $wrapUserPgsql->{'EXECUTE'} ) eq 'CODE'
      and ref( $wrapUserPgsql->{'FETCHROW'} ) eq 'CODE'
      and ref( $wrapUserPgsql->{'FINISH'} )   eq 'CODE' )
    {
      if (
        $wrapUserPgsql->{'EXECUTE'}->(
          "select datname from pg_database where datname like '$account\_\_%'"
        )
        )
      {
        while ( $ptrRow = $wrapUserPgsql->{'FETCHROW'}->() ) {
          printToLog( "Found database: " . $ptrRow->[0] );
          push @dbNames, $ptrRow->[0];
        }
        $wrapUserPgsql->{'FINISH'}->();
        if (
          $wrapUserPgsql->{'EXECUTE'}->(
            "select usename, passwd from pg_shadow where usename like '$account\_\_%'"
          )
          )
        {
          while ( $ptrRow = $wrapUserPgsql->{'FETCHROW'}->() ) {
            printToLog( "Found database user: " . $ptrRow->[0] );
            $dbUsers{ $ptrRow->[0] } = $ptrRow->[1];
          }
          $wrapUserPgsql->{'FINISH'}->();
        }
      }
    }
    else { printToLog("Connection to postgresql is not valid"); }
  }
  else { printToLog("Cannot connect to postgresql"); }

  my $psql = AgentConfig::psqlBin();

  my @out     = `$psql --version | awk '{print \$3}'`;
  my $version = '';
  chomp $out[0];
  if ( $out[0] =~ /(\d+\.\d+\.\d+).*/ ) {
    $version = $1;
  }

  foreach $database (@dbNames) {
    $item = XmlNode->new('database');
    $item->setAttribute( 'name',    $database );
    $item->setAttribute( 'type',    'postgresql' );
    $item->setAttribute( 'version', $version );

    printToLog("Started $database dumping...");

    printToLog("Started $database user dumping...");
    if ( $wrapUserPgsql->{'EXECUTE'}
      ->("select datacl from pg_database where datname='$database'") )
    {
      while ( $ptrRow = $wrapUserPgsql->{'FETCHROW'}->() ) {
        printToLog( "Parse DACL: " . $ptrRow->[0] );
        my @usernames = keys(%dbUsers);
        my $uname;
        foreach $uname (@usernames) {
          if ( $ptrRow->[0] =~ m/.*$uname\=.*/m ) {
            printToLog("User '$uname' granted to '$database");
            my $useritem = XmlNode->new( 'dbuser' );
            $useritem->setAttribute( 'name', $uname );
            my $pwditem = makePasswordNode( $dbUsers{$uname}, 'encrypted' );
            if ($pwditem) {
              $useritem->addChild($pwditem);
            }
            $item->addChild($useritem);
          }
        }
      }
      $wrapUserPgsql->{'FINISH'}->();
    }
    printToLog("$database user dumping done");

#    if ( $dumpFile = &makeDumpDb( $database, 'postgresql', 'postgres' ) ) {
#      $item->setAttribute( 'cid', $dumpFile );
#    }

    $root->addChild($item);

    printToLog("done");
  }

}

sub addSubDomains {

  my ( $root, $domain, $account, $ptrSubDomains, $shallowMode ) = @_;

  my (
    $nodeSubDomain, $subdomain,  $dumpFile,
    $subdomainRoot, $fileParser, $ptrRows,
    $ptrRow,        $item,       @exclude
  );

  my $home = getHomeDir($account);

  foreach $subdomain ( @{$ptrSubDomains} ) {

    &printToLog( "Subdomain '$subdomain.$domain' ...", 1 );

    $subdomainRoot = "$home/public_html/$subdomain";

    $nodeSubDomain = XmlNode->new('subdomain');
    $nodeSubDomain->setAttribute( 'name', $subdomain, 'noencode' );
    $root->addChild($nodeSubDomain);

    unless ($shallowMode) {#
      # content
      #
#      if ( -d "$subdomainRoot/cgi-bin" ) {
#        if ( $dumpFile = &makeDumpFile(
#             "$dumpDir/cgi_subdomain_$subdomain.$domain", $subdomainRoot, 'cgi-bin') ) {
#          $nodeSubDomain->setAttribute( 'cid_cgi', $dumpFile );
#        }
#        @exclude = ('cgi-bin');
#      }
#      else {
#        @exclude = ();
#      }
#
#      if ( $dumpFile = &makeDumpFile(
#           "$dumpDir/docroot_subdomain_$subdomain.$domain", $subdomainRoot, ['.'], \@exclude) ) {
#        $nodeSubDomain->setAttribute( 'cid_docroot', $dumpFile );
#      }
    }
    #
    # ftp user
    #
    my $ftp_accounts_file = "/etc/proftpd/$account";
    if ( -T $ftp_accounts_file ) {
      $fileParser = &makeFileParser($ftp_accounts_file);
      $ptrRows = $fileParser->{'PARSE'}->( 'VALUESEPARATOR' => ':' );
      if ( ref($ptrRows) =~ /ARRAY/ ) {
        foreach $ptrRow ( @{$ptrRows} ) {
          if ( ( $ptrRow->[0] eq $subdomain )
            && ( $ptrRow->[4] eq $account ) )
          {
            if ( $ptrRow->[1] ) {
              $item = &makeFtpUserNode( $subdomain, $ptrRow->[1], undef );
              $nodeSubDomain->addChild($item);
            }
            last;
          }
        }
      }
    }

    # Dump mail system and addon domains: if there is 1 addon domain for
    # given subdomain - dump mail system of ADDON DOMAIN, not subdomain.
    # This case reflects common usage of addon domains in cPanel...
    {
      my $maildomain = "$subdomain.$domain";

      my @addondomains = addAddOnDomains( $nodeSubDomain, "$subdomain.$domain", $account );
      if ( 0 == $#addondomains ) {
        $maildomain = pop @addondomains;
      }

      unless ($shallowMode) {
        addMailNode( $nodeSubDomain, $maildomain, $account );
      }
    }
    &printToLog(' OK');
  }
}

my %apacheAliases = ();

###
# Returns array of addon domain names that has been added.
#
# @return array
###
sub addAddOnDomains {
  my ( $root, $domain, $account ) = @_;
  my ( $userdomain, $owner, %userdomains, $maindomain, %aliases, $alias, $item, @found );

  unless ( keys %apacheAliases ) {
    my $httpdconf_file = "/etc/httpd/conf/httpd.conf";
    unless ( open( INPUT, "<$httpdconf_file") ) {
      &printToError("Error: unable to open '$httpdconf_file': $!");
      return ();
    }
    binmode INPUT;
    my ( $state, $vserver, %valiases );
    $state = 0;
    while (<INPUT>) {
      chomp;
      if ( $state == 1 ) {
        if (/^\s*<\/VirtualHost\s*>/) {
          if ( $vserver && ( keys %valiases ) ) {
            push @{ $apacheAliases{$vserver} }, keys %valiases;
          }
          $vserver  = '';
          %valiases = ();
          $state    = 0;
        }
        elsif (/^\s*ServerName\s+(\S+)/) {
          $vserver = $1;
          $vserver =~ s/^www\.//;
        }
        elsif (/^\s*ServerAlias\s+(.*)/) {
          map { s/^www\.//; $valiases{$_} = 1 } split( ' ', $1 );
        }
      }
      else {
        if (/^\s*<VirtualHost\s.*>/) {
          $state    = 1;
          $vserver  = '';
          %valiases = ();
        }
      }
    }
    close(INPUT);
  }
  unless ( exists $apacheAliases{$domain} ) {
    return ();
  }
  unless ( ref($ptrUserdomainsHash) =~ /HASH/ ) {
    my $fileParser = &makeFileParser('/etc/userdomains');
    $ptrUserdomainsHash = $fileParser->{'PARSE'}->( 'KEYSEPARATOR' => ':' );
  }

  $maindomain = &getDomainName($account);

  if ( ref($ptrUserdomainsHash) =~ /HASH/ ) {
    my $pattern = qr/\Q$maindomain\E$/;
    while ( ( $userdomain, $owner ) = each( %{$ptrUserdomainsHash} ) ) {
      next unless $owner eq $account;
      next if ( $userdomain =~ /$pattern/ );    ## exclude subdomains
      $userdomains{$userdomain} = 1;
    }
  }

  %aliases = map { $_ => 1 } @{ $apacheAliases{$domain} };
  foreach $alias ( keys %aliases ) {
    next unless exists $userdomains{$alias};
    $item = XmlNode->new( 'addondomain' );
    $item->setText( $alias );
    $root->addChild($item);
    push @found, $alias;
  }

  return @found;
}

sub addMailNode {
  my ( $root, $domain, $account ) = @_;
  my (
    $mailNode,   $ptrRows, $ptrRow, $default,  $item,
    $box,        $ptrHash, $value,  $password, $dumpFile,
    $ptrAliases, $src,     $dst,    $from
  );
  my $home = getHomeDir($account);

  printToLog("Mail for $domain migration started...");
  $mailNode   = XmlNode->new('mail');
  $ptrAliases = [];
  if ( -T "/etc/valiases/$domain" ) {
    my $fileParser = &makeFileParser("/etc/valiases/$domain");
    $ptrAliases = $fileParser->{'PARSE'}->( 'VALUESEPARATOR' => ':' );
    if ( ref($ptrAliases) =~ /ARRAY/ ) {
      foreach $ptrRow ( @{$ptrAliases} ) {
        if ( $ptrRow->[0] eq '*' ) {
          if ( $ptrRow->[1] =~ /\s*([^@]+\@[^@+]+)\s*/ ) {
            $default = $1;
            last;
          }
          elsif ( $ptrRow->[2] =~ /blackhole/ ) {
            $default = ':blackhole:';
            last;
          }
          elsif ( $ptrRow->[2] =~ /fail/ ) {
            $default = ':fail:' . $ptrRow->[3];
            last;
          }
        }
      }
    }
  }

  if ($default) {
    $item = XmlNode->new('default');
    if ( $default eq ':blackhole:' ) {
      $item->setAttribute( 'target', 'ignore' );
    }
    elsif ( $default =~ /:fail:(.*)/ ) {
      $item->setAttribute( 'target', 'fail' );
      $item->setText($1);
    }
    else {
      $item->setAttribute( 'target', 'email' );
      $item->setText($default);
    }
    $mailNode->addChild($item);
  }

  printToLog("Examining $home/etc/$domain");

  if ( -d "$home/etc/$domain" && -T "$home/etc/$domain/passwd" ) {
    my $fileParser = makeFileParser("$home/etc/$domain/passwd");
    $ptrRows = $fileParser->{'PARSE'}->( 'VALUESEPARATOR' => ':' );

    if ( ref($ptrRows) =~ /ARRAY/ ) {
      foreach $ptrRow ( @{$ptrRows} ) {
        $box  = $ptrRow->[0];
        $item = XmlNode->new('mailname');
        $item->setAttribute( 'name', $box );

        printToLog( "migrating " . $box . "@" . "$domain" );

        #
        # password
        #
        $password = '';
        my $shadowParser = makeFileParser("$home/etc/$domain/shadow");
        $ptrHash = $shadowParser->{'PARSE'}->(
          'KEYSEPARATOR'   => ':',
          'VALUESEPARATOR' => ''
        );

        if ( ref($ptrHash) =~ /HASH/ ) {
          if ( $value = $ptrHash->{$box} ) {
            ($password) = split( ':', $value );
          }
        }
        $item->setAttribute( 'password', $password );
        #
        # end password
        #

        #
        # quota
        #
        if ( -T "$home/etc/$domain/quota" ) {
          my $quotaParser = makeFileParser("$home/etc/$domain/quota");
          $ptrHash =
            $quotaParser->{'PARSE'}->( 'KEYSEPARATOR' => ':', 'VALUESEPARATOR' => '' );
          if ( ref($ptrHash) =~ /HASH/ && ( $value = $ptrHash->{$box} ) ) {
            $item->setAttribute( 'quota', sprintf( "%.0f", $value ) );
          }
        }
        #
        # end quota
        #
#        if ( $dumpFile = makeDumpFile("$dumpDir/mailname_$box.$domain", "$home/mail/$domain/$box" ) ) {
#          $item->setAttribute( 'cid', $dumpFile );
#        }

				# SpamAssssin migration
				# Cannot dump individual mailuser spamassassin settings
        # makeSpamassassinNode( $item, "$home/etc/$domain/$box" );

        $mailNode->addChild($item);
      }
    }
  }
  if ( @{$ptrAliases} ) {
    addForwarders( $mailNode, $ptrAliases );
    addAutoresponders( $mailNode, $account, $ptrAliases );
  }

  $root->addChild($mailNode);
  printToLog("Mail for $domain migration finished...");
}

sub makeSpamassassinNode {
  my ( $root, $home ) = @_;

  return unless -e "$home/.spamassassin";

  my $saEnabled = 'off';
  $saEnabled = 'on' if -e "$home/.spamassassinenable";

  my $sanode = XmlNode->new('spamassassin');
  $sanode->setAttribute( 'status', $saEnabled );

  $root->addChild($sanode);

  return unless -e "$home/.spamassassin/user_prefs";

  my $saConfig =
    SpamAssassinCfg::parseConfig( "$home/.spamassassin/user_prefs", $home );

  my $cfgvalues = SpamAssassinCfg::getConfigRequireScore($saConfig);
  $sanode->setAttribute( 'hits', $cfgvalues ) if $cfgvalues;

  $cfgvalues = SpamAssassinCfg::getConfigRewriteHeadr($saConfig);
  if ($cfgvalues) {
    if ( scalar( @{$cfgvalues} ) == 2 ) {
      $sanode->setAttribute( 'subj-text', ${$cfgvalues}[1] )
        if ${$cfgvalues}[0] eq 'subject';
    }
    $sanode->setAttribute( 'action', 'mark' );
  }

  $cfgvalues = SpamAssassinCfg::getConfigBlackList($saConfig);
  makeSpamassassinLists( $sanode, $cfgvalues, 'blacklist-member' );

  $cfgvalues = SpamAssassinCfg::getConfigWhiteList($saConfig);
  makeSpamassassinLists( $sanode, $cfgvalues, 'whitelist-member' );

  $cfgvalues = SpamAssassinCfg::getConfigUnBlackList($saConfig);
  makeSpamassassinLists( $sanode, $cfgvalues, 'unblacklist-member' );

  $cfgvalues = SpamAssassinCfg::getConfigUnWhiteList($saConfig);
  makeSpamassassinLists( $sanode, $cfgvalues, 'unwhitelist-member' );

}

sub makeSpamassassinLists {
  my ( $root, $cfgvalues, $listname ) = @_;
  return unless defined $cfgvalues;

  foreach my $item ( @{$cfgvalues} ) {
    if ($item) {
      my $list_name_node = XmlNode->new( $listname );
      $list_name_node->setText( $item );
      $root->addChild( $list_name_node );
    }
  }
}

sub addAutoresponders {
  my ( $mailNode, $account, $ptrAliases ) = @_;
  my $home = getHomeDir($account);

  foreach my $ptrRow ( @{$ptrAliases} ) {

    my $src = $ptrRow->[0];
    my $dst = $ptrRow->[1];
    chomp $src;

    next unless ( $dst =~ /^\s*\|.*\/cpanel\/bin\/autorespond/ );
    next unless ( $src =~ /^([^@]+@[^@]+)$/ );
    next unless ( open( INPUT, "<$home/.autorespond/$src" ) );
    binmode INPUT;

    my $autoresponderNode = XmlNode->new('autoresponder');
    $src =~ /^([^@]+)@/;
    $autoresponderNode->setAttribute( 'mailname', $1 );

    while (<INPUT>) {
      chomp;
      last unless $_;

      if (/^From:.+<(.+)>/) {
        $autoresponderNode->setAttribute( 'from', $1 ) if ( $src ne $1 );
      }
      elsif (/^Content-type:\s+text\/([^;]+);\s+charset=(.+)/) {
        $autoresponderNode->setAttribute( 'type',    $1 );
        $autoresponderNode->setAttribute( 'charset', $2 );
      }
      elsif (/^Subject:\s*(.*)/) {
        $autoresponderNode->setAttribute( 'subject', $wrapBase64->{'ENCODE'}->($1) );
      }
    }

    $autoresponderNode->setText( $wrapBase64->{'ENCODE'}->( join( '', (<INPUT>) ) ) );
    close(INPUT);

    $mailNode->addChild($autoresponderNode);
  }
}

sub addForwarders {
  my ( $mailNode, $ptrAliases ) = @_;

  foreach my $ptrRow ( @{$ptrAliases} ) {

    my $src = $ptrRow->[0];
    my $dst = $ptrRow->[1];

    next unless ( $src =~ /^([^@]+)@[^@]+$/ );
    $src = $1;

    $dst =~ s/^\s+//;
    $dst =~ s/\s+$//;
    next if ( $dst =~ /^['"]?\|/ );    # autoresponder

    foreach my $email ( split /,/, $dst ) {
      next unless ( $email =~ /[^@]+@[^@]+/ );
      my $forwardNode = XmlNode->new('forward');
      $forwardNode->setAttribute( 'mailname', $src );
      $forwardNode->setAttribute( 'redirect', $email );
      $mailNode->addChild($forwardNode);
    }
  }
}

sub addProtectedDirs {

  my ( $root, $domain, $account, $ptrSubDomains ) = @_;

  my (
    $cmd,   $exclude, $pdir,     $find, $item,
    $title, $ptrHash, $nodePdir, $name, $password
  );

  my $home    = getHomeDir($account);
  my $rootDir = "$home/.htpasswds";
  unless ( -d $rootDir ) {
    return;
  }

  $find = AgentConfig::findBin();
  $cmd  = " cd $rootDir; $find . ";
  if ( @{$ptrSubDomains} ) {
    $exclude = join( ' -o ', map {"-path './$_' -prune"} @{$ptrSubDomains} );
    $cmd .= "\\( $exclude \\) -o";
  }
  $cmd .= " \\( -type f -name passwd -printf '\%h\\n' \\)";
  foreach $pdir (`$cmd`) {
    chomp $pdir;
    $pdir =~ s/^\.\///;
    $nodePdir = XmlNode->new('pdir');
    $nodePdir->setAttribute( 'name', $pdir );

    $title = '';
    my $htaccess_file = "$home/public_html/$pdir/.htaccess";
    if ( -T $htaccess_file ) {
      my $fileParser = makeFileParser($htaccess_file);
      $ptrHash = $fileParser->{'PARSE'}->();

      if ( ref($ptrHash) =~ /HASH/ ) {
        if ( exists( $ptrHash->{'AuthName'} ) ) {
          if ( $ptrHash->{'AuthName'} =~ /"([^"]+)"/ ) {
            $title = $1;
          }
        }
      }
    }
    $nodePdir->setAttribute( 'title', $title );

    my $fileParser = makeFileParser("$rootDir/$pdir/passwd");
    $ptrHash = $fileParser->{'PARSE'}->( 'KEYSEPARATOR' => ':' );
    if ( ref($ptrHash) =~ /HASH/ ) {
      while ( ( $name, $password ) = each( %{$ptrHash} ) ) {
        $item = XmlNode->new('pduser');
        $name =~ s/ /_/;
        $item->setAttribute( 'name', $name );
        if ( $password !~ /^[\x20-\x7f]*$/ ) {
          $item->setAttribute( 'password', $wrapBase64->{'ENCODE'}->($password) );
          $item->setAttribute( 'encoding', 'base64' );
        }
        else {
          $item->setAttribute( 'password', $password );
        }
        $nodePdir->addChild($item);
      }
    }

    $root->addChild($nodePdir);
  }
}

sub addFtpUserNodes {
  my ( $root, $domain, $account, $ptrSubDomains, $ptrFtpDirs,
    $ptrProftpdRows ) = @_;

  my ( $password, @users );

  my $home    = getHomeDir($account);
  my $pattern = qr/\Q$home\E\/public_html\/(.*)/;

  my $ftpquota;
  my $ftpquota_file = "$home/etc/ftpquota";
  if ( -e $ftpquota_file ) {
    printToLog("Parse ftp quota '$ftpquota_file'");
    my $ftpquotaParser = makeFileParser($ftpquota_file);
    $ftpquota = $ftpquotaParser->{'PARSE'}->( 'KEYSEPARATOR' => ':' );
    $ftpquota = undef if not ref($ftpquota) =~ /HASH/;
  }

  foreach my $ptrRow ( @{$ptrProftpdRows} ) {

    if ( $ptrRow->[4] eq $account ) {
      if ( $ptrRow->[5] =~ /$pattern/ ) {
        my $subdir = $1;
        my $pass = ( $ptrRow->[1] ne '*' ) ? $ptrRow->[1] : '';

        if ( grep( ( $_ eq $subdir ), @{$ptrFtpDirs} ) ) {
          push @users, [ $ptrRow->[0], $pass, $subdir ];
        }
      }
    }

    if ( !$password && ( $ptrRow->[0] eq $account ) ) {
      $password = $ptrRow->[1];
    }
  }

  if ( '*' eq $password ) {
    $password = getSystemPassword($account);
    if ( '*' eq $password ) {
      $password = '';
    }
  }

  # makes main domains's ftp user node
  $root->addChild( makeFtpUserNode( $account, $password, undef ) );

  # other ftp users of domain
  foreach my $ptrRow (@users) {

    my ( $acc, $pass, $path ) = @{$ptrRow};
    my $quota = '';
    $quota = $ftpquota->{$acc} if $ftpquota and exists $ftpquota->{$acc};
    my $ftpUserNode = makeFtpUserNode( $acc, $pass, $quota );

    if ($path) {
      $ftpUserNode->setAttribute( 'directory', $path );
#      if ( my $dumpFile = makeDumpFile( "$dumpDir/ftpuser_$acc.$account", "$home/public_hmtl/$path") ) {
#        $ftpUserNode->setAttribute( 'cid', $dumpFile );
#      }
    }

    $root->addChild($ftpUserNode);
  }
}

sub makeFtpUserNode {
  my ( $account, $password, $quota ) = @_;
  my $item = XmlNode->new('ftpuser');
  $item->setAttribute( 'name', $account );

  # User may be locked
  if ( $password && $password !~ /^\!/ ) {
    $item->setAttribute( 'password', $password );
  }
  $item->setAttribute( 'quota', $quota ) if $quota;

  return $item;
}

sub makeAnonFtpdNode {
  my $account = shift;
  my ( $node, $publicFtp, $pureFtpd, $dumpFile );
  my $home = getHomeDir($account);

  $publicFtp = "$home/public_ftp";
  unless ( -d $publicFtp ) {
    return undef;
  }
  $node = XmlNode->new('anonftp');

#  if ( $dumpFile = &makeDumpFile("$dumpDir/anonftp_pub_$account", $publicFtp, ['.'], ['incoming']) ) {
#    $node->setAttribute( 'cid', $dumpFile );
#  }
#  if ( $dumpFile = &makeDumpFile("$dumpDir/anonftp_incoming_$account", "$publicFtp/incoming") ) {
#    $node->setAttribute( 'cid_incoming', $dumpFile );
#  }

  #
  # prepare anonftps
  #
  $pureFtpd = '/etc/pure-ftpd';
  if ( -d $pureFtpd ) {
    unless ( keys %anonftps ) {
      my ( $link, $linkTo, $fullPath );
      if ( opendir( FTPD, "$pureFtpd" ) ) {
        foreach $link ( readdir(FTPD) ) {
          $fullPath = "$pureFtpd/$link";
          next unless ( -l $fullPath );
          $linkTo = readlink($fullPath);
          if ( $linkTo =~ /\Qhome\E\/([^\/]+)\/public_ftp/ ) {
            $anonftps{$1} = $linkTo;

          }
        }
        closedir(FTPD);
      }
    }
  }
  #
  # end prepare anonftps
  #

  #
  # check permissions
  #
  # check for read permission
  if ( exists( $anonftps{$account} ) && ( ( stat($publicFtp) )[2] & 05 ) )
  {

    $node->setAttribute( 'pub', 'true' );

    # check for write permission
    if ( ( stat("$publicFtp/incoming") )[2] & 03 ) {

      $node->setAttribute( 'incoming', 'true' );

    }
  }
  #
  # end check permissions
  #

  return $node;
}

sub makePermissionNode {
  my ($name) = @_;
  my $item = XmlNode->new('permission');
  $item->setAttribute( 'name', $name );
  return $item;
}

sub makeLimitNode {
  my ( $name, $value ) = @_;
  unless ( defined($value) && ( $value !~ '/^\s*$/' ) ) {
    $value = '-1';
  }
  my $item = XmlNode->new( 'limit' );
  $item->setAttribute( 'name', $name );
  $item->setText( $value );
  return $item;
}

sub getAgentStatus {
  my $root = XmlNode->new('agent-status');

  unless ( getCpanelVersion() && defined AgentConfig::iconvBin() ) {
    my $item;
    if ( defined AgentConfig::iconvBin() ) {
      $item = XmlNode->new( 'wrong-platform' );
      $item->setText( '' );
    }
    else {
      $item = XmlNode->new( 'wrong-platform' );
      $item->setText( 'no iconv found on the source host' );
    }

    $root->addChild($item);
  }

  return $root;
}

sub getCpanelVersion {
  my ( $engineRoot, $util );
  loadMainConfig();
  if ( $engineRoot = $cPanelConfig{'engineroot'} ) {
    unless ( -d $engineRoot ) {
      return;
    }
    $util = "$engineRoot/cpanel";
    unless ( -x $util ) {
      return;
    }
    my @outs = `$util`;
    foreach my $line (@outs) {
      chomp $line;
      if ( $line =~ /cPanel\s+\[(\d+)\.(\d+).\d+/ ) {
        if ( $1 ne '9' && $1 ne '10' && $1 ne '11' ) {
          return;
        }
        return "$1.$2";
      }
    }
  }
  elsif ( -f "$installDir/cpanel.config" ) {
    return '9';
  }
}

sub getMainIP {
  my $mainip_file = "$installDir/mainip";
  my $ip;
  if ( open( INPUT, "<$mainip_file" ) ) {
    binmode INPUT;
    my $pattern = qr/(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/;
    while (<INPUT>) {
      if (/$pattern/) {
        $ip = $1;
        last;
      }
    }
    close(INPUT);
    if ($ip) {
      return $ip;
    }
  }
}

1;
