import posixpath

from parallels.common.actions.content.web.copy_unix_content_base \
	import CopyUnixWebContentBase
from parallels.utils import obj
from parallels.common.utils import plesk_utils

class CopyUnixWebContent(CopyUnixWebContentBase):
	def _list_files_to_copy(self, global_context, subscription):
		"""Make a list of source server directories to be transferred.

		Return a list of (source directory -> destination directory) mappings
		"""
		vhost_name = subscription.name_idn
		source_vhosts_dir = subscription.web_source_server.vhosts_dir
		
		if subscription.web_source_server.plesk_version >= (11, 5):
			# since 11.5 we have a new virtual host structure: each domain is
			# splitted over VHOSTS_D/<domain_name> and
			# VHOSTS_D/system/<domain_name>
			tocopy = [
				obj(source_subdir=posixpath.join(source_vhosts_dir, vhost_name),
					target_subdir=vhost_name,
					exclude=['/logs', '/conf', '/statistics'],
					skip_if_source_not_exists=False),
				obj(source_subdir=posixpath.join(source_vhosts_dir, "system", vhost_name, "logs"),
					target_subdir=u"system/%s/logs" % vhost_name, exclude=[],
					skip_if_source_not_exists=True),
				obj(source_subdir=posixpath.join(source_vhosts_dir, "system", vhost_name, "statistics"),
					target_subdir=u"system/%s/statistics" % vhost_name, exclude=[],
					skip_if_source_not_exists=True),
				obj(source_subdir=posixpath.join(source_vhosts_dir, "system", vhost_name, "pd"),
					target_subdir=u"system/%s/pd" % vhost_name, exclude=[],
					skip_if_source_not_exists=True),
			]
		else:
			tocopy = [
				obj(source_subdir=posixpath.join(source_vhosts_dir, vhost_name),
					target_subdir=vhost_name,
					exclude=["/logs", "/conf", "/statistics", "/pd"],
					skip_if_source_not_exists=False),#, u"%s/subdomains" % vhost_name
				obj(source_subdir=posixpath.join(source_vhosts_dir, vhost_name,	"statistics", "logs"),
					target_subdir=u"system/%s/logs" % vhost_name, exclude=[], skip_if_source_not_exists=True),
				obj(source_subdir=posixpath.join(source_vhosts_dir, vhost_name,	"statistics"),
					target_subdir=u"system/%s/statistics" % (vhost_name),
					exclude=['/logs'],
					skip_if_source_not_exists=True),
				obj(source_subdir=posixpath.join(source_vhosts_dir, vhost_name,	"pd"),
					target_subdir=u"system/%s/pd" % vhost_name, exclude=[], skip_if_source_not_exists=True),
			]

		for site in subscription.converted_backup.iter_sites():
			site_vhost_name = plesk_utils.convert_wildcard_to_path(site.name.encode('idna'))
			
			target_stats_subdir = u"system/{site_vhost}/statistics".format(
					site_vhost=site_vhost_name)
			target_logs_subdir = u"system/{site_vhost}/logs".format(
					site_vhost=site_vhost_name)
			target_pd_subdir = u"system/{site_vhost}/pd".format(
					site_vhost=site_vhost_name)
			
			
			if subscription.web_source_server.plesk_version >= (10, 0): # plesk #10.x
				if subscription.web_source_server.plesk_version >= (11, 5):
					tocopy.append(obj(
						source_subdir=posixpath.join(
										source_vhosts_dir, "system",
										site_vhost_name, "pd"),
						target_subdir=target_pd_subdir, exclude=[],
						skip_if_source_not_exists=True))

					source_logs_subdir = posixpath.join(
										source_vhosts_dir, "system",
										site_vhost_name, "logs")
					source_statistics_subdir = posixpath.join(
										source_vhosts_dir, 'system',
										site_vhost_name, "statistics")
					source_statistics_exclude = []
				else:
					tocopy.append(obj(
						source_subdir=posixpath.join(
							source_vhosts_dir, site_vhost_name, "pd"
						),
						target_subdir=target_pd_subdir, exclude=[],
						skip_if_source_not_exists=True
					))

					source_logs_subdir = posixpath.join(
										source_vhosts_dir, site_vhost_name,
										"statistics", "logs")
					source_statistics_subdir = posixpath.join(
										source_vhosts_dir, site_vhost_name,
										"statistics")
					source_statistics_exclude = ["/logs"]
				
				tocopy.extend([
					obj(
						source_subdir=source_logs_subdir,
						target_subdir=target_logs_subdir, exclude=[],
						skip_if_source_not_exists=True),    # site logs
					obj(
						source_subdir=source_statistics_subdir,
						target_subdir=target_stats_subdir,
						exclude=source_statistics_exclude,
						skip_if_source_not_exists=True), # site statistics
				])
			elif subscription.web_source_server.plesk_version >= (8, 0): # plesk #8.x and #9.x
				pass

		return tocopy
