from parallels.utils import cached
from parallels.common.target_panels import TargetPanels
from parallels.common.connections.source_server import SourceServer
from parallels.target_panel_plesk.connections.target_connections import \
		PleskTargetConnections
from parallels.target_panel_ppa.connections.target_connections import \
		PPATargetConnections

class Connections(object):
	def __init__(self, config, target_panel):
		if target_panel == TargetPanels.PLESK:
			self.target = PleskTargetConnections(config)
		elif target_panel == TargetPanels.PPA:
			self.target = PPATargetConnections(config)
		else:
			assert(False)

	def check_source_servers(self):
		"""Check source servers: connections, versions, licenses, etc"""

		# By default, don't check anything
		# Override in child classes
		pass

	@cached
	def get_source_node(self, node_id):
		return SourceServer(
			node_id,
			self.get_information_servers()[node_id]
		)

	def get_information_servers(self):
		"""Get servers which could provide info about subscriptions and customers""" 
		raise NotImplementedError()
