import logging
import os

from parallels.core import messages, MigrationError
from parallels.core.actions.base.common_action import CommonAction
from parallels.core.utils.html_log import write_html_log

logger = logging.getLogger(__name__)


class GenerateHtmlLog(CommonAction):
    def get_description(self):
        """Get short description of action as string

        :rtype: str | unicode
        """
        return messages.ACTION_GENERATE_HTML_LOG_DESCRIPTION

    def get_failure_message(self, global_context):
        """Get message for situation when action failed

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :rtype: str | unicode
        """
        return messages.ACTION_GENERATE_HTML_LOG_FAILURE

    def run(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        debug_log = global_context.session_files.get_path_to_debug_log()
        html_log = global_context.session_files.get_path_to_html_log()
        if not os.path.exists(debug_log):
            raise MigrationError(messages.NO_DEBUG_LOG_IN_SESSION.format(filename=debug_log))

        write_html_log(debug_log, html_log)
        logger.info(messages.HTML_LOG_SAVED_TO.format(filename=html_log))