from parallels.core import messages
from parallels.core.actions.base.common_action import CommonAction
from parallels.core.actions.pre_migration_checks.utils import should_run_service_checks
from parallels.core.actions.utils.logging_properties import LoggingProperties
from parallels.core.hosting_check.reporting import print_service_hosting_report


class PrintTestServicesReportAction(CommonAction):
    def get_description(self):
        """Get short description of action as string

        :rtype: str | unicode
        """
        return messages.ACTION_TEST_SERVICES_PRINT_REPORT_DESCRIPTION

    def filter_action(self, global_context):
        """Check whether we should run this action or not. By default True - action should be executed.

        :type global_context: parallels.core.global_context.GlobalMigrationContext
        :rtype: bool
        """
        return should_run_service_checks(global_context)

    def get_failure_message(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        return messages.ACTION_TEST_SERVICES_PRINT_REPORT_FAILURE

    def is_critical(self):
        """If action is critical or not

        :rtype: bool
        """
        return False

    def get_logging_properties(self):
        """Get how action should be logged to migration tools end-user

        :rtype: parallels.core.actions.utils.logging_properties.LoggingProperties
        """
        return LoggingProperties(info_log=False)

    def run(self, global_context):
        """
        :type global_context: parallels.core.global_context.GlobalMigrationContext
        """
        print_service_hosting_report(global_context.test_services_report, 'test_service_report')
