from parallels.core import messages
from parallels.core.application_adjuster.application_configs.base import ApplicationConfig
from parallels.core.application_adjuster.application_configs.utils import path_endswith, replace_line
from parallels.core.utils.common import safe_format


class MagentoApplicationConfig(ApplicationConfig):
    """Class for detection and fixing Magento configuration file"""

    def get_config_file_description(self, filename):
        """Human-readable description of configuration file

        :rtype: str | unicode
        """
        return safe_format(
            messages.APPLICATION_FILE_CONFIG_DESCRIPTION,
            filename=filename, application_name='Magento'
        )

    def filename_match(self, path):
        """Check if given path looks like configuration file of Magento

        :type path: str | unicode
        :rtype: boolean
        """
        return path_endswith(path, 'app/etc/local.xml')

    def contents_match(self, contents):
        """Check if given file contents looks like configuration file of Magento

        :type contents: str | unicode
        :rtype: boolean
        """
        return 'magento' in contents.lower()

    def fix_database_hostname(self, contents, db_host_mapping):
        """Fix database hostname in configuration file of Magento

        :type contents: str | unicode
        :type db_host_mapping: dict[str | unicode, str | unicode]
        :rtype: parallels.core.utils.line_processor.ReplaceResults
        """
        # Default config has line like:
        # <host><![CDATA[10.52.143.116:3306]]></host>
        return replace_line(contents, 'host', '<host><![CDATA[', ':', db_host_mapping)