import ntpath
import posixpath

from contextlib import contextmanager


class Server(object):

    def __init__(self):
        self._session_dir = self._create_session_dir()

    @contextmanager
    def runner(self):
        """Get runner object to execute commands on the source server"""
        raise NotImplementedError()

    def is_windows(self):
        """Check if server is Windows or Linux one

        :rtype: bool
        """
        raise NotImplementedError()

    def join_file_path(self, path, *paths):
        if self.is_windows():
            return ntpath.join(path, *paths)
        else:
            return posixpath.join(path, *paths)

    def get_base_path(self, path):
        """Retrieve basic path for given file or directory

        :type path: str
        :rtype: str
        """
        if self.is_windows():
            return ntpath.dirname(path)
        else:
            return posixpath.dirname(path)

    def get_session_file_path(self, filename):
        """Return full path to a temporary file on the server by
        short file name. Function considers session directory settings
        and ensures that session directory exists on the server

        :type filename: str | unicode
        """
        return self._session_dir.get_file_path(filename)

    def get_session_dir_path(self):
        """Return path to session directory - directory where
        we should store all temporary files"""
        return self._session_dir.get_session_dir_path()

    def _create_session_dir(self):
        raise NotImplementedError()
