from parallels.core.utils.entity import Entity


class DomainModel(object):
    def get_list(self, filter_name=None):
        """Retrieve list of domains in target panel

        :type filter_name: list[str] | None
        :rtype: list[parallels.core.hosting_repository.domain.DomainEntity]
        """
        raise NotImplementedError()

    def get_by_name(self, domain_name):
        """Retrieve domain with given name from target panel

        :type domain_name: str
        :rtype: parallels.core.hosting_repository.domain.DomainEntity | None
        """
        domains = self.get_list(filter_name=[domain_name])
        return domains.pop() if len(domains) > 0 else None

    def create_from_dump(self, domain_dump, subscription_name):
        """Create domain in target panel

        :type domain_dump: parallels.core.dump.data_model.AddonDomain
        :type subscription_name: str
        """
        raise NotImplementedError()

    def set_forwarding(self, domain_name, forwarding_url, is_frame_forwarding):
        """Enable forwarding on domain with given name in target panel

        :type domain_name: str
        :type forwarding_url: str
        :type is_frame_forwarding: bool
        """
        raise NotImplementedError()

    def set_physical_hosting(self, domain_name, document_root, is_enable_ssl):
        """Enable physical hosting on domain with given name in target panel

        :type domain_name: str
        :type document_root: str
        :type is_enable_ssl: bool
        """
        raise NotImplementedError()

    def is_exists(self, domain_name, guid=None):
        """Check if domain with given name or guid exists in target panel

        :type domain_name: str
        :type guid: str
        :rtype: bool
        """
        raise NotImplementedError()


class DomainEntity(Entity):
    def __init__(self, domain_id, name, subscription_name):
        self._domain_id = domain_id
        self._name = name
        self._subscription_name = subscription_name

    @property
    def domain_id(self):
        return self._domain_id

    @property
    def name(self):
        return self._name

    @property
    def subscription_name(self):
        return self._subscription_name
