from parallels.core.migration_list.file_format import MigrationListFormat
from parallels.core.migration_list.reader.json_reader import MigrationListReaderJSON
from parallels.core.migration_list.reader.plain_reader import MigrationListReaderPlain
from parallels.core.migration_list.writer.json_writer import MigrationListWriterJSON
from parallels.core.migration_list.writer.plain_writer import MigrationListWriterPlain


def create_migration_list_reader(file_format, source_data):
    """Create reader of migration list file for specified format

    :type file_format: str | unicode
    :type source_data: parallels.core.migration_list.source_data.MigrationListSourceData
    :rtype: parallels.core.migration_list.reader.base_reader.MigrationListReaderBase
    """
    if file_format == MigrationListFormat.JSON:
        return MigrationListReaderJSON(source_data)
    else:
        return MigrationListReaderPlain(source_data)


def create_migration_list_writer(file_format, source_data):
    """Create writer of migration list file for specified format

    :type file_format: str | unicode
    :type source_data: parallels.core.migration_list.source_data.MigrationListSourceData
    :rtype: parallels.core.migration_list.writer.base_writer.MigrationListWriterBase
    """
    if file_format == MigrationListFormat.JSON:
        return MigrationListWriterJSON(source_data)
    else:
        return MigrationListWriterPlain(source_data)
