import httplib
import ssl
import urllib2
import sys
import urlparse

from parallels.core.registry import Registry
from parallels.core.utils.common import default, is_run_on_windows


def perform_http_request(url, data=None, headers=None, hostname=None):
    headers = default(headers, {})
    https_handler_args = {}

    if (sys.version_info.major, sys.version_info.minor, sys.version_info.micro) >= (2, 7, 9):
        # If we have hostname specified in explicit way, so we don't want to use hostname from URL,
        # then pass it to SSL module so it will pass it via SNI
        context = ssl._create_unverified_context(
            # Specify TLSv1 in explicit way, as other versions sometimes do not work, for example on Windows 2003
            ssl.PROTOCOL_TLSv1
        )
        https_handler_args['context'] = context
        if hostname:
            headers['Host'] = hostname
        https_handler = HTTPSHandlerWithContext(hostname=hostname, **https_handler_args)
    else:
        https_handler = HTTPSHandler(**https_handler_args)

    request = urllib2.Request(url, data, headers)
    opener = urllib2.build_opener(https_handler)

    try:
        return opener.open(request).read()
    except urllib2.HTTPError as e:
        content = e.fp.read() if e.fp is not None else None
        raise HttpClientError(e, content)


class HTTPSHandler(urllib2.HTTPSHandler):
    def https_open(self, req):

        def http_class(*args, **kwargs):
            host = urlparse.urlparse(req.get_full_url()).hostname
            if host == '127.0.0.1' and is_run_on_windows():
                ip_address = '127.0.0.1'
            else:
                ip_address = Registry.get_instance().get_context().conn.target.main_node_ip

            return httplib.HTTPSConnection(source_address=(ip_address, 0), *args, **kwargs)

        return self.do_open(http_class, req)


class HTTPSHandlerWithContext(urllib2.HTTPSHandler):
    def __init__(self, hostname, **kwargs):
        urllib2.HTTPSHandler.__init__(self, **kwargs)
        self.hostname = hostname

    def https_open(self, req):
        host = urlparse.urlparse(req.get_full_url()).hostname
        if host == '127.0.0.1' and is_run_on_windows():
            ip_address = '127.0.0.1'
        else:
            ip_address = Registry.get_instance().get_context().conn.target.main_node_ip

        if self.hostname is not None:
            server_hostname = self.hostname

            class HTTPSConnectionWithHostname(httplib.HTTPSConnection):
                def connect(self):
                    httplib.HTTPConnection.connect(self)
                    self.sock = self._context.wrap_socket(self.sock, server_hostname=server_hostname)

            def http_class(*args, **kwargs):
                return HTTPSConnectionWithHostname(source_address=(ip_address, 0), *args, **kwargs)
        else:
            def http_class(*args, **kwargs):
                return httplib.HTTPSConnection(source_address=(ip_address, 0), *args, **kwargs)

        return self.do_open(http_class, req, context=self._context)


class HttpClientError(Exception):
    def __init__(self, cause, content):
        self.cause = cause
        self.content = content

    def __str__(self):
        return repr(self)

    def __repr__(self):
        return "HttpClientError(%s, %r)" % (self.cause, self.content)
