"""Path descriptors to different mail hosting-related directories"""


class MailHostingPath(object):
    """Base class for all web hosting-related paths"""
    pass


class MailboxDirectory(MailHostingPath):
    """Path to mailbox mail directory"""
    def __init__(self, mailbox_name):
        self.mailbox_name = mailbox_name

    def __str__(self):
        return self.mailbox_name


class MailDomainDirectory(MailHostingPath):
    """Path to whole domain mail directory"""
    pass