
class SubscriptionOperation(object):
    OPERATION_MIGRATED = 'migrated'
    OPERATION_CONTENT_SYNCED = 'content-synced'
    OPERATION_POST_MIGRATION_CHECKS = 'post-migration-checks'
    OPERATION_DNS_SWITCHED = 'dns-switched'


def command_name_to_operation(command_name):
    """Get operation name (as in migration status file) by CLI command name

    :type command_name: str | unicode
    :rtype: str | unicode
    """
    if command_name == 'transfer-accounts':
        return SubscriptionOperation.OPERATION_MIGRATED
    elif command_name in ['copy-content', 'copy-web-content', 'copy-mail-content', 'copy-db-content']:
        return SubscriptionOperation.OPERATION_CONTENT_SYNCED
    elif command_name == 'set-dns-forwarding':
        return SubscriptionOperation.OPERATION_DNS_SWITCHED
    elif command_name == 'undo-dns-forwarding':
        # We have single status for set and undo operations for DNS forwarding
        return SubscriptionOperation.OPERATION_DNS_SWITCHED
    else:
        return None
