from parallels.core.hosting_repository.mail_account import MailAccountModel
from parallels.plesk.hosting_repository.base import PleskBaseModel
from parallels.plesk.hosting_repository.utils.cli.mail import MailAccountCreateCli, MailAccountSetForwardingCli, \
    MailAccountsSetAlisesCli
from parallels.plesk.hosting_repository.utils.db import db_query


class PleskMailAccountModel(MailAccountModel, PleskBaseModel):
    def create_from_dump(self, mail_account_dump):
        """Create mail account in target Plesk

        :type mail_account_dump: parallels.core.dump.entity.mail_account.MailAccount
        :type domain_name: str
        """
        command = MailAccountCreateCli(
            runner=self.plesk_cli_runner,
            mail_account_name=mail_account_dump.name,
            mail_user_password=mail_account_dump.password,
            mail_user_password_type=mail_account_dump.password_type,
            is_enable_cp_access=mail_account_dump.is_enable_cp_access,
            is_enable_mailbox=mail_account_dump.is_enable_mailbox
        )
        command.run()

    def set_forwarding(self, mail_account_name, is_enable_forwarding, forwarding_addresses):
        """Set forwarding for given mail user in target Plesk

        :type mail_account_name: str
        :type is_enable_forwarding: bool
        :type forwarding_addresses: list[str]
        """
        command = MailAccountSetForwardingCli(
            self.plesk_cli_runner,
            mail_account_name,
            is_enable_forwarding,
            forwarding_addresses
        )
        command.run()

    def set_aliases(self, mail_account_name, aliases):
        """Set aliases for given mail account in target Plesk

        :type mail_account_name: str
        :type aliases: list[str]
        """
        command = MailAccountsSetAlisesCli(self.plesk_cli_runner, mail_account_name, aliases)
        command.run()

    def is_exists(self, mail_user_name, domain_name):
        """Check if mail user with given name exists in target Plesk for given domain

        :type mail_user_name: str
        :type domain_name: str
        :rtype: bool
        """
        query = """
            SELECT mail.id
            FROM mail join domains on mail.dom_id = domains.id
            WHERE mail.mail_name = %(mail_user_name)s AND domains.name = %(domain_name)s
        """
        result = db_query(self.plesk_server, query, dict(
            mail_user_name=mail_user_name,
            domain_name=domain_name.encode('idna')
        ))
        return len(result) > 0
