from parallels.plesk.hosting_repository.utils.cli.base import BaseCli


class ClientDisableCli(BaseCli):
    def __init__(self, runner, customer_username):
        """Construct command to disable customer in Plesk via CLI

        :type runner: parallels.core.utils.plesk_cli_runner.PleskCLIRunnerBase
        :type customer_username: str
        """
        super(ClientDisableCli, self).__init__(runner)
        self._customer_username = customer_username

    @property
    def name(self):
        return 'client'

    def _get_args(self):
        return [
            '--update', self._customer_username,
            '-status', 'disabled'
        ]


class ClientExternalIdCli(BaseCli):
    def __init__(self, runner, username, external_id):
        super(ClientExternalIdCli, self).__init__(runner)
        self._username = username
        self._external_id = external_id

    @property
    def name(self):
        return 'client'

    def _get_args(self):
        return [
            '--update', self._username,
            '-external-id', self._external_id
        ]
