from parallels.plesk.hosting_repository.utils.cli.base import BaseCli
from parallels.plesk.hosting_repository.utils.cli.utils import add_password_env


class MailAccountCreateCli(BaseCli):
    def __init__(
        self, runner, mail_account_name, mail_user_password, mail_user_password_type,
        is_enable_cp_access, is_enable_mailbox
    ):
        super(MailAccountCreateCli, self).__init__(runner)
        self._mail_account_name = mail_account_name
        self._mail_user_password = mail_user_password
        self._mail_user_password_type = mail_user_password_type
        self._is_enable_cp_access = is_enable_cp_access
        self._is_enable_mailbox = is_enable_mailbox

    @property
    def name(self):
        return 'mail'

    def _get_args(self):
        args = [
            '--create', self._mail_account_name,
            '-mailbox', 'true' if self._is_enable_mailbox else 'false'
        ]
        if self._mail_user_password is not None:
            args.extend(['-passwd', ''])
            if self._mail_user_password_type != 'plain':
                args.extend(['-passwd_type', self._mail_user_password_type])
        if self._is_enable_cp_access:
            args.extend(['-cp-access', 'true'])
        return args

    def _get_env(self):
        env = {}
        if self._mail_user_password is not None:
            env = add_password_env(env, self._mail_user_password, self._mail_user_password_type)
        return env


class MailAccountSetForwardingCli(BaseCli):
    def __init__(self, runner, mail_account_name, is_enable_forwarding, forwarding_addresses):
        super(MailAccountSetForwardingCli, self).__init__(runner)
        self._mail_account_name = mail_account_name
        self._is_enable_forwarding = is_enable_forwarding
        self._forwarding_addresses = forwarding_addresses

    @property
    def name(self):
        return 'mail'

    def _get_args(self):
        args = [
            '--update', self._mail_account_name,
            '-forwarding', 'true' if self._is_enable_forwarding else 'false'
        ]
        if self._is_enable_forwarding and len(self._forwarding_addresses) > 0:
            forwarding_addresses_str = ','.join(self._forwarding_addresses)
            args.extend(['-forwarding-addresses', 'add:%s' % forwarding_addresses_str])
        return args


class MailAccountsSetAlisesCli(BaseCli):
    def __init__(self, runner, mail_account_name, aliases):
        super(MailAccountsSetAlisesCli, self).__init__(runner)
        self._mail_account_name = mail_account_name
        self._aliases = aliases

    @property
    def name(self):
        return 'mail'

    def _get_args(self):
        args = [
            '--update', self._mail_account_name,
        ]
        if len(self._aliases) > 0:
            aliases_str = ','.join(self._aliases)
            args.extend(['-aliases', 'add:%s' % aliases_str])
        return args
