import ntpath
import logging

from parallels.core.actions.content.web.copy_windows_content_base import CopyWindowsWebContent
from parallels.plesk.source.custom import messages
from parallels.core.utils.paths.copy_web_content import BaseWebPathConverter
from parallels.core.utils.paths import web_paths

logger = logging.getLogger(__name__)


class CustomPanelCopyWindowsWebContent(CopyWindowsWebContent):
    """Copy web content from custom panel's Windows server (access to the server was provided in configuration file)"""

    @staticmethod
    def _get_source_rsync_converter():
        """Get converter from abstract source path to concrete path for rsync

        :rtype: parallels.core.utils.paths.copy_web_content.BaseWebPathConverter
        """
        return SourceRsyncVhostWebPathConverter()


class SourceRsyncVhostWebPathConverter(BaseWebPathConverter):
    """Class to convert abstract path descriptor to concrete path for rsync on source server"""

    def expand(self, path, server):
        """Convert abstract path descriptor to concrete absolute path for rsync on source server

        :type path: parallels.core.utils.web_paths.WebHostingPath
        :rtype: str | unicode
        """
        if isinstance(path, web_paths.AbsolutePath):
            # For custom panel migration, "/cygdrive" is specified as virtual hosts root to have ability to copy
            # files from any absolute path on the source server. So, here we convert absolute path to path
            # relative to "/cygdrive", and prepend section name from rsyncd.conf, which is name 'vhosts'.
            # For example, C:\Windows\System32 will be converted to '/vhosts/c/Windows/System32/', which
            # means '/cygdrive/c/Windows/System32/' for rsync server installed on the source server
            drive, rel_path = ntpath.splitdrive(path.absolute_path)
            return 'vhosts/%s/%s/' % (drive[:1].lower(), rel_path.replace('\\', '/').strip('/'))
        else:
            assert False, messages.UNSUPPORTED_SOURCE_WEB_PATH_TYPE
