from parallels.core.converter.adapter.client_subscription_converter import ClientSubscriptionConverterAdapter
from parallels.plesk.source.expand.converter.clients_subscriptions import \
    ExpandToPleskClientsAndSubscriptionsConverter


class ExpandToPleskClientSubscriptionConverterAdapter(ClientSubscriptionConverterAdapter):
    def convert(self, global_context, reseller_plans, hosting_plans, resellers, report):
        """
        :type global_context: parallels.plesk.source.expand.global_context.ExpandGlobalMigrationContext
        :type reseller_plans: list[parallels.core.target_data_model.ResellerPlan]
        :type hosting_plans: dict[str|None, list[parallels.core.target_data_model.HostingPlan]]
        :type resellers: list[parallels.core.target_data_model.Reseller]
        :type report: parallels.core.reports.model.report.Report
        """
        converter = ExpandToPleskClientsAndSubscriptionsConverter()
        return converter.convert(
            global_context, resellers, global_context.expand_data, report
        )