from parallels.core import MigrationError
from parallels.plesk.source.plesk import messages
from parallels.plesk.source.plesk.capability_dump.model.plesk import PleskCapabilityDumpModel


def create_plesk_capability_model(dump_agent, plesk_version, selection):
    """Create corresponding capability dump model by Plesk version

    :type dump_agent: parallels.core.utils.pmm.agent.PmmMigrationAgentBase
    :type plesk_version: tuple[str | unicode]
    :type selection: parallels.core.utils.pmm.agent.DumpAll|parallels.core.utils.pmm.agent.DumpSelected
    :rtype: parallels.plesk.source.plesk.capability_dump.model.base.model.CapabilityDumpModel
    """
    major_version = int(plesk_version[0])
    minor_version = int(plesk_version[1]) if len(plesk_version) > 1 else 0
    if (major_version, minor_version) >= (12, 0):
        return PleskCapabilityDumpModel(selection, dump_agent)
    raise MigrationError(
        messages.PLESK_VERSION_NOT_SUPPORTED_BY_CAPABILITY_DUMP.format(plesk_version='.'.join(plesk_version))
    )
