# Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.
package HostingDumper;

use strict;
eval{require warnings;1;};
use Logging;
use DAL;

my %phpHandlers;

sub getPhpHandlers {
  return \%phpHandlers if %phpHandlers;
  
  my $phpHandlersXml = DAL::getPhpHandlers();
  return unless $phpHandlersXml;

  my $phpHandlersConfigurationXml = DAL::getPhpHandlersConfiguration();
  
  eval {require XML::Simple; 1;};
  foreach my $handlerName (keys %{$phpHandlersXml}) {
    my $xs = XML::Simple->new(ForceArray => 0, SuppressEmpty => '');
    my $handlerInfo = eval { $xs->XMLin($phpHandlersXml->{$handlerName}, KeyAttr => []) };
    next unless $handlerInfo;

    $phpHandlers{$handlerName}{'id'} = $handlerInfo->{'id'};
    $phpHandlers{$handlerName}{'type'} = $handlerInfo->{'type'};
    $phpHandlers{$handlerName}{'typeName'} = $handlerInfo->{'typeName'};
    $phpHandlers{$handlerName}{'version'} = $handlerInfo->{'version'};
    $phpHandlers{$handlerName}{'displayname'} = $handlerInfo->{'displayname'};
    $phpHandlers{$handlerName}{'registered'} = $handlerInfo->{'registered'};
    $phpHandlers{$handlerName}{'enabled'} = 'true';

    next unless $phpHandlersConfigurationXml && defined($phpHandlersConfigurationXml->{$handlerName});
    my $handlerConfiguration = eval { $xs->XMLin($phpHandlersConfigurationXml->{$handlerName}, KeyAttr => []) };
    next unless $handlerConfiguration;

    $phpHandlers{$handlerName}{'enabled'} = $handlerConfiguration->{'enabled'};
  }
  
  return \%phpHandlers;
}

sub getScripting {
  my ($hosting) = @_;
  
  my ($xmlName, $fieldName);

  my %hostingScripting = (
    'ssi'           => 'ssi',
    'php'           => 'php',
    'php_safe_mode' => 'php_safe_mode',
    'cgi'           => 'cgi',
    'perl'          => 'perl',
    'asp'           => 'asp',
    'python'        => 'python',
    'coldfusion'    => 'coldfusion',
    'asp_dot_net'   => 'asp_dot_net',
    'managed_runtime_version'  => 'managed_runtime_version',
    'fastcgi'       => 'fastcgi',
    'miva'          => 'miva',
    'php_handler_type' => 'php_handler_type',
    'php_handler_id'   => 'php_handler_id'
  );
  
  my %scripting;
  my %phpSettings;
  
  while ( ( $xmlName, $fieldName ) = each(%hostingScripting) ) {
    if ( defined( $hosting->{$fieldName} ) ) {
      if ( $hosting->{$fieldName} eq 'true' or $hosting->{$fieldName} eq 'false' ) {
        if ( $fieldName eq 'php_safe_mode' ) {
          $phpSettings{'safe_mode'} = $hosting->{$fieldName} eq 'true' ? 'on' : 'off';
        } else {
          $scripting{$xmlName} = $hosting->{$fieldName};
        }
      }
      elsif ( $fieldName eq 'php_handler_type') {
        $scripting{$xmlName} = $hosting->{$fieldName} if $hosting->{$fieldName} && !exists $scripting{$xmlName};
      }
      elsif ($fieldName eq 'php_handler_id') { # appeared at 11.5.19
        my $phpHandlers = getPhpHandlers();
        if ($phpHandlers) {
          my $phpHandler = $phpHandlers->{$hosting->{$fieldName}};
          $scripting{'php_handler_id'} = $phpHandler->{'id'};
          $scripting{'php_handler_type'} = $phpHandler->{'type'};
          $scripting{'php_version'} = $phpHandler->{'version'};
        }
      }
      elsif ( $fieldName eq 'managed_runtime_version') {
        $scripting{$xmlName} = $hosting->{$fieldName} if $hosting->{$fieldName};
      }
    }
  }

  if (not exists $scripting{'php'} or $scripting{'php'} eq 'false') {
    delete $scripting{'php_handler_type'} if exists $scripting{'php_handler_type'};
  } else {
    $scripting{'php_handler_type'} = 'module' if not exists $scripting{'php_handler_type'};
  }
  
  delete $scripting{'managed_runtime_version'} if exists $scripting{'managed_runtime_version'} and ( not exists $scripting{'asp_dot_net'} or $scripting{'asp_dot_net'} eq 'false');
  
  return (\%phpSettings, \%scripting);
}

sub getSysUserInfo {
  my ( $sysUserId ) = @_;
  
  return unless $sysUserId;
  
  my $sysUser = DAL::getSysUserInfo( $sysUserId );
  
  unless ($sysUser) {
    my $msg = "Broken referencial integrity: Sys user id $sysUserId is not found in sys_users";
    print STDERR "$msg\n";
    Logging::warning($msg,'BrokenDbIntegrity');
    return;
  }

  return $sysUser;
}

sub getDomainRoot {
  my ($domainAsciiName, $remoteWebNodes, $isSystem) = @_;
  my $domainRoot;
  
  $isSystem ||= 0;
  
  if (exists $remoteWebNodes->{$domainAsciiName} && defined $remoteWebNodes->{$domainAsciiName}) {
    $domainRoot = PleskStructure::getServiceNodeProperty($remoteWebNodes->{$domainAsciiName}, "HTTPD_VHOSTS_D");
    $domainRoot =~ s/[\\\/]$//;
    my $isWinHost = PleskStructure::getServiceNodeProperty($remoteWebNodes->{$domainAsciiName}, "OS_WIN");
    my $dirSeparator = ($isWinHost eq 'true') ? "\\" : "/";
    $domainRoot .= $dirSeparator;
    $domainRoot .= 'system' . $dirSeparator if $isSystem;
    $domainRoot .= $domainAsciiName;
    Logging::debug("Remote domain root: " . $domainRoot);
  } else {  
    $domainRoot = AgentConfig::get("HTTPD_VHOSTS_D");

    if ($isSystem) {
      $domainRoot .= "/system";
    }

    $domainRoot .= "/$domainAsciiName";

    Logging::debug("Local domain root: " . $domainRoot);
  }
  return $domainRoot;
}

sub getSystemDomainRoot {
  my ($domainAsciiName, $remoteWebNodes) = @_;
  my $domainSystemRoot = getDomainRoot($domainAsciiName, $remoteWebNodes, 1);
  return $domainSystemRoot;
}

sub getWebspaceRoot {
  my ($domainAsciiName, $remoteWebNodes) = @_;
  my $domainRoot = getDomainRoot($domainAsciiName, $remoteWebNodes);
  return $domainRoot unless ( PleskVersion::atLeast( 10, 0, 0 ) );

  my $home = DAL::getSysUserHomeByDomainName($domainAsciiName);

  if ($home ne $domainRoot) {
    return $home;
  }

  return $domainRoot;
}

1;