# Copyright 1999-2016. Parallels IP Holdings GmbH. All Rights Reserved.
package ObjectsFilter;

use strict;

sub new {
  my $self = {};
  bless( $self, shift );
  $self->_init(@_);
  return $self;
}

sub _init {
  my ( $self, $pleskX ) = @_;
  $self->{agent} = $pleskX;  
}

sub filterSelectedResellers {
  my( $self, $input ) = @_;
  my @ret = @{$input};
  @ret = HelpFuncs::arrayIntersection( \@ret, $self->{agent}->{resellers} ) if exists $self->{agent}->{resellers};
  @ret = HelpFuncs::arrayDifference( \@ret, $self->{agent}->{exclude_resellers} ) if exists $self->{agent}->{exclude_resellers};
  return @ret;
}

sub filterSelectedClients {
  my( $self, $input ) = @_;
  my @ret = @{$input};
  @ret = HelpFuncs::arrayIntersection( \@ret, $self->{agent}->{clients} ) if exists $self->{agent}->{clients};
  @ret = HelpFuncs::arrayDifference( \@ret, $self->{agent}->{exclude_clients} ) if exists $self->{agent}->{exclude_clients};
  return @ret;
}

sub filterSelectedDomains {
  my( $self, $input ) = @_;
  my @ret = @{$input};
  @ret = HelpFuncs::arrayIntersection( \@ret, $self->{agent}->{domains} ) if exists $self->{agent}->{domains};
  @ret = HelpFuncs::arrayDifference( \@ret, $self->{agent}->{exclude_domains} ) if exists $self->{agent}->{exclude_domains};
  return @ret;
}

1;
