from parallels.core.utils.entity import Entity


class CustomButton(Entity):
    LEVEL_ADMIN = '1'
    LEVEL_RESELLER = '2'
    LEVEL_CLIENT = '4'
    LEVEL_DOMAIN_ADMIN = '8'
    LEVEL_MAIL_USER = '16'

    def __init__(self, custom_button_id, level_id, level, url, options, text, image_file, context_help, sort_key, place):
        self._custom_button_id = custom_button_id
        self._level_id = level_id
        self._level = level
        self._url = url
        self._options = options
        self._text = text
        self._image_file = image_file
        self._context_help = context_help
        self._sort_key = sort_key
        self._place = place

    @property
    def custom_button_id(self):
        """
        :rtype: str | unicode
        """
        return self._custom_button_id

    @property
    def level_id(self):
        """
        :rtype: str | unicode
        """
        return self._level_id

    @property
    def level(self):
        """
        :rtype: str | unicode
        """
        return self._level

    @property
    def url(self):
        """
        :rtype: str | unicode
        """
        return self._url

    @property
    def options(self):
        """
        :rtype: str | unicode
        """
        return self._options

    @property
    def text(self):
        """
        :rtype: str | unicode
        """
        return self._text

    @property
    def image_file(self):
        """
        :rtype: str | unicode
        """
        return self._image_file

    @property
    def context_help(self):
        """
        :rtype: str | unicode
        """
        return self._context_help

    @property
    def sort_key(self):
        """
        :rtype: str | unicode
        """
        return self._sort_key

    @property
    def place(self):
        """
        :rtype: str | unicode
        """
        return self._place
