from parallels.core.utils.entity import Entity


class DynamicIpSecurity(Entity):
    def __init__(
        self, domain_id, is_deny_by_concurrent_requests, max_concurrent_requests,
        is_deny_by_request_rate, max_requests, request_interval,
    ):
        self._domain_id = domain_id
        self._is_deny_by_concurrent_requests = is_deny_by_concurrent_requests
        self._max_concurrent_requests = max_concurrent_requests
        self._is_deny_by_request_rate = is_deny_by_request_rate
        self._max_requests = max_requests
        self._request_interval = request_interval

    @property
    def domain_id(self):
        """
        :rtype: str | unicode
        """
        return self._domain_id

    @property
    def is_deny_by_concurrent_requests(self):
        """
        :rtype: str | unicode
        """
        return self._is_deny_by_concurrent_requests

    @property
    def max_concurrent_requests(self):
        """
        :rtype: str | unicode
        """
        return self._max_concurrent_requests

    @property
    def is_deny_by_request_rate(self):
        """
        :rtype: str | unicode
        """
        return self._is_deny_by_request_rate

    @property
    def max_requests(self):
        """
        :rtype: str | unicode
        """
        return self._max_requests

    @property
    def request_interval(self):
        """
        :rtype: str | unicode
        """
        return self._request_interval
