# coding=utf-8
"""
Messages overrides: messages specific to GUI
"""
from parallels.core.utils.message_utils import multi_line_message, single_line_message

ACTION_CHECK_SOURCE_ACCOUNT_NOT_BUILT_IN_AUTO = multi_line_message("""
    Interaction with source server '{source_ip}' is going on not via built-in administrator account.

    Check source host administrator login and password.
    It should be credentials of the built-in administrator account on the source server.
""")
INSUFFICIENT_DISK_SPACE_TARGET_WINDOWS_SOLUTION = multi_line_message("""
    To resolve the issue you could:
    1) Increase disk space on the server.
    2) Migrate subscriptions to another server.

    Fix found issues and restart migration.
""")
INSUFFICIENT_WINDOWS_DISK_SPACE_SOURCE_SOLUTION = multi_line_message("""
    To resolve the issue you could:
    1) Free disk space on the disk.
    2) Change 'session-dir' config.ini parameter for the server so it points
    to directory located on a disk that has enough space.

    Fix found issues and restart migration.
""")
INSUFFICIENT_DISK_SPACE_SOLUTION = multi_line_message("""
    To resolve the issue you could:
    1) Increase disk space on the server.
    2) Migrate subscriptions to another server.

    Fix found issues and restart migration.
""")
UNABLE_CONNECT_BY_IMAP_PORT = multi_line_message("""
    Unable to connect to {node} by IMAP ({port_number} port).
    Please check that:
    1) There are no firewall rules blocking IMAP connections from the current server to the source server.
    2) IMAP server is running on the source server
""")
SESSION_DIR_INSUFFICIENT_DISK_SPACE_SOURCE_SOLUTION = multi_line_message("""
    To resolve the issue, free disk space for the partition.
    Fix found issues and restart migration.
""")
ACTION_TRANSFER_APS_PACKAGES_FAILURE_SOLUTION = single_line_message("""
    Old and custom APS applications will be likely not registered in target panel as APS applications (still migration
    tools will try to transfer their files and databases). To fix the issue manually, you could try to register APS
    packages manually in the target panel, then restart migration for affected subscriptions.
""")
INFRASTRUCTURE_CHECK_DB_ISSUES = multi_line_message("""
    %s
    Fix found issues and restart migration.
    If the issues are not fixed, it will be not possible to transfer databases for the following subscription(s): %s
""")
INFRASTRUCTURE_CHECK_CONTENT_ISSUES_SUBSCRIPTION = multi_line_message("""
    %s
    Fix found issues and restart migration.
    If the issues are not fixed, it will be not possible to transfer %s for the following subscription(s): %s
""")
INFRASTRUCTURE_CHECK_WEB_CONTENT_ISSUES_DOMAINS = multi_line_message("""
    {reason}
    Fix found issues and restart migration.
    If the issues are not fixed, it will be not possible to transfer web files for the following domain(s): {domains}
""")