from parallels.core.utils.entity import Entity


class Reseller(Entity):
    """Shallow information about client"""
    def __init__(self, reseller_id, login, contact_name, subscription_id):
        self._reseller_id = reseller_id
        self._login = login
        self._contact_name = contact_name
        self._subscription_id = subscription_id

    @property
    def reseller_id(self):
        """Reseller's ID

        :rtype: str | unicode
        """
        return self._reseller_id

    @property
    def login(self):
        """Reseller's login

        :rtype: str | unicode
        """
        return self._login

    @property
    def contact_name(self):
        """Reseller's contact name (usually first name and last name)

        :rtype: str | unicode
        """
        return self._contact_name

    @property
    def subscription_id(self):
        """Subscription ID to which reseller is assigned to

        If reseller is custom (not assigned to any plan), this property is None

        :rtype: str | unicode | None
        """
        return self._subscription_id
